#/bin/env bash

# 计算当前目录
CURRENT_DIR=$(cd `dirname $0`; pwd)
if [ "$(id -u)" -ne 0 ]; then
    SUDO="sudo"
fi

$SUDO apt-get update
check_and_install() {
    if ! which $1 > /dev/null 2>&1; then
        $SUDO apt-get install -y $2
    fi
}

check_and_install aarch64-linux-gnu-gcc gcc-aarch64-linux-gnu
check_and_install cmake cmake
check_and_install gcc gcc
check_and_install g++ g++


build_target() {
    
    local AARCH=$1
    local PKG_NAME=$2

    # 进入 ${PKG_NAME} 目录，检查是否存在 build 目录，不存在则创建
    echo ">> Build <${PKG_NAME}> Now..."
    cd ${PKG_NAME}
    if [ -d build ]; then
        rm -rf build
    fi
    mkdir build && cd build
    CC=${AARCH}-linux-gnu-gcc CXX=${AARCH}-linux-gnu-g++ cmake -DCMAKE_BUILD_TYPE=Release .. >> /dev/null
    make -j4 >> /dev/null
    cd ${CURRENT_DIR}

    echo ">> Build <${PKG_NAME}> Done."

    # 进行打包处理
    if [ ! -d package ]; then
        mkdir package
    fi

    echo ">> Pack <${PKG_NAME}> Now..."
    if [ -d package/${PKG_NAME} ]; then
        rm -rf package/${PKG_NAME}
    fi

    mkdir -p package/${PKG_NAME}-${AARCH}
    cp -ra ${PKG_NAME}/build/${PKG_NAME} package/${PKG_NAME}-${AARCH}
    cp -ra ${PKG_NAME}/lib/${AARCH}/* package/${PKG_NAME}-${AARCH}
    cp -ra ${PKG_NAME}/config/config.json package/${PKG_NAME}-${AARCH}

    cd package && tar -zvcf ${PKG_NAME}-${AARCH}.tar.gz ${PKG_NAME}-${AARCH} >> /dev/null && rm -rf ${PKG_NAME}-${AARCH} && cd - >> /dev/null
}

build_target aarch64 traffic_light
build_target x86_64 traffic_light

echo ">> Pack Traffic Light Done."

if [ ! -f /usr/lib/x86_64-linux-gnu/libmosquitto.so ]; then
    $SUDO apt-get install libmosquitto-dev -y
fi

if ! which protoc > /dev/null 2>&1; then
    $SUDO apt install protobuf-compiler libprotobuf-dev -y
fi

echo '>> Build Traffic Light Controller Now...'
cd ${CURRENT_DIR}/traffic_light_controller
if [ -d build ]; then
    rm -rf build
fi
rm src/proto/*.pb.*
mkdir build && cd build
cmake -DCMAKE_BUILD_TYPE=Release .. >> /dev/null
make -j4 >> /dev/null
cd ${CURRENT_DIR}

echo '>> Build Traffic Light Controller Done.'

echo '>> Package Traffic Light Controller Now...'

if [ -d package/traffic_light_controller ]; then
    rm -rf package/traffic_light_controller
fi

mkdir -p package/traffic_light_controller
cp -ra traffic_light_controller/build/traffic_light_controller package/traffic_light_controller
cp -ra traffic_light_controller/config/config.json package/traffic_light_controller
cp -ra /usr/lib/x86_64-linux-gnu/libmosquitto.so* package/traffic_light_controller
cp -ra /usr/lib/x86_64-linux-gnu/libstdc++.so* package/traffic_light_controller
cp -ra /lib/x86_64-linux-gnu/libssl.so* package/traffic_light_controller
cp -ra /lib/x86_64-linux-gnu/libcrypto.so* package/traffic_light_controller

cd package && tar -zvcf traffic_light_controller.tar.gz traffic_light_controller >> /dev/null && rm -rf traffic_light_controller && cd - >> /dev/null

echo '>> Package Traffic Light Controller Done.'

echo '>> Build Done.'

cd ${CURRENT_DIR}

ls -lh package
