# TrafficLight API

TrafficLight API 提供将红绿灯状态通过 MQTT 推送给平台的功能，同时可接收从服务端订阅灯的状态控制命令的功能。

## 1. 安装

1. 安装依赖

```bash
sudo apt install libprotobuf-dev protobuf-compiler
sudo apt install libmosquitto-dev
```

2. 集成代码

通过源码的方式集成到项目中，将本仓库代码完整拷贝至项目目录下，例如项目主目录。

在 CMakeLists.txt 文件中添加以下内容

```cmake
add_subdirectory(${CMAKE_SOURCE_DIR}/mqtt-api)
```

为目标添加库依赖

```cmake
target_link_libraries(<NAME-OF-TARGET>
    ...
    other deps
    ...
    pthread
    protobuf
    mosquitto
    traffic_light_api
)
```

## 2. 接口说明

- 单灯控制接口示例

```c++
#include <api/traffic_light.hpp>

void on_control_traffic_light(const std::string& id, const fleet::LightStatus&)
{
    // Do something with id and cmd
}
int main(int argc, char *argv[])
{
    // Step0. 初始化 mqtt 客户端
    TrafficLight::run_mqtt_client("127.0.0.1", 1883, "admin", "public");

    // Step1. 创建 TrafficLightArray 对象
    TrafficLight tl("1", std::bind(on_control_traffic_light, std::placeholders::_1, std::placeholders::_2));

    // Step2. 更新交通灯状态
    tl.update(fleet::LightStatus::LIGHT_RED); // 将当前全部灯状态更新为 RED, 并发布至 MQTT 服务器

    return 0;
}

```

- 多灯控制接口示例

```c++
#include <api/traffic_light.hpp>

void on_control_traffic_light(const TrafficLight& light, const fleet::LightStatus& cmd)
{
    // Do something with light and cmd
}
int main(int argc, char *argv[])
{
    // Step0. 初始化 mqtt 客户端
    TrafficLight::run_mqtt_client("127.0.0.1", 1883, "admin", "public");

    // Step1. 创建 TrafficLightArray 对象
    TrafficLightArray tla(
        "/traffic_light/status",
        "/traffic_light/control",
        std::bind(on_control_traffic_light, std::placeholders::_1, std::placeholders::_2));

    // Step2. 添加交通灯
    tla.add_light("1"); // 无经纬度信息，默认为 0.0
    tla.add_light("2"); // 无经纬度信息，默认为 0.0
    tla.add_light("3", 39.123, 120.123, 50.0); // 指定经纬度信息
    tla.add_light("4"); // 无经纬度信息，默认为 0.0

    // Step3.1. 更新交通灯状态
    tla.update("1", fleet::LightStatus::LIGHT_RED);    // 更新 ID: 1 灯状态为 RED
    tla.update("2", fleet::LightStatus::LIGHT_GREEN);  // 更新 ID: 2 灯状态为 GREEN
    tla.update("3", fleet::LightStatus::LIGHT_YELLOW); // 更新 ID: 3 灯状态为 YELLOW
    tla.update("4", fleet::LightStatus::LIGHT_RED);    // 更新 ID: 4 灯状态为 RED

    // Step3.2. 同时更新多个交通灯状态
    tla.update(fleet::LightStatus::LIGHT_RED); // 将当前全部灯状态更新为 RED

    // Step4. 发布交通灯状态
    tla.publish();

    return 0;
}

```
