/**
 * @file traffic_light.cpp
 * @author zhoutong (zhoutotong@qq.com)
 * @brief 
 * @version 0.1
 * @date 2024-08-21
 * 
 * @copyright Copyright (c) 2024
 * 
 */
#include <api/traffic_light.hpp>

void on_control_traffic_light(const std::string& id, const fleet::LightStatus&)
{
    // Do something with id and cmd
}
int main(int argc, char *argv[])
{
    // Step0. 初始化 mqtt 客户端
    TrafficLight::run_mqtt_client("127.0.0.1", 1883, "admin", "public");

    // Step1. 创建 TrafficLightArray 对象
    TrafficLight tl("1", std::bind(on_control_traffic_light, std::placeholders::_1, std::placeholders::_2));

    // Step2. 更新交通灯状态
    tl.update(fleet::LightStatus::LIGHT_RED); // 将当前全部灯状态更新为 RED, 并发布至 MQTT 服务器

    return 0;
}
