/**
 * @file multi_traffic_light.cpp
 * @author zhoutong (zhoutotong@qq.com)
 * @brief 
 * @version 0.1
 * @date 2024-08-21
 * 
 * @copyright Copyright (c) 2024
 * 
 */

#include <api/traffic_light.hpp>

void on_control_traffic_light(const TrafficLight& light, const fleet::LightStatus& cmd)
{
    // Do something with light and cmd
}
int main(int argc, char *argv[])
{
    // Step0. 初始化 mqtt 客户端
    TrafficLight::run_mqtt_client("127.0.0.1", 1883, "admin", "public");

    // Step1. 创建 TrafficLightArray 对象
    TrafficLightArray tla(
        "/traffic_light/status",
        "/traffic_light/control",
        std::bind(on_control_traffic_light, std::placeholders::_1, std::placeholders::_2));

    // Step2. 添加交通灯
    tla.add_light("1"); // 无经纬度信息，默认为 0.0
    tla.add_light("2"); // 无经纬度信息，默认为 0.0
    tla.add_light("3", 39.123, 120.123, 50.0); // 指定经纬度信息
    tla.add_light("4"); // 无经纬度信息，默认为 0.0

    // Step3.1. 更新交通灯状态
    tla.update("1", fleet::LightStatus::LIGHT_RED);    // 更新 ID: 1 灯状态为 RED
    tla.update("2", fleet::LightStatus::LIGHT_GREEN);  // 更新 ID: 2 灯状态为 GREEN
    tla.update("3", fleet::LightStatus::LIGHT_YELLOW); // 更新 ID: 3 灯状态为 YELLOW
    tla.update("4", fleet::LightStatus::LIGHT_RED);    // 更新 ID: 4 灯状态为 RED

    // Step3.2. 同时更新多个交通灯状态
    tla.update(fleet::LightStatus::LIGHT_RED); // 将当前全部灯状态更新为 RED

    // Step4. 发布交通灯状态
    tla.publish();

    return 0;
}
