/**
 * @file traffic_light.hpp
 * @author zhoutong (zhoutotong@qq.com)
 * @brief 
 * @version 0.1
 * @date 2024-08-21
 * 
 * @copyright Copyright (c) 2024
 * 
 */
#pragma once
#include <mqtt/subcriber.hpp>
#include <mqtt/publisher.hpp>
#include <rs_info.pb.h>

class TrafficLight
{
    friend class TrafficLightArray;
    
    using ControlCallback = std::function<void(const std::string&, const fleet::LightStatus&)>;
    template<typename T>
    using ptr_t = std::shared_ptr<T>;
public:
    TrafficLight(const std::string& id, const double lat = 0.0, const double lon = 0.0, const double alt = 0.0);
    TrafficLight(const std::string& id, const ControlCallback& cb, const double lat = 0.0, const double lon = 0.0, const double alt = 0.0);
    ~TrafficLight();

    void update(const fleet::LightStatus &s);

    static void run_mqtt_client(const std::string& ip, const uint16_t& port, const std::string& user, const std::string& pwd);

private:
    const std::string id_;
    const double lat_;
    const double lon_;
    const double alt_;
    fleet::LightStatus status_;
    ControlCallback cb_;
    ptr_t<mqtt_dataio::publisher<fleet::RoadsideInfo>> pub_;
    ptr_t<mqtt_dataio::subscriber<fleet::LightControl>> sub_;

    void on_control_message(const fleet::LightControl& msg);
}; // TrafficLight

class TrafficLightArray
{
    template<typename T>
    using ptr_t = std::shared_ptr<T>;

    using ControlCallback = std::function<void(const TrafficLight&, const fleet::LightStatus&)>;
public:
    TrafficLightArray(const std::string& topic_pub, const std::string& topic_control, const ControlCallback& cb = nullptr);
    ~TrafficLightArray() = default;

    bool add_light(const std::string& id, const double lat = 0.0, const double lon = 0.0, const double alt = 0.0);
    bool remove_light(const std::string& id);
    bool update(const std::string& id, const fleet::LightStatus& s);
    void update(const fleet::LightStatus& s);
    bool publish();

private:
    const std::string topic_pub_;
    const std::string topic_control_;
    ControlCallback cb_;
    std::map<std::string, std::shared_ptr<TrafficLight>> lights_;
    ptr_t<mqtt_dataio::publisher<fleet::RoadsideInfoList>> pub_;
    ptr_t<mqtt_dataio::subscriber<fleet::LightControl>> sub_;

    std::once_flag control_once_flag_;

    void on_control_message(const fleet::LightControl& msg);

}; // TrafficLightArray
