#pragma once

#include <iostream>
/*
usage:
    Uart uart("ttyS1");
    uart.SetOpt(115200, 8, 'N' 1);
*/

namespace awe
{
class Uart
{
public:
    Uart(const char * dev);
    ~Uart();

    /**
     * @brief Set the Opt object
     * 
     * @param speed : 4800/9600/19200/38400/57600/115200
     * @param bits  : 7/8
     * @param event : O/E/N
     * @param stop  : 1/2
     * @return int 
     */
    int setOpt(uint64_t speed, int bits, char event, int stop);
    int write(uint8_t * buf, size_t size);
    int read(uint8_t * buf, size_t size);
    int getFd();

private:
    int fd;
};    
} // namespace awe



