#include "mqtt_basic.hpp"
#include "mqtt_client.hpp"

#include <string>

namespace mqtt_dataio
{
    template <typename RT>
    class subscriber : public subscriber_basic
    {
    public:
        using DataCallback = std::function<void(const RT &)>;

    public:
        subscriber(const subscriber &) = delete;
        subscriber &operator=(const subscriber &) = delete;
        subscriber() = delete;

        subscriber(const std::string &name, const DataCallback& cb)
            : __m_name(name),
              __m_cb(cb)
        {
            mqtt_dataio::client::ins().add_suber(__m_name, this);
        }

        ~subscriber() override
        {
            mqtt_dataio::client::ins().rm_suber(__m_name);
        }

        void on_message_arrival(const DataBuffer &buff) override
        {
            if (__m_cb)
            {
                {
                    __m_cb(buff);
                }
            }
        }

    private:
        std::string __m_name;
        DataCallback __m_cb;
    };
} // namespace mqtt_dataio
