#pragma once

#include "mqtt_basic.hpp"
#include "mqtt_client.hpp"

namespace mqtt_dataio
{

    template <typename T>
    class publisher : public publisher_basic
    {

    public:
        publisher() = delete;
        publisher(const publisher &) = delete;

        publisher(const std::string &name)
            : __m_name(name)
        {
            std::cout << "create publisher topic: " << __m_name << std::endl;
        }

        ~publisher() override
        {
            std::cout << "destroy publisher topic: " << __m_name << std::endl;
        }

        void publish(const T &msg)
        {
            {
                mqtt_dataio::client::ins().publish(__m_name, msg);
            }
        }

    private:
        const std::string __m_name;
    };

}

