#include <iostream>
#include <fstream>
#include <sstream>

#include "3th-part/json.hpp"
#include "mqtt/mqtt_client.hpp"
#include "barrier_gate.hpp"

int main(int argc, char *argv[])
{
    if (argc < 2)
    {
        std::cout << "please input config file, such as config.json" << std::endl;
        return 0;
    }

    if(access(argv[1], F_OK) != 0)
    {
        std::cerr << "file not exist: " << argv[1] << std::endl;
        return 0;
    }
    std::ifstream file(argv[1]);
    if (!file)
    {
        std::cerr << "can't open file " << argv[1] << std::endl;
        return 0;
    }

    std::ostringstream ss;
    ss << file.rdbuf();
    std::string content = ss.str();

    if (content.empty())
    {
        std::cout << "config file is empty!" << std::endl;
    }
    else
    {
        try
        {
            nlohmann::json j = nlohmann::json::parse(content);

            std::string ip = j["mqtt_server_ip"];
            uint16_t port = j["mqtt_server_port"];
            std::string user = j["mqtt_server_user"];
            std::string pwd = j["mqtt_server_pwd"];

            mqtt_dataio::client::ins().init(ip, port, user, pwd);

            auto node = std::make_shared<BarrierGateControl>(j);

            node->exec();
        }
        catch (const std::exception &e)
        {
            std::cerr << "catch exception: " << e.what() << '\n';
            return -1;
        }
    }

    return 0;
}
