# traffic_light_control

## 0.deps

```sh
sudo apt install libprotobuf-dev protobuf-compiler
sudo apt install libmosquitto-dev
```
## 1.compile
```sh
mkdir build 
cd build
cmake ..
make -j7
```

## 2.exec
```sh
cd build
./traffic_light_control ../test/config.json
```

## 3.config.json
```sh
    "mqtt_server_ip": "192.168.9.30",  //mqtt 服务器ip地址
    "mqtt_server_port": 1883,          //mqtt 服务器端口号
    "mqtt_server_user": "test",        //mqtt 用户名 
    "mqtt_server_pwd": "test",         //mqtt 密码
    "hdmap_topic": "/mqtt_msg_data_trans_traffic_light_layer", //订阅高精地图数据的topic
    "traffic_control_topic": "/USR-M100/Control/Traffic",      //下发给继电器的控制topic
    "expand_size": 5,                                          //继电器拓展的板个数
    "offset_do_addr": 2,                                       //继电器实际接线的偏移量
    "lights":
    [
        //id: 地图给的值   do_addrs->colors: [对应到继电器的接口编号]
        {"name": "light1", "id": 1, "type": "left", "do_addrs":[5, 6, 7], "colors":["red", "yellow", "green"]},
        {"name": "light2", "id": 2, "type": "up", "do_addrs":[2, 3, 4], "colors":["red", "yellow", "green"]},
        {"name": "light3", "id": 3, "type": "right", "do_addrs":[8, 9, 34], "colors":["red", "yellow", "green"]},

        {"name": "light4", "id": 4, "type": "left", "do_addrs":[13, 14, 15], "colors":["red", "yellow", "green"]},
        {"name": "light5", "id": 5, "type": "up", "do_addrs":[10, 11, 12], "colors":["red", "yellow", "green"]},
        {"name": "light6", "id": 6, "type": "right", "do_addrs":[16, 17, 35], "colors":["red", "yellow", "green"]},

        {"name": "light7", "id": 7, "type": "left", "do_addrs":[21, 22, 23], "colors":["red", "yellow", "green"]},
        {"name": "light8", "id": 8, "type": "up", "do_addrs":[18, 19, 20], "colors":["red", "yellow", "green"]},
        {"name": "light9", "id": 9, "type": "right", "do_addrs":[24, 25, 36], "colors":["red", "yellow", "green"]},

        {"name": "light10", "id": 10, "type": "left", "do_addrs":[29, 30, 31], "colors":["red", "yellow", "green"]},
        {"name": "light11", "id": 11, "type": "up", "do_addrs":[26, 27, 28], "colors":["red", "yellow", "green"]},
        {"name": "light12", "id": 12, "type": "right", "do_addrs":[32, 33, 37], "colors":["red", "yellow", "green"]}
    ],
    "modes":
    [
        {
            "id": 0, //模式id
            "lights": //12个灯的状态
            [
                {"id": 1, "color": "red"},
                {"id": 2, "color": "green"},
                {"id": 3, "color": "yellow"},
                {"id": 4, "color": "black"},
                {"id": 5, "color": "unkown"},
                {"id": 6, "color": "green"},
                {"id": 7, "color": "green"},
                {"id": 8, "color": "green"},
                {"id": 9, "color": "green"},
                {"id": 10, "color": "green"},
                {"id": 11, "color": "green"},
                {"id": 12, "color": "green"}
            ]
        },
        {
            "id": 1,
            "lights": 
            [
                {"id": 1, "color": "red"},
                {"id": 2, "color": "green"},
                {"id": 3, "color": "green"},
                {"id": 4, "color": "green"},
                {"id": 5, "color": "green"},
                {"id": 6, "color": "green"},
                {"id": 7, "color": "green"},
                {"id": 8, "color": "green"},
                {"id": 9, "color": "green"},
                {"id": 10, "color": "green"},
                {"id": 11, "color": "green"},
                {"id": 12, "color": "green"}
            ]
        }
    ]

```