#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2023/3/23 10:13
# @Author : Opfer
# @Site :
# @File : area_analysis.py    
# @Software: PyCharm

from data.para_config import *
from data.dispatchInfo import DispatchInfo
import uuid
import json
import random


def area_choose(excavators_id, closer_area_id, further_area_id, further_lane_set, closer_lane_set,
                logger, truck, truck_locates_dict, closer_excavator_state, further_excavator_state):
    """
    两装载区均不空闲，执行二次调度
    :param excavators_id: 挖机集合
    :param closer_area_id: 近端装载区id
    :param further_area_id: 远端装载区id
    :param lane_set: 近端及远端装载区间路段集合
    :param logger: 日志器
    :param truck: 车辆对象
    :param truck_locates_dict: 车辆位置
    :return: target_excavator
    """
    logger.info("excavator_hold_truck_list")
    logger.info(truck.excavator_hold_truck_list)
    logger.info(list(excavators_id)[0])
    logger.info(list(excavators_id)[1])
    logger.info(truck.excavator_hold_truck_list[list(excavators_id)[0]])
    logger.info(truck.excavator_hold_truck_list[list(excavators_id)[1]])
    # 统计驶往两装载区的车辆
    arrival_truck_set = truck.excavator_hold_truck_list[list(excavators_id)[0]] \
                        + truck.excavator_hold_truck_list[list(excavators_id)[1]]
    # 统计车辆抵达时间
    arrival_truck_reach_time = [truck.cur_truck_reach_excavator[truck.truck_uuid_to_index_dict[truck_id]] for \
                                truck_id in arrival_truck_set]
    # arrival_truck_set = ['309705a0-5ddf-4559-b6c4-ee17a57677ad', '899705a0-5ddf-4559-b6c4-ee17a57677ad']
    #
    # arrival_truck_reach_time = [8.04, 6.05]
    logger.info("arrival_truck_reach_time")
    logger.info(arrival_truck_reach_time)
    logger.info("arrival_truck_set")
    logger.info(arrival_truck_set)
    arrival_truck_list = list(zip(np.array(arrival_truck_set), np.array(arrival_truck_reach_time)))
    arrival_truck_list = sorted(arrival_truck_list, key=lambda item: item[1])
    logger.info("arrival_truck_list")
    logger.info(arrival_truck_list)
    logger.info("arrival_truck_list")
    logger.info(arrival_truck_list)

    logger.info(f"输入的closer_lane_set{closer_lane_set}")
    closer_lane_set_nearest = [closer_lane_set[0]]
    closer_lane_two = closer_lane_set[:2]
    # 前往装载的车的数量
    arrival_truck_num = len(arrival_truck_set)
    # 统计不同状态车辆数量
    goto_closer_area_num = 0
    goto_further_area_num = 0
    before_cross_num = 0
    lane_two_num = 0
    for truck_id, reach_time in arrival_truck_list:
        if truck_id in truck_locates_dict:
            truck_lane_id = truck_locates_dict[truck_id]
            # 车辆已经经过近端装载区
            if truck_lane_id in further_lane_set:
                # 前往远端装载区车辆数加1
                goto_further_area_num += 1
            # 车辆未经过近端装载区
            if truck_lane_id in closer_lane_two:
                # 在装载区外2个车道
                lane_two_num += 1
            # 车辆未经过近端装载区
            if truck_lane_id in closer_lane_set_nearest:
                # 前往近端或近端装载区车辆数加1
                goto_closer_area_num += 1
            else:
                before_cross_num += 1
        else:
            continue

    import datetime

    # 获取当前时间
    current_time = datetime.datetime.now()

    # 打印当前时间


    logger.info(f"近端挖机状态{closer_excavator_state} 当前时间{current_time}")
    logger.info(f"近端装载区外第一路段等待车辆数{goto_closer_area_num}")

    logger.info(f"远端挖机状态{further_excavator_state}")
    logger.info(f"已经前往远端的车辆数{goto_further_area_num}")


    logger.info(before_cross_num)

    # # 近端挖机空闲
    # if closer_excavator_state == 0 and goto_closer_area_num == 0:
    #     logger.info("近端挖机空闲, 调度车辆前往近端装载区")
    #     target_excavator = DispatchInfo.load_excavator_dict[closer_area_id]
    #     # truck_dispatch_to_redis(request_truck_id, group_id, DispatchInfo.load_excavator_dict[closer_area_id])
    # # 远端挖机空闲
    # elif further_excavator_state == 0 and goto_further_area_num == 0:
    #     logger.info("远端挖机空闲, 调度车辆前往远端装载区")
    #     target_excavator = DispatchInfo.load_excavator_dict[further_area_id]
    #     # truck_dispatch_to_redis(request_truck_id, group_id, DispatchInfo.load_excavator_dict[further_area_id])
    # # 两挖机均不空闲
    # else:
    #     # goto_further_area_num -= 1
    #     logger.info("goto_further_area_num-goto_closer_area_num")
    #     logger.info(goto_further_area_num)
    #     logger.info(goto_closer_area_num)
    #     # 默认当前请调车辆与近端装载点前没有车辆，因此前往近端装载区的车辆仅其本身
    #     # goto_closer_area_num = 1
    #     # 在远处排队等待的车辆更少
    #     if goto_closer_area_num + before_cross_num > goto_further_area_num:
    #         logger.info("远端挖机排队时间短, 调度车辆前往")
    #         target_excavator = DispatchInfo.load_excavator_dict[further_area_id]
    #         # truck_dispatch_to_redis(request_truck_id, group_id, DispatchInfo.load_excavator_dict[further_area_id])
    #     else:
    #         logger.info("近端挖机排队时间短, 调度车辆前往")
    #         target_excavator = DispatchInfo.load_excavator_dict[closer_area_id]
    #         # truck_dispatch_to_redis(request_truck_id, group_id, DispatchInfo.load_excavator_dict[closer_area_id])
    try:
        with open(json_file, encoding='UTF-8') as f:
            load_value = json.load(f)
            gothrough_config_area = load_value["gothrough"]
            dispatch_factor = float(gothrough_config_area["factor"])

        # 近端挖机空闲
        if closer_excavator_state == 0:
            logger.info(f"穿越调度：近端挖机空闲, 调度车辆前往近端装载区，远端派车数量{goto_further_area_num},空载车总数{arrival_truck_num}")
            target_excavator = DispatchInfo.load_excavator_dict[closer_area_id]
        # 远端挖机空闲
        # if further_excavator_state == 0 and goto_further_area_num == 0:
        elif goto_further_area_num == 0:
            logger.info(f"穿越调度：远端挖机空闲, 调度车辆前往远端装载区，远端派车数量{goto_further_area_num},空载车总数{arrival_truck_num}")
            target_excavator = DispatchInfo.load_excavator_dict[further_area_id]
        # elif closer_excavator_state == 0 and lane_two_num <= 1:
        #     logger.info(f"穿越调度：近端挖机空闲, 调度车辆前往近端装载区，远端派车数量{goto_further_area_num},空载车总数{arrival_truck_num}")
        #     target_excavator = DispatchInfo.load_excavator_dict[closer_area_id]

        # 远端挖机已满载
        elif goto_further_area_num >= int(dispatch_factor*arrival_truck_num):
            logger.info(f"穿越调度：远端挖机满载, 调度车辆前往近端装载区，远端派车数量{goto_further_area_num},空载车总数{arrival_truck_num}")
            target_excavator = DispatchInfo.load_excavator_dict[closer_area_id]
        # 近端挖机已满载
        else:
            logger.info(f"穿越调度：近端挖机满载, 调度车辆前往远端装载区，远端派车数量{goto_further_area_num},空载车总数{arrival_truck_num}")
            target_excavator = DispatchInfo.load_excavator_dict[further_area_id]
            # truck_dispatch_to_redis(request_truck_id, group_id, DispatchInfo.load_excavator_dict[further_area_id])
    except Exception as es:
        logger.error("找寻最空闲挖机异常")
        logger.error(es)
        logger.error("随机分配挖机")
        if random.random() < 0.6:
            target_excavator = DispatchInfo.load_excavator_dict[further_area_id]
            logger.info("随机分配远端挖机")
        else:
            target_excavator = DispatchInfo.load_excavator_dict[closer_area_id]
            logger.info("随机分配近端挖机")
    return target_excavator


def area_analysis(load_area_uuid):
    """
    Analysis which area is closer.
    :param load_area_uuid:
    :return: closer_area_uuid, further_area_uuid
    """

    try:

        excavator_uuid_to_load_area_uuid_dict = get_value("excavator_uuid_to_load_area_uuid_dict")

        load_area_uuid = list(load_area_uuid)

        load_area_uuid[0] = excavator_uuid_to_load_area_uuid_dict[load_area_uuid[0]]
        load_area_uuid[1] = excavator_uuid_to_load_area_uuid_dict[load_area_uuid[1]]

        distance_a = session_postgre.query(WalkTimePark) \
            .filter_by(load_area_id=load_area_uuid[0]).first().park_load_distance

        distance_b = session_postgre.query(WalkTimePark) \
            .filter_by(load_area_id=load_area_uuid[1]).first().park_load_distance

        if distance_a > distance_b:
            return load_area_uuid[1], load_area_uuid[0]
        else:
            return load_area_uuid[0], load_area_uuid[1]

    except Exception as es:
        logger.error("装载区距离分析异常")
        logger.error(es)
        return load_area_uuid[0], load_area_uuid[1]


def truck_pass_first_area(truck_id, lane_id, closer_entrance_node_id, further_entrance_node_id):
    """
    Truck has gone through the first area.
    :param truck_id:
    :param lane_id:
    :param closer_entrance_node_id:
    :param further_entrance_node_id:
    :return:
    """

    # try:

    def backtracking(root_node):

        from collections import deque
        que = deque([root_node])

        while que:
            size = len(que)
            for _ in range(size):
                cur_node = que.popleft()
                if cur_node is None:
                    continue
                logger.info(cur_node)
                if cur_node == closer_entrance_node_id:
                    logger.info("closer_entrance_node")
                    return 0
                if cur_node == further_entrance_node_id:
                    logger.info("further_entrance_node")
                    return 1
                for item in session_postgre.query(Lane).filter_by(StartNodeId=cur_node).all():
                    if item:
                        que.append(item.EndNodeId)

    node_id = session_postgre.query(Lane).filter_by(Id=lane_id).first().EndNodeId

    if backtracking(root_node=node_id) == 0:
        return True
    else:
        return False

    # except Exception as es:
    #     logger.error("车辆行驶位置判断异常")
    #     logger.error(es)
    #     return True


def get_trucks_locate():
    """
    get trucks locates.
    :return: truck_locate_dict
    """

    try:
        truck_name_to_uuid_dict = get_value("truck_name_to_uuid_dict")

        truck_locate_dict = {}
        device_name_set = redis2.keys()
        for item in device_name_set:
            item = item.decode(encoding='utf-8')
            key_value_dict = redis2.hgetall(item)
            if str_to_byte('type') in key_value_dict:
                device_type = key_value_dict[str_to_byte('type')]
                is_online = key_value_dict[str_to_byte('online')]
                key_set = key_value_dict.keys()
                if (device_type == str_to_byte("1")) \
                        and (str_to_byte('online') in key_set) \
                        and (bytes.decode(is_online) in ["true" or "True"]) \
                        and (str_to_byte('laneId') in key_set):
                    truck_locate = key_value_dict[str_to_byte('laneId')]
                    # logger.error(item)
                    # logger.error(eval(truck_locate))
                    if eval(truck_locate) is not '':
                        truck_locate_dict[truck_name_to_uuid_dict[item]] = eval(truck_locate)
                    # logger.info(truck_locate_dict)
            else:
                continue

        return truck_locate_dict

    except Exception as es:
        logger.error("车辆所在路段读取异常")
        logger.error(es)
        return {}


def truck_dispatch_to_redis(truck_id, group_id, excavator_id):
    """
    write truck dispatch to redis.
    :param truck_id:
    :param group_id:
    :param excavator_id:
    :return:
    """
    # 查询车辆相关派车计划
    record = {}
    try:
        # dump_id = DispatchInfo.unload_area_dump_dict[unload_area_id]
        item = (session_mysql.query(DispatchSetting).filter_by(exactor_id=excavator_id, group_id=group_id,
                                                               isdeleted=0, ).first())

        if item is None:
            raise Exception("调度计划配置异常")

    except Exception as es:
        item = (session_mysql.query(DispatchSetting).filter_by(group_id=group_id, isdeleted=0, ).first())
        logger.error(es)

    logger.info("无重复派车计划，重新生成中")
    # 其余调度信息写入
    try:
        record["truckId"] = truck_id
        record["dispatchId"] = str(uuid.uuid1())
        record["exactorId"] = item.exactor_id
        record["loadAreaId"] = item.load_area_id
        record["dumpId"] = item.dump_id
        record["unloadAreaId"] = item.unload_area_id
        record["groupId"] = group_id
        record["isdeleted"] = False
        record["isTemp"] = False
        record["haulFlag"] = -1
        record["groupName"] = DispatchInfo.group_name[group_id]

        logger.info(f'{truck_id} redis 注入 {record}')
    except Exception as es:
        logger.error("调度结果写入异常-矿卡空载")
        logger.error(es)
    finally:
        redis5.set(truck_id, str(json.dumps(record)))


def get_lanes_between_entrances(closer_node_id, further_node_id):
    """
    get lanes between two entrance nodes.
    :param closer_node_id:
    :param further_node_id:
    :return: lane set
    """
    try:
        max_find_it = 100
        next_node_id = closer_node_id
        lane_set = []
        while max_find_it > 0 and next_node_id != further_node_id:
            item = session_postgre.query(Lane).filter_by(StartNodeId=next_node_id, Type=2).first()
            if item:
                next_lane_id = item.Id
                next_node_id = item.EndNodeId
                lane_set.append(next_lane_id)
                max_find_it -= 1
            max_find_it -= 1

        return lane_set

    except Exception as es:
        logger.error("获取装载区间路段异常")
        logger.error(es)
        return []


def get_excavator_state(excavator_id):
    """
    get group_excavators state.
    :param excavator_id:
    :return: state
    """
    try:

        logger.info(excavator_id)
        device_name = session_mysql.query(Equipment).filter_by(id=excavator_id, device_type=2).first().device_name

        key_value_dict = redis2.hgetall(device_name)
        if str_to_byte('online') in key_value_dict:
            is_online = key_value_dict[str_to_byte('online')]
        else:
            logger.warning(f'挖机 {device_name} 不在线')
            return 0
        key_set = key_value_dict.keys()
        state = 100
        if (str_to_byte('online') in key_set) and (bytes.decode(is_online) in ["true" or "True"]):
            if str_to_byte('workState') in key_set:
                state = key_value_dict[str_to_byte('workState')]
            else:
                logger.warning(f'挖机 {device_name} 状态未知')
                return 0

        return int(float(byte_to_str(state)))

    except Exception as es:
        logger.error("挖机状态读取异常")
        logger.error(es)
        return 0


def get_excavator_prise_location(excavator_id):
    """
    get group_excavators prise location.
    :param excavator_id:
    :return: location
    """
    try:

        logger.info(f"正在获取的挖机id：{excavator_id}")
        device_name = session_mysql.query(Equipment).filter_by(id=excavator_id, device_type=2).first().device_name

        are_entrance_key = str("Area_" + device_name)
        key_value_dict = json.loads(byte_to_str(redis0.get(are_entrance_key)))
        loc_str = key_value_dict['Entrance']  .split(",")

        longitude = float(loc_str[0])
        latitude = float(loc_str[1])
        location = (latitude, longitude)

        return location

    except Exception as es:
        logger.error("挖机状态读取异常")
        logger.error(es)
        location = (-1, -1)
        return location
