#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2022/5/30 15:35
# @Author : Opfer
# @Site :
# @File : group.py    
# @Software: PyCharm

from data.dispatchInfo import DispatchInfo
from bidict import bidict
from alg.algorithm import AlgorithmBase, Congestion


class Group:
    """
    class for group instance.
    """
    def __init__(self, group_id, truck, dump, excavator):
        """ Generate a group obj.
        :param group_id: (uuid) group_id
        """

        self.group_id = group_id

        # group devices
        self.excavator_dict = {}    # excavator_id -> load_area_id
        self.dump_dict = {}    # dump_id -> unload_area_id
        self.truck_set = set()    # truck_id

        # road network info.
        self.to_excavator_distance = None
        self.to_dump_distance = None
        self.park_to_excavator_distance = None

        self.to_excavator_congestion = None
        self.to_dump_congestion = None
        self.park_to_excavator_congestion = None

        # device map
        self.truck_uuid_index_dict = bidict()
        self.excavator_uuid_index_dict = bidict()
        self.dump_uuid_index_dict = bidict()

        # device obj.
        self.truck = truck
        self.dump =dump
        self.excavator = excavator

    def update_xx_(self):
        """
        update above parameters.
        :return:
        """
        pass

    def update_device_map(self):
        """
        update above parameters.
        :return:
        """
        self.truck_uuid_index_dict = DispatchInfo.dump_group_dict
        pass

    def update_road_network_info(self, para):
        """

        :return:
        """
        pass
        return

    def group_dispatch(self, solver):
        """
        Receive a alg obj. and output dispatch plan for trucks in this group.
        :param solver:
        :return:
            dispatch plan: Dict({truck_id: match_id})
        """
        assert isinstance(solver, AlgorithmBase)
        s = solver(self)    # algorithm init
        for truck_id in self.truck_set:
            value = s.solve(truck_id)    # algorithm solve

        return value

    def target_2_match_id(self, target):
        pass


group = Group("group123")

group.group_dispatch(Congestion)
