#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2021/6/22 12:46
# @Author : Opfer
# @Site :
# @File : tables.py
# @Software: PyCharm


# 存储数据库表结构

from sqlalchemy import Column, create_engine
from sqlalchemy import VARCHAR, DateTime, Float, Integer, BOOLEAN
from sqlalchemy.orm import sessionmaker, scoped_session
from sqlalchemy.ext.declarative import declarative_base
from geoalchemy2 import Geography
from shapely import wkb
from urllib.parse import quote
import json, os
from settings import *

relative_path = os.path.dirname(os.path.abspath(__file__))  # 获取当前文件夹的绝对路径
json_file = os.path.join(relative_path, "config.json")
# json_file = "config.json"

with open(json_file, encoding='UTF-8') as f:
    load_vale = json.load(f)

    postgre_config = load_vale["postgresql"]

    if "mysql" in load_vale:
        mysql_config = load_vale["mysql"]
    else:
        mysql_config = None

    if "mssql" in load_vale:
        sqlserver_config = load_vale["mssql"]
    else:
        sqlserver_config = None

# 创建对象的基类:
Base = declarative_base()

if mysql_config is not None:

    sql_str = str("mysql+mysqlconnector://" + mysql_config["user"] + ":%s@" + mysql_config["host"] + \
              ":" + mysql_config["port"] + "/" + mysql_config["database"])

    engine_mysql = create_engine(sql_str % quote(mysql_config["password"]))

else:

    sql_str = str("mssql+pymssql://" + sqlserver_config["user"] + ":%s@" + sqlserver_config["host"] + \
                  ":" + sqlserver_config["port"] + "/" + sqlserver_config["database"])

    engine_mysql = create_engine(sql_str % quote(sqlserver_config["password"]))

postgre_str = str("postgresql://" + postgre_config["user"] + ":%s@" + postgre_config["host"] + \
                  ":" + postgre_config["port"] + "/" + postgre_config["database"])

# try:

engine_postgre = create_engine(postgre_str % quote(postgre_config["password"]))

# 创建DBsession_mysql类型:
DBsession_mysql = sessionmaker(bind=engine_mysql)

DBsession_mysql = scoped_session(DBsession_mysql)

DBsession_postgre = sessionmaker(bind=engine_postgre)

DBsession_postgre = scoped_session(DBsession_postgre)

# 创建session_mysql对象:
session_mysql = DBsession_mysql()

session_mysql.expire_on_commit = False

session_postgre = DBsession_postgre()

session_postgre.expire_on_commit = False

# 定义对象:

class WalkTime(Base):
    __tablename__ = 'work_area_distance'

    load_area_id = Column(VARCHAR(36), primary_key=True)
    unload_area_id = Column(VARCHAR(36), primary_key=True)
    load_area_name = Column(VARCHAR(30))
    unload_area_name = Column(VARCHAR(30))
    to_unload_distance = Column(Float(10))
    to_load_distance = Column(Float(10))
    to_unload_lanes = Column(VARCHAR(100))
    to_load_lanes = Column(VARCHAR(100))

    def __init__(self, load_area_id, unload_area_id, load_area_name, unload_area_name, to_load_distance,
                 to_unload_distance, to_unload_lanes, to_load_lanes):
        self.load_area_id = load_area_id
        self.unload_area_id = unload_area_id
        self.load_area_name = load_area_name
        self.unload_area_name = unload_area_name
        self.to_load_distance = to_load_distance
        self.to_unload_distance = to_unload_distance
        self.to_unload_lanes = to_unload_lanes
        self.to_load_lanes = to_load_lanes


class EquipmentPair(Base):
    __tablename__ = 'sys_equipment_pair'

    id = Column(VARCHAR(36), primary_key=True)
    truck_id = Column(VARCHAR(36))
    exactor_id = Column(VARCHAR(36))
    dump_id = Column(VARCHAR(36))
    load_area_id = Column(VARCHAR(36))
    unload_area_id = Column(VARCHAR(36))
    dispatch_id = Column(VARCHAR(36))
    isdeleted = Column(BOOLEAN)
    createtime = Column(DateTime)

    def __init__(self, id, truck_id, exactor_id, dump_id, load_area_id, unload_area_id, dispatch_id, isdeleted,
                 createtime):
        self.id = id
        self.truck_id = truck_id
        self.exactor_id = exactor_id
        self.dump_id = dump_id
        self.load_area_id = load_area_id
        self.unload_area_id = unload_area_id
        self.dispatch_id = dispatch_id
        self.isdeleted = isdeleted
        self.createtime = createtime


class Lane(Base):
    # 表的名字
    __tablename__ = 'Geo_Lane'
    Id = Column(VARCHAR(36), primary_key=True)
    Length = Column(Float)
    MaxSpeed = Column(Float)
    StartNodeId = Column(VARCHAR(36))
    EndNodeId = Column(VARCHAR(36))
    Type = Column(Integer)
    FeatureId = Column(VARCHAR(36))
    MapVersion = Column(VARCHAR(36))

    def __init__(self, Id, Length, MaxSpeed, StartNodeId, EndNodeId, Type, FeatureId, MapVersion):
        self.Id = Id
        self.Length = Length
        self.MaxSpeed = MaxSpeed
        self.StartNodeId = StartNodeId
        self.EndNodeId = EndNodeId
        self.Type = Type
        self.FeatureId = FeatureId
        self.MapVersion = MapVersion


class Node(Base):
    __tablename__ = 'Geo_Node'
    Id = Column(VARCHAR(36), primary_key=True)
    geom = Column(Geography("Point"))
    FeatureId = Column(VARCHAR(36))
    MapVersion = Column(VARCHAR(36))

    def __init__(self, Id, geom, FeatureId, MapVersion):
        self.Id = Id
        self.geom = geom
        self.FeatureId = FeatureId
        self.MapVersion = MapVersion


class Dispatch(Base):
    # 表的名字:
    __tablename__ = 'sys_dispatch_setting'

    id = Column(VARCHAR(36), primary_key=True)
    load_area_id = Column(VARCHAR(36))
    exactor_id = Column(VARCHAR(36))
    unload_area_id = Column(VARCHAR(36))
    dump_id = Column(VARCHAR(36))
    isauto = Column(BOOLEAN)
    truck_id = Column(VARCHAR(36))
    group_id = Column(VARCHAR(36))
    remark = Column(VARCHAR(100))
    proportion_id = Column(VARCHAR(36))
    isdeleted = Column(BOOLEAN)
    creator = Column(VARCHAR(36))
    createtime = Column(DateTime)
    updator = Column(VARCHAR(36))
    updatetime = Column(DateTime)
    deletor = Column(VARCHAR(36))
    deletetime = Column(DateTime)

    def __init__(self, id, load_area_id, exactor_id, unload_area_id, dump_id, isauto, truck_id, group_id, remark,
                 proportion_id,
                 isdeleted, creator, createtime, updator, updatetime, deletor, deletetime):
        self.id = id
        self.load_area_id = load_area_id
        self.exactor_id = exactor_id
        self.unload_area_id = unload_area_id
        self.dump_id = dump_id
        self.isauto = isauto
        self.truck_id = truck_id
        self.group_id = group_id
        self.remark = remark
        self.proportion_id = proportion_id
        self.isdeleted = isdeleted
        self.creator = creator
        self.createtime = createtime
        self.updator = updator
        self.updatetime = updatetime
        self.deletor = deletor
        self.deletetime = deletetime


class DispatchSetting(Base):
    __tablename__ = 'sys_dispatch_setting_v'

    id = Column(VARCHAR(36), primary_key=True)
    mode_name = Column(VARCHAR(36))
    mode_code = Column(VARCHAR(36))
    group_name = Column(VARCHAR(36))
    group_id = Column(VARCHAR(36))
    group_code = Column(VARCHAR(36))
    group_type = Column(Integer)
    load_area_id = Column(VARCHAR(36))
    exactor_id = Column(VARCHAR(36))
    unload_area_id = Column(VARCHAR(36))
    dump_id = Column(VARCHAR(36))
    isauto = Column(BOOLEAN)
    truck_id = Column(VARCHAR(36))
    team_id = Column(VARCHAR(36))
    isdeleted = Column(BOOLEAN)
    rate = Column(Integer)
    proportion_id = Column(VARCHAR(36))

    def __init__(self, id, mode_name, mode_code, group_name, group_id, group_code, group_type, load_area_id, exactor_id,
                 unload_area_id, dump_id, isauto, truck_id, remark, proportion_id, rate):
        self.id = id
        self.mode_name = mode_name
        self.mode_code = mode_code
        self.group_name = group_name
        self.group_id = group_id
        self.group_code = group_code
        self.group_type = group_type
        self.load_area_id = load_area_id
        self.exactor_id = exactor_id
        self.unload_area_id = unload_area_id
        self.dump_id = dump_id
        self.isauto = isauto
        self.truck_id = truck_id
        self.proportion_id = proportion_id
        self.remark = remark
        self.rate = rate


class WalkTimePark(Base):
    __tablename__ = 'park_load_distance'

    park_area_id = Column(VARCHAR(36), primary_key=True)
    load_area_id = Column(VARCHAR(36), primary_key=True)
    park_area_name = Column(VARCHAR(36))
    load_area_name = Column(VARCHAR(36))
    park_load_distance = Column(Float(10))
    park_load_lanes = Column(VARCHAR(100))

    def __init__(self, park_area_id, load_area_id, park_area_name, load_area_name, park_load_distance, park_load_lanes):
        self.park_area_id = park_area_id
        self.load_area_id = load_area_id
        self.park_area_name = park_area_name
        self.load_area_name = load_area_name
        self.park_load_distance = park_load_distance
        self.park_load_lanes = park_load_lanes


class Equipment(Base):
    __tablename__ = 'sys_equipment'

    id = Column(VARCHAR(36), primary_key=True)
    equipment_id = Column(VARCHAR(64))
    device_name = Column(VARCHAR(64))
    device_type = Column(VARCHAR(36))
    equipment_spec = Column(VARCHAR(36))
    equipment_state = Column(Integer)
    isdeleted = Column(Integer)
    disabled = Column(Integer)
    bind_list = Column(VARCHAR(1000))
    only_allowed = Column(Integer)
    priority = Column(Integer)

    def __init__(self, id, equipment_id, device_name, device_type, equipment_spec, equipment_state, isdeleted, \
                 disabled, bind_list, only_allowed, priority):
        self.id = id
        self.equipment_id = equipment_id
        self.device_name = device_name
        self.device_type = device_type
        self.equipment_spec = equipment_spec
        self.equipment_state = equipment_state
        self.isdeleted = isdeleted
        self.disabled = disabled
        self.bind_list = bind_list
        self.only_allowed = only_allowed
        self.priority = priority


class EquipmentSpec(Base):
    __tablename__ = 'sys_equipment_spec'

    id = Column(VARCHAR(36), primary_key=True)
    capacity = Column(Integer)
    mining_abililty = Column(Float)
    length = Column(Float)
    width = Column(Float)
    max_speed = Column(Float)

    def __init__(self, id, capacity, mining_abililty, length, width, max_speed):
        self.id = id
        self.capacity = capacity
        self.mining_abililty = mining_abililty
        self.length = length
        self.width = width
        self.max_speed = max_speed


class LoadInfo(Base):
    __tablename__ = 'sys_loadinfo'

    time = Column(DateTime, primary_key=True)
    dump_id = Column(VARCHAR(36), primary_key=True)
    load_weight = Column(Float(8))

    def __init__(self, time, dump_id, load_weight):
        self.time = time
        self.dump_id = dump_id
        self.load_weght = load_weight


class JobRecord(Base):
    __tablename__ = 'statistic_job_record'

    id = Column(VARCHAR(36), primary_key=True)
    equipment_id = Column(VARCHAR(50))
    start_time = Column(DateTime)
    end_time = Column(DateTime)
    work_type = Column(Integer)

    def __init__(self, id, equipment_id, start_time, end_time, work_type):
        self.id = id
        self.equipment_id = equipment_id
        self.start_time = start_time
        self.end_time = end_time
        self.work_type = work_type


class WorkRecord(Base):
    __tablename__ = 'statistic_work_record'

    equipment_id = Column(VARCHAR(50), primary_key=True)
    work_day = Column(DateTime, primary_key=True)
    load_entrance_time = Column(Float)
    load_entrance_count = Column(Integer)
    load_exit_time = Column(DateTime)
    load_exit_count = Column(Integer)

    def __init__(self, equipment_id, work_day, load_entrance_time, load_entrance_count, load_exit_time,
                 load_exit_count):
        self.equipment_id = equipment_id
        self.work_day = work_day
        self.load_entrance_time = load_entrance_time
        self.load_entrance_count = load_entrance_count
        self.load_exit_time = load_exit_time
        self.load_exit_count = load_exit_count


class DumpArea(Base):
    __tablename__ = 'Geo_DumpArea'

    Id = Column(VARCHAR(50), primary_key=True)
    Name = Column(VARCHAR(36))
    BindList = Column(VARCHAR(1000))
    UnloadAbililty = Column(Float)
    Disabled = Column(Integer)
    Materials = Column(VARCHAR(36))
    Priority = Column(Integer)
    DumpEquipmentId = Column(VARCHAR(36))
    EntranceNodeId = Column(VARCHAR(50))
    ExitNodeId = Column(VARCHAR(50))
    FeatureId = Column(VARCHAR(36))
    MapVersion = Column(VARCHAR(36))

    def __init__(self, Id, Name, BindList, UnloadAbililty, Disabled, Materials, Priority, DumpEquipmentId,
                 EntranceNodeId, ExitNodeId, FeatureId, MapVersion):
        self.Id = Id
        self.Name = Name
        self.BindList = BindList
        self.UnloadAbililty = UnloadAbililty
        self.Disabled = Disabled
        self.Materials = Materials
        self.Priority = Priority
        self.DumpEquipmentId = DumpEquipmentId
        self.EntranceNodeId = EntranceNodeId
        self.ExitNodeId = ExitNodeId
        self.FeatureId = FeatureId
        self.MapVersion = MapVersion


class DiggingWorkArea(Base):
    __tablename__ = 'Geo_DiggingWorkArea'

    Id = Column(VARCHAR(50), primary_key=True)
    Name = Column(VARCHAR(36))
    Material = Column(VARCHAR(36))
    ExactorId = Column(VARCHAR(36))
    ExactorUuid = Column(VARCHAR(50))
    EntranceNodeId = Column(VARCHAR(50))
    ExitNodeId = Column(VARCHAR(50))
    FeatureId = Column(VARCHAR(36))
    MapVersion = Column(VARCHAR(36))

    def __init__(self, Id, Name, Material, ExactorId, ExactorUuid, EntranceNodeId, ExitNodeId, FeatureId, MapVersion):
        self.Id = Id
        self.Name = Name
        self.Material = Material
        self.ExactorId = ExactorId
        self.ExactorUuid = ExactorUuid
        self.EntranceNodeId = EntranceNodeId
        self.ExitNodeId = ExitNodeId
        self.FeatureId = FeatureId
        self.MapVersion = MapVersion


class DispatchRule(Base):
    __tablename__ = 'sys_dispatch_rule'

    id = Column(Integer, primary_key=True)
    rule_weight = Column(Float)
    disabled = Column(BOOLEAN)

    def __init__(self, id, rule_weight, disabled):
        self.id = id
        self.rule_weight = rule_weight
        self.disabled = disabled


class Material(Base):
    __tablename__ = 'resource_metarials'
    id = Column(VARCHAR(40), primary_key=True)
    name = Column(VARCHAR(40))

    def __init__(self, id, name):
        self.id = id
        self.name = name


class DispatchMode(Base):
    __tablename__ = 'sys_dispatch_mode'

    id = Column(VARCHAR(36), primary_key=True)
    mode_name = Column(VARCHAR(30))
    mode_desc = Column(VARCHAR(50))
    mode_code = Column(Integer)

    def __init__(self, id, mode_name, mode_desc, mode_code):
        self.id = id
        self.mode_name = mode_name
        self.mode_desc = mode_desc
        self.mode_code = mode_code


class DispatchGroup(Base):
    __tablename__ = 'sys_dispatch_group'
    id = Column(VARCHAR(36), primary_key=True)
    group_type = Column(Integer)
    group_code = Column(VARCHAR(36))
    mode_id = Column(VARCHAR(36))
    mode_code = Column(Integer)
    group_name = Column(VARCHAR(36))

    def __init__(self, id, group_type, group_code, mode_id, mode_code, group_name):
        self.id = id
        self.group_type = group_type
        self.group_code = group_code
        self.mode_id = mode_id
        self.mode_code = mode_code
        self.group_name = group_name


class DispatchMatch(Base):
    __tablename__ = 'sys_dispatch_match'
    id = Column(VARCHAR(36), primary_key=True)
    group_type = Column(Integer)
    group_code = Column(VARCHAR(36))
    match_code = Column(VARCHAR(36))
    team_id = Column(VARCHAR(36))
    load_area_id = Column(VARCHAR(36))
    dump_id = Column(VARCHAR(36))
    exactor_id = Column(VARCHAR(36))
    unload_area_id = Column(VARCHAR(36))

    def __init__(self, id, group_type, group_code, match_code, team_id, load_area_id, dump_id, exactor_id, unload_area_id):
        self.id = id
        self.group_type = group_type
        self.group_code = group_code
        self.match_code = match_code
        self.team_id = team_id
        self.load_area_id = load_area_id
        self.dump_id = dump_id
        self.exactor_id = exactor_id
        self.unload_area_id = unload_area_id


class DispatchEquipment(Base):
    __tablename__ = 'sys_dispatch_equipment'
    id = Column(VARCHAR(36), primary_key=True)
    group_type = Column(Integer)
    group_code = Column(VARCHAR(36))
    match_code = Column(VARCHAR(36))
    isdeleted = Column(Integer)
    equipment_id = Column(VARCHAR(36))

    def __init__(self, id, group_type, group_code, match_code, isdeleted, equipment_id):
        self.id = id
        self.group_type = group_type
        self.group_code = group_code
        self.match_code = match_code
        self.isdeleted = isdeleted
        self.equipment_id = equipment_id


# class RecordTruckOutput(Base):
#     __tablename__ = 'record_truck_output'
#     end_time = Column(DateTime)
#     id = Column(Integer, primary_key=True)
#     unload_area_id = Column(VARCHAR(36))
#     equipment_id = Column(VARCHAR(36))
#
#     def __init__(self, id, unload_area_id,  equipment_id, end_time):
#         self.id = id
#         self.end_time = end_time
#         self.unload_area_id = unload_area_id
#         self.equipment_id = equipment_id


class RecordTruckOutput(Base):
    __tablename__ = 'record_truck_output'

    id = Column(VARCHAR(36), primary_key=True)
    unload_area_id = Column(VARCHAR(36))
    end_time = Column(DateTime)

    def __init__(self, id, unload_area_id, end_time ):
        self.id = id
        self.unload_area_id = unload_area_id
        self.end_time = end_time


class Distribute_Library(Base):
    __tablename__ = 'Geo_Distribute_Library'

    Id = Column(VARCHAR(36), primary_key=True)
    Version = Column(VARCHAR(36))
    Status = Column(VARCHAR(10))

    def __init__(self, Id, Version, Status):
        self.Id = Id
        self.Version = Version
        self.Status = Status
