#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2022/5/30 14:45
# @Author : Opfer
# @Site :
# @File : dispatchInfo.py
# @Software: PyCharm
from settings import *

logger = get_logger("mqc.dispatchInfo")


class DispatchInfo:
    """
    class for dispatch group info.
    """

    # dispatch groups
    group_set = set()

    # device group structure
    group_dump_dict = {}  # team_id -> dict {unload_area_id, unload_area_id, ...}
    # {group_id:unload_area_id,...}
    group_excavator_dict = {}  # team_id -> dict {[excavator_id, load_area_id], ...}
    # {group_id: [excavator_id, unload_area_id], ...}
    group_truck_dict = {}  # team_id -> dict {truck_id, ...}
    # {group_id:[truck_id,truck_id],...}

    dump_group_dict = {}  # unload_area_id -> team_id
    excavator_group_dict = {}  # excavator_id -> team_id
    truck_group_dict = {}  # truck_id -> team_id

    # group feature
    group_mode = {}  # 四种模式：全智能、空车智能、定铲定铲和分流配比模式
    # {mode_name:mode_code}

    # route_distance（路网距离）
    load_excavator_distance = {}  # 装载区-挖机（电铲）的距离  数据格式 -->> {load_area_id:[exactor_uuid:to_load_distance],}
    unload_excavator_distance = {}  # 卸载区-挖机（电铲）的距离 数据格式 -->> {unload_area_id:[exactor_uuid:to_unload_distance],}

    @classmethod
    def renew_set(cls):
        """
        @date：2022/6/2 19:50
        @author：maqc
        @desc：实例化对象，可直接访问
        """

        cls.group_dump_dict = {}
        cls.dump_group_dict = {}
        cls.group_excavator_dict = {}
        cls.excavator_group_dict = {}
        cls.excavator_group_dict = {}
        cls.group_truck_dict = {}
        cls.truck_group_dict = {}
        cls.group_mode = {}
        cls.load_excavator_distance = {}
        cls.unload_excavator_distance = {}

    @classmethod
    def update_device_group_structure(cls):
        """
        @date：2022/6/2 19:49
        @author：maqc
        @desc：分组与卸载区、挖机、矿卡的映射和反映射
        """
        logger = get_logger("mqc.update_device_group_structure")
        try:
            # group_dump_dict = {} -->> {group_id:unload_area_id,...}
            # dump_group_dict = {}  # unload_area_id -> team_id
            group_code_dict = {}  # group_code-->>team_id的映射
            for valve in session_mysql.query(DispatchMatch).filter_by(group_type=1).all():
                group_code_dict[valve.group_code] = valve.team_id
                if valve.team_id not in cls.group_dump_dict:
                    cls.group_dump_dict[valve.team_id] = [valve.unload_area_id]  # 注意：一个team_id可能对应多个unload_area_id
                else:
                    cls.group_dump_dict[valve.team_id].append(valve.unload_area_id)
                    cls.dump_group_dict[valve.unload_area_id] = valve.team_id  # 一个unload_area_id只对应一个team_id
            # group_excavator_dict = {} -->>  {group_id: [excavator_id, unload_area_id], ...}  # 一个team_id对应一组excavator_id, unload_area_id
            # excavator_group_dict = {} -->>  excavator_id -> team_id  一个excavator_id只对应一个team_id
            for item in session_mysql.query(DispatchMatch).filter_by(group_type=1).all():
                cls.group_excavator_dict[item.team_id] = [item.exactor_id, item.unload_area_id]
                cls.excavator_group_dict[item.exactor_id] = item.team_id
            # group_truck_dict = {} -->> {group_id:[truck_id,truck_id],...}
            # truck_group_dict = {} -->> truck_id -> team_id
            for key in session_mysql.query(DispatchEquipment).filter_by(group_type=1).all():
                if key.group_code in group_code_dict:
                    if key.group_code not in cls.group_truck_dict:
                        cls.group_truck_dict[key.group_code] = [key.equipment_id]
                    else:
                        cls.group_truck_dict[key.group_code].append(key.equipment_id)
                    cls.truck_group_dict[key.equipment_id] = group_code_dict[key.group_code]
        except Exception as es:
            logger.error("分组到卸载区的数据更新异常")
            logger.error(es)

    @classmethod
    def update_group_mode(cls):
        """
        @date：2022/6/2 19:49
        @author：maqc
        @desc：处理其它类型的数据
        """
        logger = get_logger("mqc.update_group_mode")
        try:
            for value in session_mysql.query(DispatchMode).all():
                cls.group_mode[value.mode_name] = value.mode_code
        except Exception as es:
            logger.error("派车模式数据更新异常")
            logger.error(es)

    @classmethod
    def dispatch_group_init(cls):
        """
        update basic paras (group_set, dict, num ...)
        :return:
        """
        pass

    @classmethod
    # 距离-->>数据格式：矩阵-->>to_load_distance
    def update_route_distance(cls):
        """
        @date：2022/6/2 19:50
        @author：maqc
        @desc：更新路网距离，返回矩阵格式数据
        """
        load_exactor_dict = {}  # 装载区id-->>电铲编号的映射
        logger = get_logger("mqc.update_route_distance")
        try:
            for value in session_postgre.query(DiggingWorkArea).all():
                load_exactor_dict[value.Id] = value.Exactorld
            for value in session_postgre.query(WalkTime).all():
                if value.load_area_id in load_exactor_dict:
                    cls.load_excavator_distance[value.load_area_id] = [load_exactor_dict[value.load_area_id],
                                                                       value.to_load_distance]
                    cls.unload_excavator_distance[value.unload_area_id] = [load_exactor_dict[value.load_area_id],
                                                                           value.to_unload_distance]
        except Exception as es:
            logger.error("路网数据更新异常")
            logger.error(es)
