#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2021/7/21 16:45
# @Author : Opfer
# @Site :
# @File : realtime_dispatch.py
# @Software: PyCharm


# 实时调度模块

from traffic_flow.traffic_flow_planner import *
from para_config import *
from equipment.truck import TruckInfo
from equipment.excavator import ExcavatorInfo
from equipment.dump import DumpInfo
import sched
import time

dump = DumpInfo()
excavator = ExcavatorInfo()
truck = TruckInfo(dump, excavator)


# 调度类
class Dispatcher(WalkManage):
    def __init__(self):

        # 模拟挖机/卸载设备产量(防止调度修改真实产量)
        self.sim_dump_real_mass = np.zeros(dump.get_dump_num())
        self.sim_excavator_real_mass = np.zeros(excavator.get_excavator_num())
        # 真实设备可用时间
        self.cur_truck_reach_dump = np.zeros(truck.get_truck_num())
        self.cur_truck_reach_excavator = np.zeros(truck.get_truck_num())
        self.cur_excavator_ava_time = np.zeros(excavator.get_excavator_num())
        self.cur_dump_ava_time = np.zeros(dump.get_dump_num())
        # 卡车完成装载及卸载时间(矿卡可用时间)
        self.cur_truck_ava_time = np.zeros(truck.get_truck_num())
        # 模拟矿卡可用时间
        self.sim_truck_ava_time = np.zeros(truck.get_truck_num())
        # 模拟各设备可用时间(防止调度修改真实产量)
        self.sim_excavator_ava_time = np.zeros(excavator.get_excavator_num())
        self.sim_dump_ava_time = np.zeros(dump.get_dump_num())
        # 挖机/卸载设备预计产量(包含正在驶往挖机/卸载设备那部分矿卡的载重)
        self.pre_dump_real_mass = np.zeros(dump.get_dump_num())
        self.pre_excavator_real_mass = np.zeros(excavator.get_excavator_num())

        # 维护一个矿卡调度表
        self.Seq = [[] for _ in range(truck.get_truck_num())]
        # 调度开始时间
        self.start_time = datetime.now()
        # self.relative_now_time = datetime.now() - self.start_time

        # 下面是交通流调度部分
        # 驶往挖机的实际车流
        self.actual_goto_excavator_traffic_flow = np.zeros(
            (dump.get_dump_num(), excavator.get_excavator_num())
        )
        # 驶往卸载设备的实际车流
        self.actual_goto_dump_traffic_flow = np.zeros(
            (excavator.get_excavator_num(), dump.get_dump_num())
        )

        # 驶往挖机的实际车次
        self.goto_dump_truck_num = np.zeros(
            (excavator.get_excavator_num(), dump.get_dump_num())
        )
        # 驶往卸载设备的实际车次
        self.goto_excavator_truck_num = np.zeros(
            (dump.get_dump_num(), excavator.get_excavator_num())
        )

        # 驶往挖机的理想车流
        self.opt_goto_dump_traffic_flow = np.zeros(
            (excavator.get_excavator_num(), dump.get_dump_num())
        )
        # 驶往卸载设备的实际车流
        self.opt_goto_excavator_traffic_flow = np.zeros(
            (dump.get_dump_num(), excavator.get_excavator_num())
        )

        self.path = PathPlanner()

        self.group = Group()

    # 更新矿卡预计抵达目的地时间
    def update_truck_reach_time(self):
        try:
            dynamic_excavator_num = excavator.get_excavator_num()
            dumps = dump.get_dump_num()
            trucks = truck.get_truck_num()

            truck_current_task = truck.get_truck_current_task()

            truck_current_trip = truck.get_truck_current_trip()

            cur_truck_reach_excavator = truck.get_truck_reach_excavator()

            cur_truck_reach_dump = truck.get_truck_reach_dump()

            excavator_ava_ls = [[] for _ in range(dynamic_excavator_num)]
            dump_ava_ls = [[] for _ in range(dumps)]
            for i in range(trucks):
                task = truck_current_task[truck.truck_index_to_uuid_dict[i]]
                end_area_index = truck_current_trip[i][1]
                if task in [0, 1]:
                    reach_time = cur_truck_reach_excavator[i]
                    excavator_ava_ls[end_area_index].append(
                        [reach_time, i, end_area_index]
                    )
                elif task in [3, 4]:
                    reach_time = cur_truck_reach_dump[i]
                    dump_ava_ls[end_area_index].append([reach_time, i, end_area_index])
                elif task == -2:
                    self.cur_truck_ava_time[i] = (
                        datetime.now() - self.start_time
                    ) / timedelta(hours=0, minutes=1, seconds=0)

            # print(truck_index_to_uuid_dict)
            # print(excavator_ava_ls)
            # print(dump_ava_ls)
        except Exception as es:
            logger.error("矿卡预计抵达时间计算异常")
            logger.error(es)

        return excavator_ava_ls, dump_ava_ls

    # 更新挖机预计可用时间
    def update_excavator_ava_time(self, excavator_ava_ls):

        # 初始化挖机可用时间
        self.cur_excavator_ava_time = np.full(
            get_value("dynamic_excavator_num"),
            (datetime.now() - self.start_time)
            / timedelta(hours=0, minutes=1, seconds=0),
        )

        loading_time = excavator.get_loading_time()

        loading_task_time = excavator.get_loading_task_time()

        try:

            now = float(
                (datetime.now() - self.start_time)
                / timedelta(hours=0, minutes=1, seconds=0)
            )

            for reach_ls in excavator_ava_ls:
                if len(reach_ls) != 0:
                    reach_ls = np.array(reach_ls)
                    tmp = reach_ls[np.lexsort(reach_ls[:, ::-1].T)]
                    for i in range(len(tmp)):
                        excavator_index = int(tmp[i][2])
                        self.cur_excavator_ava_time[excavator_index] = (
                            max(tmp[i][0], self.cur_excavator_ava_time[excavator_index])
                            + loading_task_time[excavator_index]
                        )
                        self.cur_truck_ava_time[
                            int(tmp[i][1])
                       ] = self.cur_excavator_ava_time[excavator_index]

                        # # 若挖机可用时间严重偏离，进行修正
                        # if abs(self.cur_excavator_ava_time[excavator_index] - now) > 60:
                        #     self.cur_truck_ava_time[int(tmp[i][1])] = now
                        # if abs(self.cur_excavator_ava_time[excavator_index] - now) > 60:
                        #     self.cur_excavator_ava_time[excavator_index] = now
        except Exception as es:
            logger.error("挖机可用时间计算异常")
            logger.error(es)

    # 更新卸载设备预计可用时间
    def update_dump_ava_time(self, dump_ava_ls):

        dynamic_dump_num = dump.get_dump_num()

        # 初始化卸载设备可用时间
        self.cur_dump_ava_time = np.full(
            dynamic_dump_num,
            (datetime.now() - self.start_time)
            / timedelta(hours=0, minutes=1, seconds=0),
        )

        unloading_time = dump.get_unloading_time()

        unloading_task_time = dump.get_unloading_task_time()

        try:

            now = float(
                (datetime.now() - self.start_time)
                / timedelta(hours=0, minutes=1, seconds=0)
            )

            for reach_ls in dump_ava_ls:
                if len(reach_ls) != 0:
                    reach_ls = np.array(reach_ls)
                    tmp = reach_ls[np.lexsort(reach_ls[:, ::-1].T)]
                    for i in range(len(tmp)):
                        dump_index = int(tmp[i][2])
                        self.cur_dump_ava_time[dump_index] = (
                            max(tmp[i][0], self.cur_dump_ava_time[dump_index])
                            + unloading_task_time[dump_index]
                        )
                        self.cur_truck_ava_time[
                            int(tmp[i][1])
                        ] = self.cur_dump_ava_time[dump_index]

                        # # 若卸载设备可用时间严重偏离，进行修正
                        # if abs(self.cur_dump_ava_time[dump_index] - now) > 60:
                        #     self.cur_dump_ava_time[dump_index] = now
                        # if abs(self.cur_truck_ava_time[int(tmp[i][1])] - now) > 60:
                        #     self.cur_truck_ava_time[int(tmp[i][1])] = now
        except Exception as es:
            logger.error("卸载设备可用时间计算异常")
            logger.error(es)

    # 更新实际交通流
    def update_actual_traffic_flow(self):

        loading_task_time = excavator.get_loading_task_time()

        unloading_task_time = dump.get_unloading_task_time()

        truck_current_task = truck.get_truck_current_task()
        truck_current_trip = truck.get_truck_current_trip()
        payload = truck.get_payload()

        dynamic_dump_num = get_value("dynamic_dump_num")
        dynamic_excavator_num = get_value("dynamic_excavator_num")
        dynamic_truck_num = get_value("dynamic_truck_num")

        self.goto_dump_truck_num = np.zeros((dynamic_excavator_num, dynamic_dump_num))
        self.actual_goto_dump_traffic_flow = np.zeros(
            (dynamic_excavator_num, dynamic_dump_num)
        )
        self.goto_excavator_truck_num = np.zeros(
            (dynamic_dump_num, dynamic_excavator_num)
        )
        self.actual_goto_excavator_traffic_flow = np.zeros(
            (dynamic_dump_num, dynamic_excavator_num)
        )

        # try:
        logger.info("dynamic_truck_num")
        logger.info(dynamic_truck_num)

        print("truck.truck_index_to_uuid_dict")
        print(truck.truck_index_to_uuid_dict)

        print("truck_current_task")
        print(truck_current_task)

        for i in range(dynamic_truck_num):
            task = truck_current_task[truck.truck_index_to_uuid_dict[i]]
            end_area_index = truck_current_trip[i][1]
            start_area_index = truck_current_trip[i][0]


            if task in heavy_task_set:
                self.goto_dump_truck_num[start_area_index][end_area_index] += 1
                self.actual_goto_dump_traffic_flow[start_area_index][end_area_index] += float(payload[i])

            # logger.info("debug2")

            if task in empty_task_set:
                self.goto_excavator_truck_num[start_area_index][end_area_index] += 1
                self.actual_goto_excavator_traffic_flow[start_area_index][end_area_index] += float(payload[i])


        self.actual_goto_dump_traffic_flow = self.actual_goto_dump_traffic_flow / (
            self.distance_to_dump.reshape(dynamic_excavator_num, dynamic_dump_num)
            / (1000 * empty_speed)
            + np.expand_dims(unloading_task_time, axis=0).repeat(
                dynamic_excavator_num, axis=0
            )
        )

        self.actual_goto_excavator_traffic_flow = (
            self.actual_goto_excavator_traffic_flow
            / (
                self.distance_to_excavator.reshape(
                    dynamic_dump_num, dynamic_excavator_num
                )
                / (1000 * heavy_speed)
                + np.expand_dims(loading_task_time, axis=0).repeat(
                    dynamic_dump_num, axis=0
                )
            )
        )

        logger.info("self.goto_dump_truck_num")
        logger.info(self.goto_dump_truck_num)

        logger.info("self.actual_goto_dump_traffic_flow")
        logger.info(self.actual_goto_dump_traffic_flow)

        logger.info("self.goto_excavator_truck_num")
        logger.info(self.goto_excavator_truck_num)

        logger.info("self.actual_goto_excavator_traffic_flow")
        logger.info(self.actual_goto_excavator_traffic_flow)

        # except Exception as es:
        #     logger.error("未知错误001")
        #     logger.error(es)

        # print("驶往卸点实际载重")
        # print(self.actual_goto_dump_traffic_flow)
        # print("卸点路段行驶时间(h)")
        # print((self.distance_to_dump.reshape(dynamic_excavator_num, dynamic_dump_num) / (1000 * empty_speed)))
        # print("驶往卸点实际车流")
        # print(self.actual_goto_dump_traffic_flow)

        logger.info("驶往卸点实际载重")
        logger.info(self.actual_goto_dump_traffic_flow)
        logger.info("卸点路段行驶时间(h)")
        logger.info(
            (
                self.distance_to_dump.reshape(dynamic_excavator_num, dynamic_dump_num)
                / (1000 * empty_speed)
            )
        )
        logger.info("驶往卸点实际车流")
        logger.info(self.actual_goto_dump_traffic_flow)
        logger.info("________________loading_task_time__________")
        logger.info(loading_task_time)

        # self.actual_goto_excavator_traffic_flow = (
        #     self.actual_goto_excavator_traffic_flow
        #     / (
        #         self.distance_to_excavator.reshape(
        #             dynamic_dump_num, dynamic_excavator_num
        #         )
        #         / (1000 * heavy_speed)
        #         + np.expand_dims(loading_task_time, axis=0).repeat(
        #             dynamic_dump_num, axis=0
        #         )
        #     )
        # )

        # print("驶往挖机实际载重")
        # print(self.actual_goto_excavator_traffic_flow)
        # print("挖机路段行驶时间(h)")
        # print((self.distance_to_excavator.reshape(dynamic_excavator_num, dynamic_dump_num) / (1000 * heavy_speed)))
        # print("驶往挖机实际车流")
        # print(self.actual_goto_excavator_traffic_flow)

        logger.info("驶往挖机实际载重")
        logger.info(self.actual_goto_excavator_traffic_flow)
        logger.info("挖机路段行驶时间(h)")
        logger.info(
            (
                self.distance_to_excavator.reshape(
                    dynamic_excavator_num, dynamic_dump_num
                )
                / (1000 * heavy_speed)
            )
        )
        logger.info("驶往挖机实际车流")
        logger.info(self.actual_goto_excavator_traffic_flow)

    def dispatcher_period_update(self):

        # 装载映射参数及
        self.period_map_para_load()

        self.period_walk_para_load()

        # 更新卸载设备对象
        dump.para_period_update()

        # 更新挖机对象
        excavator.para_period_update()

        # 更新矿卡对象
        truck.para_period_update(dump, excavator)

        truck.state_period_update()

        # 更新实时车流
        self.update_actual_traffic_flow()

        # 计算理想车流
        (self.opt_goto_dump_traffic_flow, self.opt_goto_excavator_traffic_flow,) = traffic_flow_plan(truck)

        # 矿卡抵达时间
        excavator_reach_list, dump_reach_list = self.update_truck_reach_time()

        # 挖机可用时间
        self.update_excavator_ava_time(excavator_reach_list)

        # 卸载设备可用时间
        self.update_dump_ava_time(dump_reach_list)

        self.cost_to_excavator, self.cost_to_dump, self.cost_park_to_excavator = self.path.walk_cost()

        # 调度分组更新
        self.group.period_update()

    def sim_para_reset(self):

        # 设备可用时间重置
        self.sim_truck_ava_time = copy.deepcopy(self.cur_truck_ava_time)
        self.sim_excavator_ava_time = copy.deepcopy(self.cur_excavator_ava_time)
        self.sim_dump_ava_time = copy.deepcopy(self.cur_dump_ava_time)

    def reset(self):
        # 模拟挖机/卸载设备产量(防止调度修改真实产量)
        self.sim_dump_real_mass = np.zeros(dump.get_dump_num())
        self.sim_excavator_real_mass = np.zeros(excavator.get_excavator_num())
        # 真实设备可用时间
        self.cur_truck_reach_dump = np.zeros(truck.get_truck_num())
        self.cur_truck_reach_excavator = np.zeros(truck.get_truck_num())
        self.cur_excavator_ava_time = np.zeros(excavator.get_excavator_num())
        self.cur_dump_ava_time = np.zeros(dump.get_dump_num())
        # 卡车完成装载及卸载时间(矿卡可用时间)
        self.cur_truck_ava_time = np.zeros(truck.get_truck_num())
        # 模拟矿卡可用时间
        self.sim_truck_ava_time = np.zeros(truck.get_truck_num())
        # 模拟各设备可用时间(防止调度修改真实产量)
        self.sim_excavator_ava_time = np.zeros(excavator.get_excavator_num())
        self.sim_dump_ava_time = np.zeros(dump.get_dump_num())
        # 挖机/卸载设备预计产量(包含正在驶往挖机/卸载设备那部分矿卡的载重)
        self.pre_dump_real_mass = np.zeros(dump.get_dump_num())
        self.pre_excavator_real_mass = np.zeros(excavator.get_excavator_num())

        # 维护一个矿卡调度表
        self.Seq = [[] for _ in range(truck.get_truck_num())]

        # 下面是交通流调度部分
        # 驶往挖机的实际车流
        self.actual_goto_excavator_traffic_flow = np.zeros(
            (dump.get_dump_num(), excavator.get_excavator_num())
        )
        # 驶往卸载设备的实际车流
        self.actual_goto_dump_traffic_flow = np.zeros(
            (excavator.get_excavator_num(), dump.get_dump_num())
        )

        # 驶往挖机的实际车次
        self.goto_dump_truck_num = np.zeros(
            (excavator.get_excavator_num(), dump.get_dump_num())
        )
        # 驶往卸载设备的实际车次
        self.goto_excavator_truck_num = np.zeros(
            (dump.get_dump_num(), excavator.get_excavator_num())
        )

        # 驶往挖机的理想车流
        self.opt_goto_dump_traffic_flow = np.zeros(
            (excavator.get_excavator_num(), dump.get_dump_num())
        )
        # 驶往卸载设备的实际车流
        self.opt_goto_excavator_traffic_flow = np.zeros(
            (dump.get_dump_num(), excavator.get_excavator_num())
        )

    def truck_schedule(self, truck_id):

        rule3 = session_mysql.query(DispatchRule).filter_by(id=3).first().disabled
        rule4 = session_mysql.query(DispatchRule).filter_by(id=4).first().disabled

        # cost_to_excavator, cost_to_dump, cost_park_to_excavator = self.path.walk_cost()

        excavator_priority_coefficient = excavator.excavator_priority_coefficient

        excavator_material_priority = excavator.excavator_material_priority

        # 矿卡对应序号
        truck_index = truck.truck_uuid_to_index_dict[truck_id]
        # 矿卡行程
        trip = truck.get_truck_current_trip()[truck_index]
        # 矿卡当前任务
        task = truck.get_truck_current_task()[truck.truck_index_to_uuid_dict[truck_index]]
        # 挖机装载时间
        loading_time = excavator.get_loading_time()
        # 路网信息
        walk_time_park_to_excavator = walk_manage.get_walk_time_park_to_excavator() \
                                      * (empty_speed / float(truck.empty_speed[truck_id]))

        if truck_id not in self.group.dispatch_truck_group:
            logger.error("无该矿卡")
            return -1
        # 矿卡调度分组
        group_id = self.group.dispatch_truck_group[truck_id]

        dynamic_dump_num = dump.get_dump_num()
        dynamic_excavator_num = excavator.get_excavator_num()

        now = float(
            (datetime.now() - self.start_time)
            / timedelta(hours=0, minutes=1, seconds=0))

        logger.info("==========================================================")
        logger.info(f"调度矿卡 {truck_id} {truck_index} {truck_uuid_to_name_dict[truck_id]}")

        target = 0

        if task == -2:
            try:
                logger.info("矿卡状态：矿卡启动或故障恢复")
                logger.info("矿卡行程：无")
                logger.info(f"涉及挖机：{list(excavator.excavator_uuid_to_index_dict.keys())}")
                logger.info(
                    f"行程时间：{(np.maximum(self.sim_excavator_ava_time, now + walk_time_park_to_excavator[0, :]) + loading_time - now)}")
                logger.info(f"行驶时间：{walk_time_park_to_excavator[0, :] + loading_time}")
                logger.info("物料类型")
                if truck_id in truck.truck_material_bind:
                    logger.info(truck.truck_material_bind[truck_id])
                logger.info("挖机物料优先级")
                logger.info(excavator_material_priority)
                logger.info("挖机设备优先级")
                logger.info(excavator_priority_coefficient)

                logger.info("分组车流")
                logger.info(self.group.group_actual_goto_dump_traffic_flow[group_id])
                logger.info(self.group.group_opt_goto_dump_traffic_flow[group_id])

            except Exception as es:
                logger.error(f"矿卡{truck_id}状态不匹配")
                logger.error(es)

            # 矿卡是否存在绑定挖机
            if truck_id in truck.truck_excavator_bind:
                target = excavator.excavator_uuid_to_index_dict[truck.truck_excavator_bind[truck_id]]
            else:

                transport_value = self.group.group_park_to_excavator[group_id]

                excavator_exclude_modify = self.group.group_excavator_exclude_modify[truck_id]
                excavator_material_bind_modify = self.group.group_excavator_material_bind_modify[truck_id]

                logger.info("transport_value")
                # logger.info(transport_value)
                # target = np.argmin(
                #     transport_value
                #     + truck.excavator_exclude_modify[truck_index]
                #     + truck.excavator_material_bind_modify[truck_index])
                logger.info(transport_value)
                target = np.argmin(
                    transport_value
                    + excavator_exclude_modify)
                    # + excavator_material_bind_modify)
                target = self.excavator_uuid_to_index_dict[self.group.group_excavator_index_to_uuid_dict[group_id][target]]

            logger.info(f"目的地：{excavator.excavator_index_to_uuid_dict[target]}")

        if task in [0, 1, 2]:
            try:
                logger.info("矿卡状态：矿卡空载")
                logger.info(f"涉及卸载设备：{list(dump.dump_uuid_to_index_dict.keys())}")
            except Exception as es:
                logger.error(f"矿卡{truck_id}状态不匹配")
                logger.error(es)

            try:
                assert np.array(self.actual_goto_dump_traffic_flow).shape == (
                    dynamic_excavator_num,
                    dynamic_dump_num,)
                assert np.array(self.opt_goto_dump_traffic_flow).shape == (
                    dynamic_excavator_num,
                    dynamic_dump_num,)
            except Exception as es:
                logger.warning(es)
                self.actual_goto_dump_traffic_flow = np.array(
                    self.actual_goto_dump_traffic_flow).reshape((dynamic_excavator_num, dynamic_dump_num))
                self.opt_goto_dump_traffic_flow = np.array(
                    self.opt_goto_dump_traffic_flow).reshape((dynamic_excavator_num, dynamic_dump_num))

            self.actual_goto_dump_traffic_flow = np.array(self.actual_goto_dump_traffic_flow)
            self.opt_goto_dump_traffic_flow = np.array(self.opt_goto_dump_traffic_flow)

            try:
                logger.info("挖机id:")
                logger.info(excavator.excavator_uuid_to_index_dict)
                logger.info("卸点id:")
                logger.info(dump.dump_uuid_to_index_dict)
                logger.info(f"卸载点实际车流:")
                logger.info(self.actual_goto_dump_traffic_flow)
                logger.info(f"卸载点理想车流:")
                logger.info(self.opt_goto_dump_traffic_flow)

                logger.info("卸载点实际车流")
                logger.info(self.actual_goto_dump_traffic_flow[int(trip[1]), :])
                logger.info("卸载点理想车流")
                logger.info(self.opt_goto_dump_traffic_flow[int(trip[1]), :])


                logger.info("空载trip")
                logger.info(trip)
                logger.info("物料类型")
                if truck_id in truck.truck_material_bind:
                    logger.info(truck.truck_material_bind[truck_id])
                logger.info("驶往卸点的运输成本")
                logger.info(self.cost_to_dump)
                logger.info("卸点物料修正")
                logger.info(truck.dump_material_bind_modify)

            except Exception as es:
                logger.info("车流及修正因子")
                logger.info(es)

            if truck_id in truck.truck_dump_bind:
                bind_unload_area_id = truck.truck_dump_bind[truck_id]
                for key, value in dump.dump_index_to_unload_area_index_dict.items():
                    if value == unload_area_uuid_to_index_dict[bind_unload_area_id]:
                        target = key
                        break
            else:
                excavator_index = int(trip[1])
                excavator_id = self.excavator_index_to_uuid_dict[excavator_index]

                print(self.group.group_excavator_uuid_to_index_dict[group_id])

                group_excavator_index = self.group.group_excavator_uuid_to_index_dict[group_id][excavator_id]

                if rule3 and rule4:
                    # transport_value = self.cost_to_dump[:, int(trip[1])]
                    transport_value = self.group.group_walk_to_dump_cost[group_excavator_index, :]
                else:

                    # 提取group actual traffic flow
                    group_actual_goto_dump_traffic_flow = self.group.group_actual_goto_dump_traffic_flow[group_id]

                    # 提取group actual traffic flow
                    group_opt_goto_dump_traffic_flow = self.group.group_opt_goto_dump_traffic_flow[group_id]

                    logger.info("驶往卸点分组车流")
                    logger.info(group_actual_goto_dump_traffic_flow)
                    logger.info(group_opt_goto_dump_traffic_flow)


                    transport_value = (group_actual_goto_dump_traffic_flow[group_excavator_index, :] + 0.001) \
                                    / (group_opt_goto_dump_traffic_flow[group_excavator_index, :] + 0.001)

                    # transport_value = (self.actual_goto_dump_traffic_flow[int(trip[1]), :] + 0.001) \
                    #                 / (self.opt_goto_dump_traffic_flow[int(trip[1]), :] + 0.001)
                    logger.info("transport_value")
                    logger.info(transport_value)
                    logger.info("dump_material_bind_modify")
                    logger.info(truck.dump_material_bind_modify[truck_index])

                dump_material_bind_modify = self.group.group_dump_material_bind_modify[truck_id]

                target = np.argmin(
                    transport_value
                    + dump_material_bind_modify)

                target = self.dump_uuid_to_index_dict[self.group.group_dump_index_to_uuid_dict[group_id][target]]

            logger.info("车流比:")
            logger.info((self.actual_goto_dump_traffic_flow[int(trip[1]), :] + 0.001) \
                        / (self.opt_goto_dump_traffic_flow[int(trip[1]), :] + 0.001))

            logger.info(f"目的地：{dump.dump_index_to_uuid_dict[target]}")

        elif task in [3, 4, 5]:

            try:
                logger.info("矿卡状态：矿卡重载")
                logger.info(f"涉及挖机设备：{list(excavator.excavator_uuid_to_index_dict.keys())}")
            except Exception as es:
                logger.error(f"矿卡{truck_id}状态不匹配")
                logger.error(es)

            # 读取车流信息
            try:
                assert np.array(self.actual_goto_excavator_traffic_flow).shape == (
                    dynamic_dump_num,
                    dynamic_excavator_num,)
                assert np.array(self.opt_goto_excavator_traffic_flow).shape == (
                    dynamic_dump_num,
                    dynamic_excavator_num,)

            except Exception as es:
                logger.warning(es)
                self.actual_goto_excavator_traffic_flow = np.array(
                    self.actual_goto_excavator_traffic_flow).reshape((dynamic_dump_num, dynamic_excavator_num))
                self.opt_goto_excavator_traffic_flow = np.array(
                    self.opt_goto_excavator_traffic_flow).reshape((dynamic_dump_num, dynamic_excavator_num))


            # 不知道为什么，偶尔变成了list
            self.actual_goto_excavator_traffic_flow = np.array(self.actual_goto_excavator_traffic_flow)
            self.opt_goto_excavator_traffic_flow = np.array(self.opt_goto_excavator_traffic_flow)

            try:
                logger.info("挖机id:")
                logger.info(excavator.excavator_uuid_to_index_dict)
                logger.info("卸点id:")
                logger.info(dump.dump_uuid_to_index_dict)
                logger.info(f"挖机实际车流:")
                logger.info(self.actual_goto_excavator_traffic_flow)
                logger.info(f"挖机理想车流:")
                logger.info(self.opt_goto_excavator_traffic_flow)
                logger.info("重载trip")
                logger.info(trip)


                try:
                    logger.info("挖机实际车流_行")
                    logger.info(self.actual_goto_excavator_traffic_flow[trip[1], :])
                    logger.info("挖机理想车流_行")
                    logger.info(self.opt_goto_excavator_traffic_flow[trip[1], :])
                except Exception as es:
                    logger.info("trip出错")
                    logger.info(trip)
                    logger.info(es)

                logger.info("物料类型")
                if truck_id in truck.truck_material_bind:
                    logger.info(truck.truck_material_bind[truck_id])
                logger.info("驶往挖机的运输成本")
                logger.info(self.cost_to_excavator)
                logger.info("挖机物料修正")
                logger.info(truck.excavator_material_bind_modify)
                logger.info("挖机优先级修正")
                logger.info(excavator.excavator_priority_coefficient)
            except Exception as es:
                logger.info("车流及修正因子")
                logger.info(es)

            # 计算目的地
            try:
                if truck_id in truck.truck_excavator_bind:
                    target = excavator.excavator_uuid_to_index_dict[truck.truck_excavator_bind[truck_id]]
                    logger.info("矿卡已绑定挖机")
                else:
                    logger.info("cost_to_excavator")
                    logger.info(self.cost_to_excavator)

                    dump_index = int(trip[1])
                    dump_id = self.dump_uuid_to_index_dict[dump_index]

                    if rule3 and rule4:
                        # transport_value = self.cost_to_excavator[int(trip[1]), :]
                        transport_value = self.group.group_walk_to_excavator_cost[dump_index, :]
                    else:

                        group_dump_index = self.group.group_dump_uuid_to_index_dict[group_id][dump_id]

                        # 提取group actual traffic flow
                        group_actual_goto_excavator_traffic_flow = self.group.group_actual_goto_excavator_traffic_flow[
                            group_id]

                        # 提取group actual traffic flow
                        group_opt_goto_excavator_traffic_flow = self.group.group_opt_goto_excavator_traffic_flow[
                            group_id]

                        logger.info("驶往挖机分组车流")
                        logger.info(group_actual_goto_excavator_traffic_flow)
                        logger.info(group_opt_goto_excavator_traffic_flow)

                        transport_value = (group_actual_goto_excavator_traffic_flow[group_dump_index, :] + 0.001) \
                                          / (group_opt_goto_excavator_traffic_flow[group_dump_index, :] + 0.001)


                        # transport_value = (self.actual_goto_excavator_traffic_flow[trip[1], :] + 0.001) \
                        #                     / (self.opt_goto_excavator_traffic_flow[trip[1], :] + 0.001)
                        logger.info("transport_value")
                        logger.info(transport_value)

                    # target = np.argmin(transport_value
                    #     + truck.excavator_exclude_modify[truck_index]
                    #     + truck.excavator_material_bind_modify[truck_index])

                    excavator_exclude_modify = self.group.group_excavator_exclude_modify[truck_id]
                    excavator_material_bind_modify = self.group.group_excavator_material_bind_modify[truck_id]

                    logger.info(transport_value)
                    target = np.argmin(
                        transport_value
                        + excavator_exclude_modify)
                        # + excavator_material_bind_modify)

                    target = self.excavator_uuid_to_index_dict[self.group.group_excavator_index_to_uuid_dict[target]]
            except Exception as es:
               logger.info("trip出错1")
               logger.info(es)


            try:
               logger.info("车流比:")
               logger.info(
                (self.actual_goto_excavator_traffic_flow[trip[1], :] + 0.001)
                / (self.opt_goto_excavator_traffic_flow[trip[1], :] + 0.001))
            except Exception as es:
                logger.info("trip出错2")
                logger.info(es)

            logger.info(f"目的地：{excavator.excavator_index_to_uuid_dict[target]}")

        logger.info("==========================================================")

        return target

    def schedule_construct(self):

        global truck
        global excavator
        global dump

        self.reset()

        print("self.cur_truck_ava_time", self.cur_truck_ava_time)

        try:

            # 读取所需信息
            dynamic_truck_num = get_value("dynamic_truck_num")
            truck_current_trip = truck.get_truck_current_trip()
            truck_current_task = truck.get_truck_current_task()
            payload = truck.get_payload()
            unloading_time = dump.get_unloading_time()
            loading_time = excavator.get_loading_time()

            # 出入场时间
            loading_task_time = excavator.get_loading_task_time()
            unloading_task_time = dump.get_unloading_task_time()

            walk_time_to_unload_area = walk_manage.get_walk_time_to_unload_area()
            walk_time_to_load_area = walk_manage.get_walk_time_to_load_area()

            # Seq初始化
            Seq = [[truck_current_trip[i][1], -1] for i in range(dynamic_truck_num)]

            # 根据矿卡最早可用时间顺序进行规划
            print(self.cur_truck_ava_time)
            print(truck.truck_priority)
            temp = copy.deepcopy(self.cur_truck_ava_time) - truck.truck_priority

            try:
                # 没有启动的矿卡加上一个很大的值，降低其优先级
                for i in range(dynamic_truck_num):
                    task = truck_current_task[truck.truck_index_to_uuid_dict[i]]
                    if task == -2:
                        temp[i] = temp[i] + M
            except Exception as es:
                logger.error("矿卡排序启动异常")
                logger.error(es)

            index = np.argsort(temp.reshape(1, -1))
            index = index.flatten()

            # 对于在线矿卡已经赋予新的派车计划，更新其最早可用时间，及相关设备时间参数
            for truck_index in index:
                if len(Seq[truck_index]) > 0:

                    # try:
                    # 获取矿卡id
                    truck_id = truck.truck_index_to_uuid_dict[truck_index]

                    # 判断矿卡是否禁用
                    if truck_id in truck.update_truck_disable_list():
                        continue

                    # 获取矿卡当前任务
                    task = truck_current_task[truck.truck_index_to_uuid_dict[truck_index]]

                    # 矿卡结束当前派车计划后的目的地
                    end_eq_index = truck_current_trip[truck_index][1]

                    # 调用调度函数，得到最优目的地序号
                    target_eq_index = self.truck_schedule(truck.truck_index_to_uuid_dict[truck_index])

                    # 写入Seq序列
                    Seq[truck_index][1] = target_eq_index

                    try:
                        group_id = self.group.dispatch_truck_group[truck_id]
                    except Exception as es:
                        logger.error("非动态调度矿卡")
                        logger.error(es)

                    # except Exception as es:
                    #     # logger.error(f'矿卡 {truck_uuid_to_name_dict[self.truck_index_to_uuid_dict[truck_index]]} 派车计划计算异常')
                    #     logger.error(f'矿卡派车计划计算异常')
                    #     logger.error(es)

                    try:

                        if task in empty_task_set:
                            target_area_index = dump.dump_index_to_unload_area_index_dict[target_eq_index]
                            end_area_index = excavator.excavator_index_to_load_area_index_dict[end_eq_index]
                            # 更新变量，预计产量更新
                            self.sim_dump_real_mass[target_eq_index] = \
                                (self.sim_dump_real_mass[target_eq_index] + payload[truck_index])
                            # 预计卸载设备可用时间更新
                            self.sim_dump_ava_time[target_eq_index] = (
                                max(
                                    self.sim_dump_ava_time[target_eq_index],
                                    self.sim_truck_ava_time[truck_index] + \
                                    walk_time_to_unload_area[target_area_index][end_area_index],)
                                + unloading_task_time[target_eq_index]
                            )
                        elif task in heavy_task_set:
                            target_area_index = (excavator.excavator_index_to_load_area_index_dict[target_eq_index])
                            end_area_index = dump.dump_index_to_unload_area_index_dict[end_eq_index]
                            # 更新变量，预计产量更新
                            self.sim_excavator_real_mass[target_eq_index] = (self.sim_excavator_real_mass[target_eq_index]
                                + payload[truck_index])
                            # 预计装载点可用时间更新
                            self.sim_excavator_ava_time[target_eq_index] = (
                                max(self.sim_excavator_ava_time[target_eq_index], self.sim_truck_ava_time[truck_index]
                                    + walk_time_to_unload_area[end_area_index][target_area_index],) \
                                + loading_task_time[target_eq_index])
                        else:
                            pass
                    except Exception as es:
                        logger.error( f"矿卡 {truck_uuid_to_name_dict[truck.truck_index_to_uuid_dict[truck_index]]} 调度状态更新异常")
                        logger.error(es)

            for i in range(len(Seq)):
                try:

                    truck_id = truck.truck_index_to_uuid_dict[i]
                    group_id = self.group.dispatch_truck_group[truck_id]

                    record = {"truckId": truck.truck_index_to_uuid_dict[i]}
                    task = truck.get_truck_current_task()[truck.truck_index_to_uuid_dict[i]]
                    if task in empty_task_set:
                        item = (
                            session_mysql.query(Dispatch)
                            .filter_by(dump_id=dump.dump_index_to_uuid_dict[Seq[i][1]],
                                       exactor_id=excavator.excavator_index_to_uuid_dict[Seq[i][0]],
                                       truck_id=truck_id,
                                       group_id=group_id,
                                       isauto=1, isdeleted=0,).first())
                        record["exactorId"] = item.exactor_id
                        record["dumpId"] = item.dump_id
                        record["loadAreaId"] = item.load_area_id
                        record["unloadAreaId"] = item.unload_area_id
                        record["dispatchId"] = item.id
                        record["isdeleted"] = False
                        record["creator"] = item.creator
                        record["createtime"] = item.createtime.strftime(
                            "%b %d, %Y %I:%M:%S %p")
                    elif task in heavy_task_set:
                        item = (
                            session_mysql.query(Dispatch)
                            .filter_by(exactor_id=excavator.excavator_index_to_uuid_dict[Seq[i][1]],
                                       dump_id=dump.dump_index_to_unload_area_index_dict[Seq[i][0]],
                                       truck_id=truck_id,
                                       group_id=group_id,
                                       isauto=1, isdeleted=0,).first())
                        record["exactorId"] = excavator.excavator_index_to_uuid_dict[Seq[i][1]]
                        record["dumpId"] = item.dump_id
                        record["loadAreaId"] = item.load_area_id
                        record["unloadAreaId"] = item.unload_area_id
                        record["dispatchId"] = item.id
                        record["isdeleted"] = False
                        record["creator"] = item.creator
                        record["createtime"] = item.createtime.strftime(
                            "%b %d, %Y %I:%M:%S %p")
                    elif task == -2:
                        item = (
                            session_mysql.query(Dispatch)
                            .filter_by(exactor_id=excavator.excavator_index_to_uuid_dict[Seq[i][1]], group_id=group_id,
                                       isauto=1, isdeleted=0,).first())
                        record["exactorId"] = item.exactor_id
                        record["dumpId"] = item.dump_id
                        record["loadAreaId"] = item.load_area_id
                        record["unloadAreaId"] = item.unload_area_id
                        record["dispatchId"] = item.id
                        record["isdeleted"] = False
                        record["creator"] = item.creator
                        record["createtime"] = item.createtime.strftime(
                            "%b %d, %Y %I:%M:%S %p")
                    else:
                        pass

                    redis5.set(truck.truck_index_to_uuid_dict[i], str(json.dumps(record)))
                except Exception as es:
                    logger.error("调度结果写入异常-redis写入异常")
                    logger.error(f"调度结果:{Seq}")
                    logger.error(es)

            for i in range(dynamic_truck_num):
                print("dispatch_setting:")
                print(redis5.get(truck.truck_index_to_uuid_dict[i]))
        except Exception as es:
            logger.error("更新不及时-1")
            logger.error(es)

        return Seq


class Group(WalkManage):
    def __init__(self):
        self.dispatch_truck_group = {}
        self.group_num = 1
        self.group_set = set()
        self.device_group = {}
        self.group_walk_to_excavator_cost = {}
        self.group_walk_to_dump_cost = {}
        self.group_park_to_excavator = {}

        self.group_opt_goto_dump_traffic_flow = {}
        self.group_opt_goto_excavator_traffic_flow = {}
        self.group_actual_goto_dump_traffic_flow = {}
        self.group_actual_goto_excavator_traffic_flow = {}

        self.group_excavator_uuid_to_index_dict = {}
        self.group_dump_uuid_to_index_dict = {}
        self.group_excavator_index_to_uuid_dict = {}
        self.group_dump_index_to_uuid_dict = {}

        self.group_excavator_exclude_modify = {}
        self.group_excavator_material_bind_modify = {}
        self.group_dump_material_bind_modify = {}

        self.path = PathPlanner()

    def update_dispatch_truck_group(self):
        # 更新矿卡-调度分组隶属关系
        self.dispatch_truck_group = {}
        dynamic_truck_set = get_value("dynamic_truck_set")
        print("dispatch_truck_group-dynamic_truck_set")
        print(dynamic_truck_set)
        # 动态派车数量没变，但是此时某条派车计划被删除，dispatch_truck_group 就会缺失矿卡
        for truck_id in dynamic_truck_set:
            item = session_mysql.query(Dispatch).filter_by(truck_id=truck_id, isauto=1, isdeleted=0).first()
            if item is None:
                print(truck_id)
                continue
            self.dispatch_truck_group[truck_id] = item.group_id

        print(self.dispatch_truck_group)

    def update_group_set(self):
        # 更新调度组
        self.group_set = set()
        for item in session_mysql.query(Dispatch).filter_by(isauto=1, isdeleted=0).all():
            if item.group_id is not None:
                self.group_set.add(item.group_id)
        self.group_num = len(self.group_set)

    def update_device_group(self):
        # 更新设备分组group_id -> {set(dump_id), set(excavator_id)}
        self.device_group = {}
        for group_id in self.get_group_set():
            if group_id not in self.device_group:
                self.device_group[group_id] = [set(), set()]
            else:
                continue
            for item in session_mysql.query(Dispatch).filter_by(group_id=group_id, isauto=1, isdeleted=0).all():
                self.device_group[group_id][0].add(item.dump_id)
                self.device_group[group_id][1].add(item.exactor_id)

    def update_group_truck_flow(self):

        # 更新调度分组内车实时/最佳车流

        global dispatcher

        actual_goto_excavator_traffic_flow, actual_goto_dump_traffic_flow = \
            dispatcher.actual_goto_excavator_traffic_flow, dispatcher.actual_goto_dump_traffic_flow

        opt_goto_dump_traffic_flow, opt_goto_excavator_traffic_flow = traffic_flow_plan(truck)

        try:

            print("uuid_to_index_dict")
            print(dump.dump_uuid_to_index_dict)
            print(excavator.excavator_uuid_to_index_dict)

            for group_id in self.group_set:
                dump_group = self.device_group[group_id][0]        # group 类最后更新，读取派车计划及分组情况，和前面的uuid 可能不一致
                excavator_group = self.device_group[group_id][1]
                print("group")
                print(self.device_group)
                local_opt_goto_dump_traffic_flow = np.zeros((len(excavator_group), len(dump_group)))
                local_opt_goto_excavator_traffic_flow = np.zeros((len(dump_group), len(excavator_group)))
                local_actual_goto_dump_traffic_flow = np.zeros((len(excavator_group), len(dump_group)))
                local_actual_goto_excavator_traffic_flow = np.zeros((len(dump_group), len(excavator_group)))
                for excavator_id in excavator_group:
                    for dump_id in dump_group:
                        dump_group_index = self.group_dump_uuid_to_index_dict[group_id][dump_id]
                        excavator_group_index = self.group_excavator_uuid_to_index_dict[group_id][excavator_id]
                        local_opt_goto_dump_traffic_flow[excavator_group_index][dump_group_index] = \
                            opt_goto_dump_traffic_flow[excavator.excavator_uuid_to_index_dict[excavator_id]][dump.dump_uuid_to_index_dict[dump_id]]

                        local_opt_goto_excavator_traffic_flow[dump_group_index][excavator_group_index] = \
                            opt_goto_excavator_traffic_flow[dump.dump_uuid_to_index_dict[dump_id]][excavator.excavator_uuid_to_index_dict[excavator_id]]

                        local_actual_goto_dump_traffic_flow[excavator_group_index][dump_group_index] = \
                            actual_goto_dump_traffic_flow[excavator.excavator_uuid_to_index_dict[excavator_id]][dump.dump_uuid_to_index_dict[dump_id]]

                        local_actual_goto_excavator_traffic_flow[dump_group_index][excavator_group_index] = \
                            actual_goto_excavator_traffic_flow[dump.dump_uuid_to_index_dict[dump_id]][excavator.excavator_uuid_to_index_dict[excavator_id]]

                self.group_opt_goto_dump_traffic_flow[group_id] = local_opt_goto_dump_traffic_flow
                self.group_opt_goto_excavator_traffic_flow[group_id] = local_opt_goto_excavator_traffic_flow
                self.group_actual_goto_dump_traffic_flow[group_id] = local_actual_goto_dump_traffic_flow
                self.group_actual_goto_excavator_traffic_flow[group_id] = local_actual_goto_excavator_traffic_flow
        except Exception as es:
            logger.error(es)
            logger.error("分组车流更新异常")

        logger.info("group_opt_traffic_flow")
        logger.info(self.group_opt_goto_dump_traffic_flow)
        logger.info(self.group_opt_goto_excavator_traffic_flow)


    def update_group_walk_cost(self):

        # 更新调度分组路网行驶成本

        walk_to_excavator_cost, walk_to_dump_cost, park_to_excavator_cost = self.path.walk_cost()

        try:

            for group_id in self.group_set:
                dump_group = self.device_group[group_id][0]
                excavator_group = self.device_group[group_id][1]
                local_walk_to_excavator_cost = np.zeros((len(dump_group), len(excavator_group)))
                local_walk_to_dump_cost = np.zeros((len(dump_group), len(excavator_group)))
                local_park_to_excavator_cost = np.zeros((park_num, len(excavator_group)))
                for excavator_id in excavator_group:
                    for dump_id in dump_group:
                        dump_group_index = self.group_dump_uuid_to_index_dict[group_id][dump_id]
                        excavator_group_index = self.group_excavator_uuid_to_index_dict[group_id][excavator_id]
                        print("dump_group")
                        print(dump_group)
                        local_walk_to_excavator_cost[dump_group_index][excavator_group_index] = \
                            walk_to_excavator_cost[dump.dump_uuid_to_index_dict[dump_id]][excavator.excavator_uuid_to_index_dict[excavator_id]]

                        local_walk_to_dump_cost[dump_group_index][excavator_group_index] = \
                            walk_to_dump_cost[dump.dump_uuid_to_index_dict[dump_id]][excavator.excavator_uuid_to_index_dict[excavator_id]]

                for park_index in range(park_num):
                    for excavator_id in excavator_group:
                        excavator_group_index = self.group_excavator_uuid_to_index_dict[group_id][excavator_id]
                        local_park_to_excavator_cost[park_index][excavator_group_index] = \
                            park_to_excavator_cost[park_index][excavator.excavator_uuid_to_index_dict[excavator_id]]

                self.group_walk_to_excavator_cost[group_id] = local_walk_to_excavator_cost
                self.group_walk_to_dump_cost[group_id] = local_walk_to_dump_cost
                self.group_park_to_excavator[group_id] = local_park_to_excavator_cost
        except Exception as es:
            logger.info(es)
            logger.info("error-11")

    def update_group_device_map(self):
        # 更新调度分组内设备映射
        self.group_excavator_uuid_to_index_dict = {}
        self.group_dump_uuid_to_index_dict = {}
        self.group_excavator_index_to_uuid_dict = {}
        self.group_dump_index_to_uuid_dict = {}

        for group_id in self.group_set:
            excavator_num = 0
            dump_num = 0

            dump_group = self.device_group[group_id][0]
            excavator_group = self.device_group[group_id][1]

            self.group_excavator_uuid_to_index_dict[group_id] = {}
            self.group_excavator_index_to_uuid_dict[group_id] = {}
            self.group_dump_uuid_to_index_dict[group_id] = {}
            self.group_dump_index_to_uuid_dict[group_id] = {}

            for excavator_id in excavator_group:
                if excavator_id not in self.group_excavator_uuid_to_index_dict:
                    self.group_excavator_index_to_uuid_dict[group_id][excavator_num] = excavator_id
                    self.group_excavator_uuid_to_index_dict[group_id][excavator_id] = excavator_num

                    excavator_num = excavator_num + 1

            for dump_id in dump_group:
                if dump_id not in self.group_dump_uuid_to_index_dict:
                    self.group_dump_index_to_uuid_dict[group_id][dump_num] = dump_id
                    self.group_dump_uuid_to_index_dict[group_id][dump_id] = dump_num

                    dump_num = dump_num + 1

        logger.info("group_map")
        logger.info(self.group_dump_uuid_to_index_dict)
        logger.info(self.group_excavator_uuid_to_index_dict)

    def update_modify(self):
        try:

            dynamic_truck_set = get_value("dynamic_truck_set")

            print("update_modify")
            print(dynamic_truck_set)

            print("self.dispatch_truck_group")
            print(self.dispatch_truck_group)

            self.group_excavator_exclude_modify = {}
            self.group_excavator_material_bind_modify = {}
            self.group_dump_material_bind_modify = {}
            for truck_id in dynamic_truck_set:
                group_id = self.dispatch_truck_group[truck_id]
                group_dump_num = len(self.device_group[group_id][0])
                group_excavator_num = len(self.device_group[group_id][1])
                excavator_exclude_modify = np.zeros(group_excavator_num)
                excavator_material_bind_modify = np.zeros(group_excavator_num)
                dump_material_bind_modify = np.zeros(group_dump_num)

                truck_index = truck.truck_uuid_to_index_dict[truck_id]

                for group_excavator_index in range(group_excavator_num):
                    excavator_index = excavator.excavator_uuid_to_index_dict[self.group_excavator_index_to_uuid_dict[group_id][group_excavator_index]]
                    excavator_exclude_modify[group_excavator_index] = truck.excavator_exclude_modify[truck_index][excavator_index]

                for group_excavator_index in range(group_excavator_num):
                    excavator_index = excavator.excavator_uuid_to_index_dict[
                        self.group_excavator_index_to_uuid_dict[group_id][group_excavator_index]]
                    excavator_material_bind_modify[group_excavator_index] = truck.excavator_material_bind_modify[truck_index][excavator_index]

                for group_dump_index in range(group_dump_num):
                    dump_index = dump.dump_uuid_to_index_dict[self.group_dump_index_to_uuid_dict[group_id][group_dump_index]]
                    print(truck.dump_material_bind_modify, truck_index, dump_index)
                    print(truck.dump_material_bind_modify[truck_index][dump_index], truck_index, dump_index)
                    dump_material_bind_modify[group_dump_index] = truck.dump_material_bind_modify[truck_index][dump_index]

                self.group_excavator_exclude_modify[truck_id] = excavator_exclude_modify
                self.group_excavator_material_bind_modify[truck_id] = excavator_material_bind_modify
                self.group_dump_material_bind_modify[truck_id] = dump_material_bind_modify
        except Exception as es:
            logger.error(es)
            logger.error("modify update 异常")

    def period_update(self):
        self.reset()
        self.update_dispatch_truck_group()
        self.update_group_set()
        self.update_device_group()
        self.update_group_device_map()
        self.update_group_walk_cost()
        self.update_group_truck_flow()
        self.update_modify()

    def get_diaptch_truck_group(self):
        return self.dispatch_truck_group

    def get_group_num(self):
        return self.group_num

    def get_group_set(self):
        return self.group_set

    def reset(self):
        self.dispatch_truck_group = {}
        self.group_num = 1
        self.group_set = set()
        self.device_group = {}
        self.group_walk_to_excavator_cost = {}
        self.group_walk_to_dump_cost = {}
        self.group_park_to_excavator = {}

        self.group_opt_goto_dump_traffic_flow = {}
        self.group_opt_goto_excavator_traffic_flow = {}
        self.group_actual_goto_dump_traffic_flow = {}
        self.group_actual_goto_excavator_traffic_flow = {}

        self.group_excavator_uuid_to_index_dict = {}
        self.group_dump_uuid_to_index_dict = {}
        self.group_excavator_index_to_uuid_dict = {}
        self.group_dump_index_to_uuid_dict = {}

        self.group_excavator_exclude_modify = {}
        self.group_excavator_material_bind_modify = {}
        self.group_dump_material_bind_modify = {}


# def para_process(dispatcher):
#
#     logger.info("papa_process!")
#
#     # 清空数据库缓存
#     session_mysql.commit()
#     session_mysql.flush()
#
#     # 清空数据库缓存
#     session_postgre.commit()
#     session_postgre.flush()
#
#     # 周期更新
#     dispatcher.para_period_update()
#
#
# def state_process(dispatcher):
#
#     print("state_process!")
#
#     logger.info("state_process!")
#
#     # 清空数据库缓存
#     session_mysql.commit()
#     session_mysql.flush()
#
#     # 清空数据库缓存
#     session_postgre.commit()
#     session_postgre.flush()
#
#     # 周期更新
#     dispatcher.state_period_update()
#
#     # 参数重置
#     dispatcher.sim_para_reset()
#
#     # try:
#
#     # 调度计算
#     dispatcher.schedule_construct()
#
#     # except Exception as es:
#     #     logger.error("更新不及时")
#     #     logger.error(es)

# 下面三个函数保证程序定期执行，不用管他
def process(dispatcher):

    # try:
    # 更新周期参数
    logger.info("#####################################周期更新开始#####################################")

    period_para_update()
    if get_value("dynamic_dump_num") * get_value("dynamic_excavator_num") == 0:
        raise Exception("无动态派车计划可用")
        return
    if get_value("dynamic_truck_num") == 0:
        raise Exception("无动态派车可用矿卡")
        return
    # para_process(dispatcher)
    #
    # state_process(dispatcher)

    # 清空数据库缓存
    session_mysql.commit()
    session_mysql.flush()

    # 清空数据库缓存
    session_postgre.commit()
    session_postgre.flush()
    #
    # # 周期更新
    # dispatcher.para_period_update()

    # 周期更新
    dispatcher.dispatcher_period_update()

    # 参数重置
    dispatcher.sim_para_reset()

    # try:

    # 调度计算
    dispatcher.schedule_construct()

    # except Exception as es:
    #     logger.error("更新不及时")
    #     logger.error(es)

    logger.info("#####################################周期更新结束#####################################")

    # except Exception as es:
    #     logger.error(es)

period_para_update()
scheduler = sched.scheduler(time.time, time.sleep)
dispatcher = Dispatcher()


def perform(inc, dispatcher):
    scheduler.enter(inc, 0, perform, (inc, dispatcher))
    process(dispatcher)


def main(inc, dispatcher):
    scheduler.enter(0, 0, perform, (inc, dispatcher))
    scheduler.run()


if __name__ == "__main__":
    logger.info(" ")
    logger.info("调度系统启动")

    # dispatcher = Dispatcher()

    main(10, dispatcher)
