# -*- coding: utf-8 -*-
# @Time : 2022/5/30 14:45
# @Author : Opfer
# @Site :
# @File : dispatchInfo.py
# @Software: PyCharm

# 分组数据处理

from data.para_config import *
from bidict import bidict
from settings import get_logger

logger = get_logger("zxt.dispatchInfo")


class DispatchInfo:
    """
    class for dispatch group info.
    """
    # dispatch groups
    group_set = set()

    # device group structure
    load_excavator_dict = {}  # 装载区id-->>电铲编号的映射
    excavator_load_dict = {}  # 电铲编号->>装载区id的映射

    # group_excavators <-> group id
    group_excavator_dict = {}  # team_id -> dict {[excavator_id, excavator_id], ...}
    excavator_group_dict = {}  # excavator_id -> team_id   问题：多个key值对应一个value值

    # group_unload_areas <-> group id
    group_unload_area_dict = {}  # team_id -> dict {unload_area_id, unload_area_id, ...}
    unload_area_group_dict = {}  # unload_area_id -> team_id

    # group_dumps <-> group id
    group_dump_dict = {}
    dump_group_dict = {}

    # truck_id <-> team_id
    group_truck_dict = {}  # team_id -> dict # {group_id:[truck_id,truck_id],...}
    truck_group_dict = {}  # truck_id -> team_id

    # group mode
    group_mode = {}  # 数据格式： {team_id:mode_code}

    # route_distance（路网距离）
    load_distance = {}
    unload_distance = {}

    # group_name <-> group_id
    group_name = {}

    # truck -> match(excavator_id, unload_area_id)
    truck_match_dict = {}

    # group_unload_areas <-> group_dumps id
    dump_unload_area_dict = {}
    unload_area_dump_dict = {}

    # 获取电铲与卡车的双映射 -->> exactor_id <-> truck_id
    exactor_truck_dict = {}
    truck_exactor_dict = {}

    # 获取电铲与卸载区的双映射 -->> exactor_id <-> unload_area_id
    exactor_unload_dict = {}
    unload_exactor_dict = {}

    # 获取卸载区与rate之间的关系 -->> unload_area_id -> rate
    unload_rate_dict = {}

    # 各分组设备映射
    excavator_uuid_to_index_dict = {}
    dump_uuid_to_index_dict = {}
    load_area_uuid_to_index_dict = {}
    unload_area_uuid_to_index_dict = {}

    @classmethod
    def reset(cls):
        """
        @date：2022/6/2 19:50
        @author：maqc
        @desc：实例化对象，可直接访问
        """
        cls.group_set = set()

        cls.load_excavator_dict = {}
        cls.excavator_load_dict = {}

        cls.group_excavator_dict = {}
        cls.excavator_group_dict = {}

        cls.group_unload_area_dict = {}
        cls.unload_area_group_dict = {}

        cls.group_dump_dict = {}
        cls.dump_group_dict = {}

        cls.group_truck_dict = {}
        cls.truck_group_dict = {}

        cls.group_mode = {}

        cls.load_distance = {}
        cls.unload_distance = {}

        cls.truck_match_dict = {}

        cls.dump_unload_area_dict = {}
        cls.unload_area_dump_dict = {}

        cls.exactor_truck_dict = {}
        cls.truck_exactor_dict = {}

        cls.exactor_unload_dict = {}
        cls.unload_exactor_dict = {}

        cls.unload_rate_dict = {}

        cls.excavator_uuid_to_index_dict = {}
        cls.dump_uuid_to_index_dict = {}
        cls.load_area_uuid_to_index_dict = {}
        cls.unload_area_uuid_to_index_dict = {}

    @classmethod
    def update_device_group_structure(cls):
        """
        @date：2022/6/2 19:49
        @author：maqc
        @desc：分组与卸载区、挖机、矿卡的映射和反映射
        """
        logger = get_logger("zxt.update_device_group_structure")
        # update excavator_id <-> load_area_id
        try:
            for item in session_mysql.query(DispatchSetting).filter_by(isdeleted=0, ).all():

                cls.load_excavator_dict[item.load_area_id] = item.exactor_id
                cls.excavator_load_dict[item.exactor_id] = item.load_area_id
            # aa = cls.load_excavator_dict
        except Exception as es:
            logger.error("挖机和装载区映射更新异常")
            logger.error(es)
            session_postgre.rollback()
            session_mysql.rollback()

        # update dump_id <-> unload_area_id
        try:
            for item in session_mysql.query(DispatchSetting).filter_by(isdeleted=0, ).all():

                cls.unload_area_dump_dict[item.unload_area_id] = item.dump_id
                cls.dump_unload_area_dict[item.dump_id] = item.unload_area_id
            # aa = cls.load_excavator_dict
        except Exception as es:
            logger.error("卸载设备和卸载区映射更新异常")
            logger.error(es)
            session_postgre.rollback()
            session_mysql.rollback()

        # update  exactor_id <-> truck_id
        try:
            for item in session_mysql.query(DispatchSetting).filter_by(isdeleted=0, ).all():
                if item.exactor_id not in cls.exactor_truck_dict.keys():
                    cls.exactor_truck_dict[item.exactor_id] = [item.truck_id]
                else:
                    if item.truck_id not in cls.exactor_truck_dict[item.exactor_id]:
                        cls.exactor_truck_dict[item.exactor_id].append(item.truck_id)
                cls.truck_exactor_dict[item.truck_id] = item.exactor_id
        except Exception as es:
            logger.error("电铲和卡车的映射关系更新异常")
            logger.error(es)

        # update   exactor_id <-> unload_area_id
        try:
            for item in session_mysql.query(DispatchSetting).filter_by(isdeleted=0, ).all():
                if item.exactor_id not in cls.exactor_unload_dict.keys():
                    cls.exactor_unload_dict[item.exactor_id] = [item.unload_area_id]
                else:
                    if item.unload_area_id not in cls.exactor_unload_dict[item.exactor_id]:
                        cls.exactor_unload_dict[item.exactor_id].append(item.unload_area_id)
        except Exception as es:
            logger.error("电铲和卸载区的映射关系更新异常")
            logger.error(es)

        # update  unload_area_id -> rate
        try:
            for item in session_mysql.query(DispatchSetting).filter_by(isdeleted=0, ).all():
                cls.unload_rate_dict[item.unload_area_id] = item.rate
        except Exception as es:
            logger.error("卸载区和比例值关系更新异常")
            logger.error(es)

        # update excavator_id <-> group_id && unload_area_id <-> group_id && truck_id <-> group_id
        try:
            for item in session_mysql.query(DispatchSetting).filter_by(isdeleted=0).all():
                # add group_excavators
                excavator_state = session_mysql.query(Equipment).filter_by(id=item.exactor_id).first()
                # if excavator_state is not None and excavator_state.disabled == 1:
                if item.group_id not in cls.group_excavator_dict.keys():
                    cls.group_excavator_dict[item.group_id] = [item.exactor_id]
                else:
                    if item.exactor_id not in cls.group_excavator_dict[item.group_id]:
                        cls.group_excavator_dict[item.group_id].append(item.exactor_id)
                cls.excavator_group_dict[item.exactor_id] = item.group_id

                # add group_unload_areas
                if item.group_id not in cls.group_unload_area_dict.keys():
                    cls.group_unload_area_dict[item.group_id] = [item.unload_area_id]
                else:
                    if item.unload_area_id not in cls.group_unload_area_dict[item.group_id]:
                        cls.group_unload_area_dict[item.group_id].append(item.unload_area_id)
                cls.unload_area_group_dict[item.unload_area_id] = item.group_id

                # add dump
                dump_state = session_mysql.query(Equipment).filter_by(id=item.dump_id).first()
                # if dump_state is not None and dump_state.disabled == 1:
                # add group_dumps
                if item.group_id not in cls.group_dump_dict.keys():
                    cls.group_dump_dict[item.group_id] = [item.dump_id]
                else:
                    if item.dump_id not in cls.group_dump_dict[item.group_id]:
                        cls.group_dump_dict[item.group_id].append(item.dump_id)
                cls.dump_group_dict[item.dump_id] = item.group_id

                # add truck
                truck_state = session_mysql.query(Equipment).filter_by(id=item.truck_id).first()
                # if truck_state is not None and truck_state.disabled == 1:
                if item.group_id not in cls.group_truck_dict.keys():
                    cls.group_truck_dict[item.group_id] = [item.truck_id]
                else:
                    if item.truck_id not in cls.group_truck_dict[item.group_id]:
                        cls.group_truck_dict[item.group_id].append(item.truck_id)
                cls.truck_group_dict[item.truck_id] = item.group_id

            logger.info("存在的分组")
            logger.info(cls.group_excavator_dict.keys())
        except Exception as es:
            logger.error("挖机/卸载区/矿卡与group_id映射更新异常")
            logger.error(es)
            session_postgre.rollback()
            session_mysql.rollback()

        # update group set
        try:
            cls.group_set = set(cls.group_excavator_dict.keys())
        except Exception as es:
            logger.error(es)

        # update truck_id <-> match_id(excavator_id, unload_area_id)
        try:
            trucks = cls.truck_group_dict.keys()
            for i in trucks:
                match_excavator = session_mysql.query(DispatchSetting).filter_by(truck_id=i, isdeleted=0, ).first().exactor_id
                match_unload_area = session_mysql.query(DispatchSetting).filter_by(truck_id=i, isdeleted=0, ).first().unload_area_id
                cls.truck_match_dict[i] = [match_excavator, match_unload_area]
        except Exception as es:
            logger.error(es)
            session_postgre.rollback()
            session_mysql.rollback()

    @classmethod
    def update_group_mode(cls):
        """
        @date：2022/6/2 19:49
        @author：maqc
        @desc：处理其它类型的数据
        """
        # update group_id->mode_code
        logger = get_logger("zxt.update_group_mode")
        cls.group_mode = {}
        try:
            for item in session_mysql.query(DispatchGroup).all():
                mode_id = item.mode_id
                mode_code = session_mysql.query(DispatchMode).filter_by(id=mode_id).first().mode_code
                # mode = session_mysql.query(DispatchMode).filter_by(group_code=).first()
                cls.group_mode[item.id] = mode_code
        except Exception as es:
            logger.error("group_id->mode_code更新异常")
            logger.error(es)
            session_postgre.rollback()
            session_mysql.rollback()

    @classmethod
    def update_group_name(cls):
        """
        @date：2022/6/13 20:30
        @author：zxtc
        @desc：处理 group name
        """
        # update group_id->mode_name
        logger = get_logger("zxt.update_group_name")
        cls.group_name = {}
        try:
            for item in session_mysql.query(DispatchGroup).all():
                name = item.group_name
                cls.group_name[item.id] = name
        except Exception as es:
            logger.error("group_id->name更新异常")
            logger.error(es)
            session_postgre.rollback()
            session_mysql.rollback()

        logger.info("group_name")
        logger.info(cls.group_name)

    @classmethod
    # 距离-->>数据格式：矩阵-->>to_load_distance
    def update_route_distance(cls):
        """
        @date：2022/6/2 19:50
        @author：maqc
        @desc：更新路网距离，返回矩阵格式数据
        """
        logger = get_logger("zxt.update_route_distance")

        cls.excavator_uuid_to_index_dict = {}
        cls.dump_uuid_to_index_dict = {}
        cls.load_area_uuid_to_index_dict = {}
        cls.unload_area_uuid_to_index_dict = {}

        try:
            groups = cls.group_excavator_dict.keys()
            for item in groups:
                try:

                    # 每个组的 excavator_id 及对应 load_area_id
                    excavator_ids = cls.group_excavator_dict[item]
                    load_areas = []
                    for excavator_id in excavator_ids:
                        load_areas.append(cls.excavator_load_dict[excavator_id])

                    # 每个组的unload_areas
                    unload_areas = cls.group_unload_area_dict[item]

                except Exception as es:
                    logger.error("装卸载区统计异常")
                    logger.error(es)

                group_excavator_uuid_to_index = {}
                group_dump_uuid_to_index = {}
                group_load_area_uuid_to_index = {}
                group_unload_area_uuid_to_index = {}

                try:
                    group_excavator_count = 0
                    group_dump_count = 0
                    group_load_area_count = 0
                    group_unload_area_count = 0

                    # unload->load distance
                    unload_load_distance = np.zeros((len(cls.group_dump_dict[item]), len(cls.group_excavator_dict[item])))
                    for excavator_id in cls.group_excavator_dict[item]:
                        group_dump_count = 0
                        group_unload_area_count = 0
                        for dump_id in cls.group_dump_dict[item]:
                            unload_area_id = cls.dump_unload_area_dict[dump_id]
                            load_area_id = cls.excavator_load_dict[excavator_id]
                            distance = session_postgre.query(WalkTime).filter_by(
                                unload_area_id=unload_area_id,
                                load_area_id=load_area_id).first()

                            if distance is not None:
                                unload_load_distance[group_dump_count][group_excavator_count] = float(distance.to_load_distance)
                            else:
                                logger.warning(f'装载区 {load_area_id} 与 卸载区 {unload_area_id} 间路网不通')
                                unload_load_distance[group_dump_count][group_excavator_count] = 1000000

                            if excavator_id not in group_excavator_uuid_to_index:
                                group_excavator_uuid_to_index[excavator_id] = group_excavator_count

                            if dump_id not in group_dump_uuid_to_index:
                                group_dump_uuid_to_index[dump_id] = group_dump_count

                            if load_area_id not in group_load_area_uuid_to_index:
                                group_load_area_uuid_to_index[load_area_id] = group_load_area_count

                            if unload_area_id not in group_unload_area_uuid_to_index:
                                group_unload_area_uuid_to_index[unload_area_id] = group_unload_area_count

                            group_dump_count += 1
                            group_unload_area_count += 1

                        group_excavator_count += 1
                        group_load_area_count += 1

                    group_excavator_uuid_to_index = bidict(group_excavator_uuid_to_index)
                    group_dump_uuid_to_index = bidict(group_dump_uuid_to_index)
                    group_load_area_uuid_to_index = bidict(group_load_area_uuid_to_index)
                    group_unload_area_uuid_to_index = bidict(group_unload_area_uuid_to_index)

                    cls.excavator_uuid_to_index_dict[item] = group_excavator_uuid_to_index
                    cls.dump_uuid_to_index_dict[item] = group_dump_uuid_to_index
                    cls.load_area_uuid_to_index_dict[item] = group_load_area_uuid_to_index
                    cls.unload_area_uuid_to_index_dict[item] = group_unload_area_uuid_to_index

                    cls.load_distance[item] = unload_load_distance

                except Exception as es:
                    logger.warning(f'{item} 分组装载路网异常')
                    cls.load_distance[item] = np.full((len(unload_areas), len(load_areas)), 10000)
                    logger.warning(es)
                    session_postgre.rollback()
                    session_mysql.rollback()

                try:

                    # load->unload distance
                    load_unload_distance = np.zeros((len(load_areas), len(unload_areas)))
                    for i in range(len(load_areas)):
                        for j in range(len(unload_areas)):
                            distance = session_postgre.query(WalkTime).filter_by(load_area_id=load_areas[i],
                                                                                 unload_area_id=unload_areas[j]).first()
                            if distance is not None:
                                load_unload_distance[i][j] = float(distance.to_unload_distance)
                    cls.unload_distance[item] = load_unload_distance

                except Exception as es:
                    logger.warning(f'{item} 分组卸载路网异常')
                    cls.unload_distance[item] = np.full((len(load_areas), len(unload_areas)), 10000)
                    logger.warning(es)
                    session_postgre.rollback()
                    session_mysql.rollback()

        except Exception as es:
            logger.error("路网距离更新异常-调度部分和路网部分不一致")
            logger.error(es)

    @classmethod
    def get_group_excavator_dict(cls, group_id):
        return cls.excavator_uuid_to_index_dict[group_id]

    @classmethod
    def get_group_dump_dict(cls, group_id):
        return cls.dump_uuid_to_index_dict[group_id]

    @classmethod
    def get_group_unload_area_dict(cls, group_id):
        return cls.unload_area_uuid_to_index_dict[group_id]

    @classmethod
    def get_all_groups_id(cls):
        return set(cls.group_excavator_dict.keys())

    @classmethod
    def get_group_mode(cls, group_id):
        if group_id in cls.group_mode:
            return cls.group_mode[group_id]
        else:
            return None

    @classmethod
    def get_excavator(cls, group_id):
        return set(cls.group_excavator_dict[group_id])

    @classmethod
    def get_unload_area(cls, group_id):
        return set(cls.group_unload_area_dict[group_id])

    @classmethod
    def get_dump(cls, group_id):
        return set(cls.group_dump_dict[group_id])

    @classmethod
    def get_truck_set(cls, group_id):
        return set(cls.group_truck_dict[group_id])

    @classmethod
    def get_load_area(cls, excavator_id):
        return cls.excavator_load_dict[excavator_id]

    @classmethod
    def get_to_excavator_distance(cls, group_id):
        return cls.load_distance[group_id]

    @classmethod
    def get_to_unload_area_distance(cls, group_id):
        return cls.unload_distance[group_id]

    @classmethod
    def get_truck_match(cls, truck_id):
        return cls.truck_match_dict[truck_id]

    @classmethod
    def get_park_to_excavator_distance(cls, group_id):
        excavators = cls.group_excavator_dict[group_id]
        park_area_set = get_value("park_uuid_to_index_dict").keys()
        park_matrix = np.ones((len(park_area_set), len(excavators)))
        try:
            for i in range(len(excavators)):
                load_area_id = cls.excavator_load_dict[excavators[i]]
                for park_idx in range(len(park_area_set)):
                    try:
                        distance = session_postgre.query(WalkTimePark).filter_by(load_area_id=load_area_id).first().park_load_distance
                        park_matrix[park_idx][i] = distance
                    except Exception as es:
                        logger.warning("查询不到距离，设置为100000000")
                        logger.warning(es)
                        park_matrix[park_idx][i] = 100000000   # 设置为一个很大的数字
        except Exception as es:
            logger.error("park->load距离更新异常, 存在备停区不可达的装载区")
            logger.error(es)
            session_postgre.rollback()
            session_mysql.rollback()
        return park_matrix

    @classmethod
    def get_park_set(cls):
        park_areas_set = set()
        for item in session_postgre.query(WalkTimePark).all():
            park_areas_set.add(item.park_area_id)
        return park_areas_set

    @classmethod
    def get_truck_exactor(cls, truck_id):
        return cls.truck_exactor_dict[truck_id]

    @classmethod
    def get_exactor_truck_nums(cls, exactor_id):
        return len(cls.exactor_truck_dict[exactor_id])

    @classmethod
    def get_exactor_unload_match(cls, exactor_id):
        return cls.exactor_unload_dict[exactor_id]



