#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2021/7/23 11:25
# @Author : Opfer
# @Site :
# @File : settings.py
# @Software: PyCharm


# 数据库设备, redis设置, 日志设置
from tables import *
from urllib.parse import quote
import logging.handlers
import numpy as np
import os
from redis import StrictRedis, ConnectionPool
import redis
from datetime import datetime, timedelta
import copy
import json

json_file = "config.json"

with open(json_file) as f:
    para_config = json.load(f)["para"]

with open(json_file) as f:
    redis_config = json.load(f)["redis"]

# 全局参数
########################################################################################################################
# 空载矿卡速度，单位（km/h）
empty_speed = para_config["empty_speed"]

# 重载矿卡速度，单位（km/h）
heavy_speed = para_config["heavy_speed"]

# 卸载设备目标卸载量
dump_target_mass = para_config["dump_target_mass"]

# 挖机目标装载量
excavator_target_mass = para_config["excavator_target_mass"]

logger = logging.getLogger("zxt")
logger.setLevel(logging.INFO)


def set_log():

    # 创建日志
    ########################################################################################################################
    # 日志存储地址
    log_path = para_config["log_path"]

    # 创建日志目录

    # if not os.path.exists(log_path):
    #     os.mkdir(log_path)
    # logging初始化工作
    logging.basicConfig()


    # timefilehandler = logging.handlers.TimedRotatingFileHandler(log_path + "/dispatch.log", when='M', interval=1, backupCount=60)
    # filehandler = logging.handlers.RotatingFileHandler(log_path + "/dispatch.log", maxBytes=30*1024*1024, backupCount=10, encoding="utf-8")
    filehandler = logging.handlers.RotatingFileHandler("./Logs/dispatch.log", maxBytes=3 * 1024 * 1024, backupCount=10, encoding="utf-8")
    # 设置后缀名称，跟strftime的格式一样
    filehandler.suffix = "%Y-%m-%d_%H-%M.log"

    formatter = logging.Formatter("%(asctime)s - %(name)s: %(levelname)s %(filename)s %(message)s")
    filehandler.setFormatter(formatter)
    logger.addHandler(filehandler)


def get_logger(module_name):
    logger = logging.getLogger(module_name)
    return logger


# 连接reids
########################################################################################################################
# redis 5 存储设备状态
pool5 = ConnectionPool(host=redis_config["host"], db=5, port=6379, password=redis_config["password"])

redis5 = StrictRedis(connection_pool=pool5)

# redis 2 存储派车计划
pool2 = ConnectionPool(host=redis_config["host"], db=2, port=6379, password=redis_config["password"])

redis2 = StrictRedis(connection_pool=pool2)


def str_to_byte(item):
    return bytes(item, encoding='utf8')

def byte_to_str(item):
    return str(item, encoding='utf-8')
