# 露天矿山卡车集成调度系统



# 1    引言

## **1.1**  **背景**

机群系统当前已具备基础调度功能，现有框架下，更改调度任务，需要先完成当前的任务后，新的调度任务才会生效；再者，当前调度的时机是发生在卸载作业面（即完成采运排一个周期才进行调度变更）。本方案将新增装载作业面的调度。

机群系统当前已支持依据挖机饱和度策略的调度，挖机饱和度是由挖机能够承载的矿卡数量来量化，只是当前是固定的（通过配置文件指定），这与实际场景不符，每个挖机能够承载的矿卡数量是不同的，动态变化的。因此，需要构建动态的挖机饱和度，本方案采用“车流饱和度”的概念作为矿卡调度的依据。

## **1.2 **定义

1）理想车流

车流规划以产量最大、出动设备数量最少、运营成本最低等为目标，根据最佳路径，综合考虑电铲能力、卸点能力、矿用卡车数量、矿用卡车型号、各个运输环节的统计时间、优先级以及其他生产约束，通过线性规划，求取各装、卸点之间的卡车运量分配，称之为理想车流。

2）行程时间

行程时间分为空载行程时间、重载行程时间。

① 空载行程时间，包括矿卡空载驶往装载区用时，矿卡等待时间，矿卡装载时间。其中，矿卡等待时间计算方式如下：

假设在该矿卡前面已经安排了N辆矿卡，矿卡等待时间计算公式如下：

MAX{N辆矿卡作业时间（完成装载的时刻），矿卡空载驶到装载区的时刻}-矿卡空载驶到装载区的时刻）

 

② 重载行程时间，包括矿卡重载驶往卸载区用时，矿卡等待时间，矿卡卸载时间。其中，矿卡等待时间计算方式如下：

假设在该矿卡前面已经安排了N辆矿卡，矿卡等待时间计算公式如下：

MAX{N辆矿卡作业时间（完成卸载的时刻），矿卡重载驶到卸载区的时刻}-矿卡重载驶到卸载区的时刻）

 

3）车流饱和度

车流饱和度指各路线实际车流与理想车流之比，调度算法倾向于将矿卡与车流饱和度较低的设备配对**。**

 

4）一个派车计划（即配对关系）存在三种状态：

① 用户在派车计划管理界面新建的“派车计划”，这是“计划的等待生效的”配对（数据存储在sys_dispatch_setting表）；

② 矿卡启动后，申请到的“派车计划”，这是“生效的正在执行的”配对（数据存储在sys_equipment_pair表）；

③ 卡调服务周期执行的，提前计算出来的“派车计划”，这是为矿卡可能发生配对变更服务的，这是“缓存的下一次的”配对（数据存储在redis 库5中）。

 

5）缓存中矿卡的状态信息：

127.0.0.1:6379> select 2

对应缓存，如下所示：

 

![img](readme/clip_image004.jpg)

 

① 当前状态state：

0-待机 1 运输 2 装载入场请求 3 装载入场等待 4 装载入场 5 装载请求 6 装载 7 出场 8 卸载入场请求 9 卸载入场等待 10 卸载入场 11 卸载请求 12 卸载 13 卸载出场

② 当前任务currentTask：

-1：当前车辆空闲，没有正在执行的任务文件；

0：停车场至装载入场点

1：装载入场点至装载点

2：装载点至装载出场点

3：装载出场点至卸载入场点

4：卸载入场点至卸载点

5：卸载点至卸载出场点

6：卸载出场点至装载入场点

7：卸载出场点至停车场

8：装载入场点至停车场

9：装载点至停车场

A：当前位置至停车场

# 2    系统整体结构

基于矿区路网数据、派车计划提供的调度规划等，为运输设备生成调度决策。系统收到运输设备发出的调度请求后，向运输设备发出调度指令，指导其完成运输作业。系统周期性分析矿山实时状态及设备运行状态，动态调整调度策略，如下图所示。



 

![img](readme/clip_image006.gif)**图** **1****调度服务交互图**



# 3    程序设计

## **3.1** **调度功能设计**

### 3.1.1 功能描述

| 功能编号            | SERVICE-FUNCTION-Dispatch                                    | 功能名称 | 处理位置点请求 |
| ------------------- | ------------------------------------------------------------ | -------- | -------------- |
| 需求编号            | SERVICE-REQUIREMENT-Dispatch                                 |          |                |
| 调用方式            | 机群系统调用                                                 | 权限说明 | 无             |
| 模块功能描述        | 该模块主要为运输设备（有人卡车与无人卡车）生成调度决策服务。通过分析矿山实时状态及设备运行状态，周期计算运输设备最佳派车计划。如果最佳派车计划与当前不一致，该模块更新运输设备所绑定的派车计划，否则保持不变。 |          |                |
| 内部依赖            | 无                                                           |          |                |
| 外部依赖            | 缓存（Redis）                                                |          |                |
| 所属组件包          | fleet-service                                                |          |                |
| 功能点              |                                                              |          |                |
| 名称                | 功能描述                                                     |          |                |
| 1、实时数据处理     | 读取数据库  (mysql+mysqlconnector://root:password@192.168.28.111:3306/waytous')，更新参数：挖机/卸载设备饱和度、装载/卸载平均时间、矿卡当前派车计划。  读取矿卡状态缓存(redis://password@192.168.28.111:6379/2)，更新参数：矿卡当前任务、挖机/卸载设备可用时间、矿卡可用时间。 |          |                |
| 2、生成最新派车计划 | 基于实时设备信息，结合车流规划及拥堵度计算结果，为在线矿卡计算最佳派车计划。  派车计划计算成功，将新的计划写入矿卡派车计划缓存(redis://password@192.168.28.111:6379/5)，供机群端读取。 |          |                |
| 3、车流规划         | 综合考虑电铲能力、卸点能力、矿用卡车数量、矿用卡车型号、各个运输环节的统计时间、优先级以及其他生产约束，通过线性规划，求取各装、卸点之间的卡车运量分配，并将车流规划结果反馈给实时调度部分。 |          |                |
| 4、  路径规划       | 根据矿山中每段道路的长度以及道路的实时拥堵信息，计算每段道路的代价因子![img](readme/clip_image008.gif)。 并将路网各设备间道路拥堵度信息反馈给实时调度部分。 |          |                |
| 5、反馈错误原因     | 调度策略计算失败，将错误信息返回给前端。                     |          |                |

### 3.1.2 处理流程

![img](readme/clip_image010.gif)

![img](readme/clip_image012.gif)

 

#### 周期卡调逻辑

1、检测待调度矿卡

2、若矿卡为固定派车模式，直接将对应派车计划写入调度缓存。获取剩余用于动态派车的矿卡及派车计划

3、按照矿卡预计抵达目的地时间顺序确定调度优先级（理论上先抵达目的地的矿卡先发出调度请求，应优先调度；未启动矿卡的调度优先级低于已启动；未启动矿卡间的分配顺序随机）

4、判断矿卡是否为启动调度；若矿卡为启动调度，计算从停车场到各装载区的“车流饱和度”；若为正常调度，计算矿卡执行各动态派车计划的“车流饱和度”

5、取行车流饱和对最小派车计划写入对应矿卡调度缓存，作为一下次调度的派车计划

6、周期性（如1分钟）全局参数重新计算

#### 调度规则

1、 矿卡优先级

当预计多辆矿卡在同一时间窗内请求调度，系统将为优先级高的矿卡优先计算调度策略。若不同矿卡请求调度时间差别较大，系统将仍然为预计先请求调度矿卡计算调度策略。

2、 卸点锁定矿卡（排斥锁定）

矿卡装载结束后请求调度，系统在为矿卡分配调度计划前，将判断目的地中是否存在锁定该矿卡的卸载点，若存在，将优先将该矿卡派往该锁定卸载点。

若开启排斥锁定，则卸载点不接受锁定矿卡外的其他矿卡调度请求。

3、 挖机锁定矿卡（排斥锁定）

矿卡卸载结束后请求调度，系统在为矿卡分配调度计划前，将判断目的地中是否存在锁定该矿卡的挖机，若存在，将优先将该矿卡派往该锁定挖机。

若开启排斥锁定，则该挖机不接受锁定矿卡外的其他矿卡调度请求。

4、 矿卡禁止锁定

矿卡禁止后，系统将不再维护该矿卡的动态调度。

5、 物料优先级

物料一般指废石和矿石，该规则启动后，矿石优先级高于废石优先级。与矿石关联的运输路线被赋予更高的调度价值。

6、 物料类型控制

同种物料只能在开采该物料的挖机处装载，同样只能在卸载该类型物料的卸点处卸载。对于路网中关联两个不同类型物料的挖机及卸载点的运输路线，系统将给予极大的惩罚项。

与卸载点锁定的矿卡始终只能运输该卸载点关联物料，类似，与挖机锁定的矿卡只能运输该挖机关联物料。

7、 矿卡型号

本系统中，不同型号矿卡的载重与速度为主要影响因素。

车流规划部分，道路因子计算采用矿卡平均载重。车流规划结果为单位时间内各路线运输吨位，兼容各型号矿卡。

实时调度部分，各型号矿卡速度影响矿卡行驶时间，出入场时间差异忽略不计。

### 3.1.3 接口设计

| **接口类型** | **描述**                                                     |
| ------------ | ------------------------------------------------------------ |
| Redis接口    | 机群服务中心通过读取矿卡最新派车计划缓存redis(redis://password@192.168.28.111:6379/5)间接与集成调度服务进行通信 |

### 3.1.4 组件核心类图

![img](readme/clip_image014.jpg)

