#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2022/10/8 11:33
# @Author : Opfer
# @Site :
# @File : core_exception.py    
# @Software: PyCharm

import traceback

code_msg = {101: "调度失败",
            102: "车辆不存在或信息缺失",
            103: "数组越界异常",
            104: "数组维度不一致",
            105: "数组越界",
            106: "挖机不存在或信息缺失"}


class CoreException(Exception):
    """ class for my exception."""

    def __init__(self, Code: int = None, ErrorInfo: str = None):
        super().__init__(self, ErrorInfo)
        self.__error_info = ErrorInfo
        self.code = Code
        self.__traceback = ""

    def __str__(self) -> str:
        return '{0:}-{1:} \n{2:}'.format(code_msg[self.code], self.__error_info, self.__traceback)

    # def with_traceback(self, tb) -> BaseException:
    #     self.__traceback = tb
    #     return self

    def with_traceback_info(self):
        self.__traceback = traceback.format_exc()


# try:
#     raise CoreException(101, "CoreException")
# except CoreException as ce:
#     ce.with_traceback_info()
#     # print(traceback.format_exc())
#     print(ce)
