#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2022/6/1 16:35
# @Author : Opfer
# @Site :
# @File : dispatcher.py    
# @Software: PyCharm

from data.dispatchInfo import DispatchInfo
from core.group import Group
from alg.algorithm import ExpectedTime
from settings import get_logger, redis5
from tables import DispatchSetting
from data.para_config import get_value
from equipment import TruckInfo, ExcavatorInfo, DumpInfo
from core.schedule import PreSchedule
import json
import uuid
from tables import session_mysql, session_postgre
from graph.graph_load import graph_construct
from core.util import POST
from graph.topo_graph import Topo
from core.group import CurrentTruck
from typing import List


class Dispatcher:
    """
    class for group dispatch program.
    """
    def __init__(self, truck: TruckInfo, dump: DumpInfo, excavator: ExcavatorInfo, pre_sch: PreSchedule, request_mode=False):
        self.group_list = {}
        self.truck = truck
        self.dump = dump
        self.excavator = excavator
        self.pre_sch = pre_sch
        self.request_mode = request_mode
        self.topo = graph_construct()
        self.submission = DispatchSubmission(dump, excavator, truck, self.topo)
        self.logger = get_logger("zxt.dispatcher")

    def period_update(self):
        """
        Update equipment information.
        :return: None
        """

        self.dump.dump_para_period_update()
        self.excavator.excavator_para_period_update()
        self.truck.truck_para_period_update(self.dump, self.excavator)
        self.truck.state_period_update()
        self.topo = graph_construct()

    def group_generate(self):
        """
        Generate and initialize dispatch groups.
        :return: None
        """
        self.group_list = {}
        groups_id = DispatchInfo.get_all_groups_id()
        for group_id in groups_id:
            if group_id not in self.group_list:
                group = Group(group_id, self.truck, self.pre_sch, self.excavator, self.dump, self.topo)
                group.info_update()
                self.group_list[group_id] = group

    def group_info_update(self):
        """
        Update group information.
        :return: None
        """
        for group in self.group_list.values():
            group.info_update()

    def group_dispatch(self):
        """
        Group dispatching logic.
        :return:
        """
        for group in self.group_list.values():

            # try:

            truck_dispatch_plan_dict = group.group_dispatch(ExpectedTime)

            if truck_dispatch_plan_dict is None:
                self.logger.error(f'分组 {group.group_id} 调度异常')
                continue

            # except Exception as es:
            #     self.logger.error(es)
            #     self.logger.error(f'分组{group.group_id} 调度异常')

            # 派车计划输出
            self.submission.group_dispatch_to_redis(group, truck_dispatch_plan_dict)


def redis_format(truck_id, group_id, dispatch_id, item):
    record = {"truckId": truck_id, "dispatchId": dispatch_id, "exactorId": item.exactor_id, "dumpId": item.dump_id,
              "loadAreaId": item.load_area_id, "unloadAreaId": item.unload_area_id, "groupId": item.group_id,
              "isdeleted": False, "isTemp": False, "haulFlag": -1, "groupName": DispatchInfo.group_name[group_id]}
    return record


class DispatchSubmission:
    """ class for the submission calculated dispatch.

    Description:
        将调度结果按照指定格式传递到云端机群
    Attribute:

    """
    def __init__(self, dump: DumpInfo, excavator: ExcavatorInfo, truck: TruckInfo, topo: Topo):
        self.logger = get_logger("zxt.submission")
        self.dump = dump
        self.excavator = excavator
        self.truck = truck
        self.topo = topo

    def truck_dispatch_to_redis(self, truck_id: str, truck_info: CurrentTruck, dispatch_seq: List[int], group_mode: int):
        """
        将truck_id对应矿卡派车计划写入redis
        :param group_mode: (int)
        :param truck_id: (uuid) 矿卡uuid
        :param truck_info: (object)
        :param dispatch_seq: (List[int]) 矿卡派车计划
        :return: None
        """

        self.logger.info(f'调度车辆编号 {get_value("truck_uuid_to_name_dict")[truck_id]} {truck_id}')
        self.logger.info(f'车辆任务 {truck_info.get_task()}')
        self.logger.info(f'配对挖机 {dispatch_seq[0]}')
        self.logger.info(f'配对卸点 {dispatch_seq[1]}')

        # try:

        if truck_id not in DispatchInfo.truck_group_dict:
            group_id = None
            self.logger.error(f'调度结果写入异常-读取矿卡 {truck_id} 所在分组信息异常')
        else:
            group_id = DispatchInfo.truck_group_dict[truck_id]

        record = {"truckId": truck_id}

        # if group_id is None or DispatchInfo.get_group_mode(group_id) is None:
        #     group_mode = 3
        #     self.logger.error("调度模式读取异常-设置为固定派车模式")
        # else:
        #     group_mode = DispatchInfo.get_group_mode(group_id)

        self.logger.info(f'调度模式 {group_mode}')

        if group_mode == 3:
            self.logger.info("固定派车模式")
            self.fixed_dispatch_mode(group_id, truck_id)
        else:
            self.logger.info("动态调度模式")
            self.dynamic_dispatch_mode(dispatch_seq, group_id, record, truck_info.get_sate(),
                                       truck_info.get_task(), truck_id)

        # except Exception as es:
        #     self.logger.error("调度结果写入异常")
        #     self.logger.error(f"调度结果:{dispatch_seq}")
        #     self.logger.error(es)

    def dynamic_dispatch_mode(self, dispatch_seq, group_id, record, state, task, truck_id):
        """
        write dispatch plan in dynamic dispatch mode.
        :param dispatch_seq:
        :param group_id:
        :param record:
        :param state:
        :param task:
        :param truck_id:
        :return:
        """
        if (task in [1, 2]) or (task == 3 and state == 2):  # 车辆位于卸载区，或车辆重载等待

            self.logger.info(f'卸载区内或重载等待，请求装载区 {truck_id}')

            # 查询车辆相关派车计划 dispatch_seq[next_excavator_id, next_unload_area_id]
            if dispatch_seq[1] is None or [dispatch_seq[1]] not in DispatchInfo.unload_area_dump_dict:
                # 无法查询到目标卸载点
                item = (session_mysql.query(DispatchSetting).filter_by(group_id=group_id, isdeleted=0, ).first())
            else:
                dump_id = DispatchInfo.unload_area_dump_dict[dispatch_seq[1]]
                try:
                    item = (session_mysql.query(DispatchSetting).filter_by(dump_id=dump_id, group_id=group_id,
                                                                           isdeleted=0, ).first())
                    if item is None:
                        raise Exception(f'{truck_id} 无法找到派车计划 {dump_id} {group_id}')
                    if dispatch_seq[0] is None:
                        raise Exception("调度计划挖机与实时监控不匹配")
                except Exception as es:
                    item = (session_mysql.query(DispatchSetting).filter_by(group_id=group_id, isdeleted=0, ).first())
                    self.logger.error(es)

            # 其余调度信息写入
            try:

                redis_format(truck_id, group_id, str(uuid.uuid1()), item)
                # # record["dispatchId"] = item.id
                # record["dispatchId"] = str(uuid.uuid1())
                # record["exactorId"] = item.exactor_id
                # record["loadAreaId"] = item.load_area_id
                # record["dumpId"] = item.dump_id
                # record["unloadAreaId"] = item.unload_area_id
                # record["groupId"] = group_id
                # record["isdeleted"] = False
                # # record["isTemp"] = False
                # record["haulFlag"] = -1
                # record["groupName"] = DispatchInfo.group_name[group_id]

                if task == 3 and state == 2 and self.truck.get_truck_locate_dict()[truck_id] in self.topo.cross_bf_lanes:
                    # try:
                    # if truck_id in self.truck.truck_is_temp and not self.truck.truck_is_temp[truck_id]:
                    self.logger.info("二次调度前往卸载区")
                    record["isTemp"] = True
                    redis5.set(truck_id, str(json.dumps(record)))
                    POST(truck_id)
                    self.logger.info(f'redis 注入 {record}')
                    # else:
                    #     self.logger.info("车辆已完成二次调度-无需更改派车计划")

                    # except Exception as es:
                    #     self.logger.error(es)
                    #     self.logger.error("二次调度失败")
                    #     record["isTemp"] = False
                    #     redis5.set(truck_id, str(json.dumps(record)))
                else:
                    self.logger.info("调度前往卸载区")
                    record["isTemp"] = False
                    redis5.set(truck_id, str(json.dumps(record)))
                    self.logger.info(f'redis 注入 {record}')

            # redis5.set(truck_id, str(json.dumps(record)))
            except Exception as es:
                self.logger.error("调度结果写入异常-矿卡空载")
                self.logger.error(es)
                redis5.set(truck_id, str(json.dumps(record)))

            #     redis5.set(truck_id, str(json.dumps(record)))
            # finally:
                # redis5.set(truck_id, str(json.dumps(record)))

        elif (task in [4, 5]) or (task == 0 and state == 2):  # 卡车重载或在卸载区出场前, 可变更装载目的地

            self.logger.info(f'调度2 {truck_id}')
            # 查询车辆相关派车计划
            try:
                item = (session_mysql.query(DispatchSetting).filter_by(exactor_id=dispatch_seq[0], group_id=group_id,
                                                                       isdeleted=0, ).first())
                if item is None:
                    raise Exception("调度计划配置异常")
                if dispatch_seq[0] is None:
                    raise Exception("调度计划表与实时监控不匹配")
            except Exception as es:
                item = (session_mysql.query(DispatchSetting).filter_by(group_id=group_id, isdeleted=0, ).first())
                self.logger.error(es)

            # 调度信息写入
            try:
                # record["dispatchId"] = item.id
                record["dispatchId"] = str(uuid.uuid1())
                record["exactorId"] = item.exactor_id
                record["loadAreaId"] = item.load_area_id
                record["dumpId"] = item.dump_id
                record["unloadAreaId"] = item.unload_area_id
                record["groupId"] = group_id
                record["isdeleted"] = False
                # record["isTemp"] = False
                record["haulFlag"] = -1
                record["groupName"] = DispatchInfo.group_name[group_id]

                if task == 0 and state == 2 and self.truck.get_truck_locate_dict()[truck_id] in self.topo.cross_bf_lanes:
                    # 车辆停车等待
                    # try:
                    # if truck_id in self.truck.truck_is_temp and not self.truck.truck_is_temp[truck_id]:
                    self.logger.info("二次调度前往装载区")
                    record["isTemp"] = True
                    # 若尚未二次调度
                    redis5.set(truck_id, str(json.dumps(record)))
                    POST(truck_id)
                    self.logger.info(f'redis 注入 {record}')
                    # else:
                    #     self.logger.info("车辆已完成二次调度-无需更改派车计划")
                    # except Exception as es:
                    #     self.logger.error(es)
                    #     self.logger.error("二次调度失败")
                    #     record["isTemp"] = False
                    #     redis5.set(truck_id, str(json.dumps(record)))

                else:
                    self.logger.info("调度前往装载区")
                    record["isTemp"] = False
                    redis5.set(truck_id, str(json.dumps(record)))
                    self.logger.info(f'redis 注入 {record}')

            # redis5.set(truck_id, str(json.dumps(record)))
            except Exception as es:
                self.logger.error("调度结果写入异常-矿卡重载")
                redis5.set(truck_id, str(json.dumps(record)))
            # finally:
            #     redis5.set(truck_id, str(json.dumps(record)))

        elif task == -2:
            self.logger.info(f'调度3 {truck_id}')
            try:

                # 查询车辆相关派车计划
                try:
                    item = (session_mysql.query(DispatchSetting).filter_by(exactor_id=dispatch_seq[0],
                                                                           group_id=group_id, isdeleted=0).first())
                    if item is None:
                        raise Exception("调度计划配置异常")
                    if dispatch_seq[0] is None:
                        raise Exception("调度计划表与实时监控不匹配")
                except Exception as es:
                    item = (session_mysql.query(DispatchSetting).filter_by(group_id=group_id,
                                                                           isdeleted=0, ).first())
                    self.logger.error(es)

                # 调度信息写入

                # try:

                self.logger.info(f'redis 注入 {record}')
                record = redis_format(truck_id, group_id, str(uuid.uuid1()), item)

                redis5.set(truck_id, str(json.dumps(record)))

                # except Exception as es:
                #     self.logger.error("调度结果写入异常-矿卡故障或备停区-redis写入异常")
                #     self.logger.error(es)
                # finally:
                #     redis5.set(truck_id, str(json.dumps(record)))

            except Exception as es:
                self.logger.error("调度结果写入异常-矿卡故障或备停区")
                self.logger.error(es)
        else:
            pass

    def fixed_dispatch_mode(self, group_id, truck_id):
        """
        write dispatch plan in fixed dispatch method.
        :param group_id:
        :param record:
        :param truck_id:
        :return:
        """
        try:
            item = session_mysql.query(DispatchSetting).filter_by(truck_id=truck_id, isdeleted=0, ).first()
        except Exception as es:
            item = None
            self.logger.error(es)
            session_postgre.rollback()
            session_mysql.rollback()

        if item is None:
            self.logger.error(f'车辆 {truck_id} 无派车计划-无法执行固定派车')
            return
        record = redis_format(truck_id, group_id, item.id, item)
        redis5.set(truck_id, str(json.dumps(record)))

        self.logger.info(f'redis 注入 {record}')

    def group_dispatch_to_redis(self, group: Group, dispatch_plan_dict):
        """
        Update the dispatch plan in the group to redis
        :param group: (Group)
        :param dispatch_plan_dict: (Dict)
        :return: None
        """

        self.logger.info(f'调度分组: {group.group_id} {DispatchInfo.group_name[group.group_id]}')
        self.logger.info(f'组内车辆 {group.truck_set}')
        self.logger.info(f'组内挖机 {group.excavator}')
        self.logger.info(f'组内卸点 {group.dump}')
        self.logger.info(f'调度模式 {group.group_mode}')
        self.logger.info("dispatch_plan_dict")
        self.logger.info(dispatch_plan_dict)

        for truck_id, dispatch_plan in dispatch_plan_dict.items():
            try:
                self.logger.info(f'======================================= 调度车辆 =======================================')
                self.truck_dispatch_to_redis(truck_id, group.truck_info_list[truck_id], dispatch_plan, group.group_mode)
                self.logger.info("======================================== 完成写入 =======================================")
            except Exception as es:
                self.logger.error("group_dispatch_to_redis_error")
                self.logger.error(es)
