#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2022/5/30 15:35
# @Author : Opfer
# @Site :
# @File : group.py    
# @Software: PyCharm


#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2022/5/30 15:35
# @Author : Opfer
# @Site :
# @File : group.py
# @Software: PyCharm

from data.dispatchInfo import DispatchInfo
from bidict import bidict
from alg.algorithm import AlgorithmBase
import numpy as np


class Group:
    """
    class for group instance.
    """
    def __init__(self, group_id, truck, pre_sch):
        """ Generate a group obj.
        :param group_id: (uuid) group_id
        """
        self.to_dump_congestion = None
        self.group_id = group_id
        self.group_mode = 1
        self.truck = truck
        self.pre_sch = pre_sch

        # group devices
        self.excavator = {}    # excavator_id -> unload_area_id
        self.dump = {}    # dump_id -> load_area_id
        self.truck_set = set()    # truck_id

        # road network info.
        self.to_excavator_distance = None
        self.to_dump_distance = None
        self.park_to_excavator_distance = None

        # self.to_excavator_congestion = None
        # self.to_dump_congestion = None
        # self.park_to_excavator_congestion = None

        # device map
        self.truck_uuid_index_dict = bidict()
        self.excavator_uuid_index_dict = bidict()
        self.dump_uuid_index_dict = bidict()


    def update_group_mode(self):
        """
        update group mode.
        :param group_mode:
        :return:
        """
        # DispatchInfo.update_group_mode()
        self.group_mode = DispatchInfo.get_group_mode(self.group_id)

    def update_group_device(self):
        """
        update group devices.
        :return:
        """
        # update group devices
        # DispatchInfo.update_device_group_structure()
        self.excavator = DispatchInfo.get_excavator(self.group_id)
        self.dump = DispatchInfo.get_dump(self.group_id)
        self.truck_set = DispatchInfo.get_truck_set(self.group_id)

    def update_group_road_network(self):
        """
        update group road network.
        :return:
        """
        # update group road network
        # DispatchInfo.update_route_distance()
        self.to_excavator_distance = DispatchInfo.get_to_excavator_distance(self.group_id)
        self.to_dump_distance = DispatchInfo.get_to_dump_distance(self.group_id)
        self.park_to_excavator_distance = DispatchInfo.get_park_to_excavator_distance(self.group_id)

    def update_group_device_map(self):
        """
        update group device map.
        :return:
        """
        # update device map
        # excavator_index = 0
        for i in range(len(self.excavator)):
            self.excavator_uuid_index_dict[self.excavator[i]] = i

        for i in range(len(self.dump)):
            self.dump_uuid_index_dict[self.dump[i]] = i

        for i in range(len(self.truck_set)):
            self.truck_uuid_index_dict[list(self.truck_set)[i]] = i

        self.truck_uuid_index_dict = bidict(self.truck_uuid_index_dict)
        self.excavator_uuid_index_dict = bidict(self.excavator_uuid_index_dict)
        self.dump_uuid_index_dict = bidict(self.dump_uuid_index_dict)

        # group_excavator_dict = {group_1: {excavator_1: load_area_1}, group_2: {excavator_2: load_area_2}}

    def info_update(self):
        """
        update group info.
        :return:
        """
        self.update_group_mode()
        self.update_group_device()
        self.update_group_device_map()
        self.update_group_road_network()

    def group_dispatch(self, solver: object):
        """
        Receive a alg obj. and output dispatch plan for trucks in this group.
        :param solver:
        :return:
            dispatch plan: Dict({truck_id: match_id})
        """
        truck_dispatch = {}

        assert issubclass(solver, AlgorithmBase)
        s = solver(self, self.truck, self.pre_sch)  # algorithm init

        tt = self.truck_set
        for i in list(self.truck_set):
            truck_trip = self.truck.get_truck_current_trip()[self.truck_uuid_index_dict[i]]
            truck_task = self.truck.get_truck_current_task()[i]
            if truck_task in [-2, 3, 4]:
                next_excavator_value = s.solve(i)
                # min_index = next_excavator_list.index(min(next_excavator_list))
                min_index = np.argmin(next_excavator_value)
                bb = self.excavator_uuid_index_dict
                next_excavator_id = self.excavator_uuid_index_dict.inverse[min_index]
                if truck_task == -2:
                    next_dump_id = "Park"
                else:
                    next_dump_id = self.dump_uuid_index_dict.inverse[truck_trip[-1]]
                truck_dispatch[i] = [next_excavator_id, next_dump_id]

            if truck_task in [0, 1]:
                next_dump_value = s.solve(i)
                min_index = np.argmin(next_dump_value)
                next_dump_id = self.dump_uuid_index_dict.inverse[min_index]
                next_excavator_id = self.excavator_uuid_index_dict.inverse[truck_trip[-1]]
                truck_dispatch[i] = [next_excavator_id, next_dump_id]

        # return dispatch plan
        return truck_dispatch




# from data.dispatchInfo import DispatchInfo
# from bidict import bidict
# from alg.algorithm import AlgorithmBase
#
#
# class Group_0:
#     """
#     class for group instance.
#     """
#     def __init__(self, group_id):
#         """ Generate a group obj.
#         :param group_id: (uuid) group_id
#         """
#
#         self.group_id = group_id
#
#         # group devices
#         self.excavator_dict = {}    # excavator_id -> unload_area_id
#         self.dump = {}    # dump_id -> load_area_id
#         self.truck_set = set()    # truck_id
#
#         # road network info.
#         self.to_excavator_distance = None
#         self.to_dump_distance = None
#         self.park_to_excavator_distance = None
#
#         self.to_excavator_congestion = None
#         self.to_dump_congestion = None
#         self.park_to_excavator_congestion = None
#
#         # device map
#         self.truck_uuid_index_dict = bidict()
#         self.excavator_uuid_index_dict = bidict()
#         self.dump_uuid_index_dict = bidict()
#
#     def update_xx_(self):
#         """
#         update above parameters.
#         :return:
#         """
#         pass
#
#     def group_dispatch(self, solver):
#         """
#         Receive a alg obj. and output dispatch plan for trucks in this group.
#         :param solver:
#         :return:
#             dispatch plan: Dict({truck_id: match_id})
#         """
#         assert isinstance(solver, AlgorithmBase)
#         s = solver(self)    # algorithm init
#         return s.solve()    # algorithm solve
