#!E:\Pycharm Projects\Waytous
# -*- coding: utf-8 -*-
# @Time : 2022/6/1 16:35
# @Author : Opfer
# @Site :
# @File : dispatcher.py    
# @Software: PyCharm
from core.submit import DispatchSubmission
from data.dispatchInfo import DispatchInfo
from core.group import Group
from alg.algorithm import ExpectedTime
from settings import get_logger
from equipment import TruckInfo, ExcavatorInfo, DumpInfo
from core.schedule import PreSchedule
from graph.graph_load import graph_construct
from core.group import GroupDispatcher
from graph.topo_graph import *


class Dispatcher:
    """
    class for group dispatch program.
    """
    def __init__(self, truck: TruckInfo, dump: DumpInfo, excavator: ExcavatorInfo, pre_sch: PreSchedule,
                 request_mode=False, active=False):
        self.group_list = {}
        self.truck = truck
        self.dump = dump
        self.excavator = excavator
        self.pre_sch = pre_sch
        self.request_mode = request_mode
        self.logger = get_logger("zxt.dispatcher")
        self.redispatch_active = active
        if self.redispatch_active:
            self.logger.info("======================================= 更新路网开始 =======================================")
            self.topo = Topo()
            self.topo.generate_topo_graph()
            self.logger.info("======================================= 更新路网结束 =======================================")
        else:
            self.topo = None
        self.submission = DispatchSubmission(dump, excavator, truck, self.topo)

    def period_update(self):
        """
        Update equipment information.
        :return: None
        """

        self.dump.dump_para_period_update()
        self.excavator.excavator_para_period_update()
        self.truck.truck_para_period_update(self.dump, self.excavator)
        self.truck.state_period_update()
        if self.redispatch_active:
            self.logger.info("======================================= 更新路网开始 =======================================")
            self.topo.generate_topo_graph()
            self.logger.info("======================================= 更新路网结束 =======================================")

    def group_generate(self):
        """
        Generate and initialize dispatch groups.
        :return: None
        """
        self.group_list = {}
        groups_id = DispatchInfo.get_all_groups_id()
        for group_id in groups_id:
            if group_id not in self.group_list:
                group = Group(group_id, self.truck, self.pre_sch, self.excavator, self.dump, self.topo)
                group.info_update()
                if len(group.group_trucks) != 0:
                    self.group_list[group_id] = group

    def group_info_update(self):
        """
        Update group information.
        :return: None
        """
        for group in self.group_list.values():
            group.info_update()

    def group_dispatch(self):
        """
        Group dispatching logic.
        :return:
        """
        for group in self.group_list.values():

            # try:

            # truck_dispatch_plan_dict = group.group_dispatch(ExpectedTime)

            group_dispatcher = GroupDispatcher(group)

            truck_dispatch_plan_dict = group_dispatcher.group_dispatch(ExpectedTime)

            if truck_dispatch_plan_dict is None:
                self.logger.error(f'分组 {group.group_id} 调度异常')
                continue

            # except Exception as es:
            #     self.logger.error(es)
            #     self.logger.error(f'分组{group.group_id} 调度异常')

            # 派车计划输出
            self.submission.group_dispatch_to_redis(group, truck_dispatch_plan_dict)


