/*
 * @Descripttion: 
 * @version: 
 * @Author: chengqingshui
 * @Date: 2023-04-13 14:37:39
 * @emal: qingshui.cheng@waytous.com
 * @LastEditors: wxin
 * @LastEditTime: 2023-11-23 08:53:21
 */

#ifndef VISION_3D_H
#define VISION_3D_H

#include<iostream>
#include <string>
#include <vector>
#include <time.h>
#include <algorithm>
#include <opencv2/opencv.hpp>
#include <Eigen/Dense>
#include <opencv2/core/eigen.hpp>
#include <pcl_conversions/pcl_conversions.h>
#include <pcl/point_cloud.h>
#include <pcl/point_types.h>
#include <pcl/filters/voxel_grid.h>
#include <pcl/common/transforms.h>
#include <pcl/filters/approximate_voxel_grid.h>

// #include "vision_transform/lshaped_fitting.h"
#include "vision_transform/ComFunction.h"
#include "common_maps.h"
#include "utils.h"


typedef pcl::PointCloud<pcl::PointXYZI> Cloud;
typedef Cloud::ConstPtr CloudConstPtr;

const int IMAGE_RESIZE_WIDTH  = 960;    //缩放图像宽
const int IMAGE_RESIZE_HEIGHT = 540;    //缩放图像高
const int DISPARTY_MAX  = 128;          //最大视差
const int DISPARTY_MAGNIFICATE = 256;   //视差放大倍数

const int BEV_SIZE_WIDTH  = 60;  //BEV 图像尺寸宽   
const int BEV_SIZE_HEIGHT = 85;  //BEV 图像尺寸高
const int BEV_CAR_LENGTH = 5;    //BEV 图像下车辆长度
const int CAMERA_PERCEPT_LENGTH = BEV_SIZE_HEIGHT-BEV_CAR_LENGTH;   //相机感知距离
const float BEV_GRID_RESOLUTION = 0.2f;   //bev grid 分辨率
const int DEPTH_TABEL_MAX_INDEX = (int)(CAMERA_PERCEPT_LENGTH/BEV_GRID_RESOLUTION);

const int BEV_IAGE_WIDTH = (int)(BEV_SIZE_WIDTH/BEV_GRID_RESOLUTION);
const int BEV_IAGE_HEIGHT = (int)(BEV_SIZE_HEIGHT/BEV_GRID_RESOLUTION);
 

struct BEV_COLOR 
{ 
    PCL_ADD_UNION_RGB
};


/**
 * 目标分割信息
*/
struct object_Seg_info
{
    object_Seg_info()
    {
        labelIdx = 0;
        color = cv::Scalar(255,0,255);
    }
    int labelIdx;       //目标类别索引
    std::string name;   //目标名称
    cv::Scalar color;   //标注颜色
    float fConfidence;  //分值
    
    int bDetectType;  // 0 instance  1 semantics
    cv::Rect rc;    //目标矩形框
    cv::Mat mask;   //目标二值掩码图  大小同矩形框
    uint8_t valid = 0;
};


//BEV实例目标信息
struct InstanceBevObject
{
    cv::Rect rc;           //图像目标矩形区域
    cv::RotatedRect rrc;   //BEV 外接矩形
    BEV_COLOR  color;      //颜色
    std::string names;     //目标类别名
    std::vector <cv::Point > vPoints;  //BEV图像目标mask点集合
    float fConfidence;  //分值
    bool fromDepth = false;
};



class BEV_GridMap
{
public:
    BEV_GridMap();

    void initVisualInfo();

    static cv::Point convert3d_2_map(float fx, float fy);

    static cv::Point2f convertmap_2_3d(int x, int y);

    /**
     * @name: drawInsMasks
     * @msg: bev实例图像上 画实例目标mask
     * @return {*}
     */
    void drawInsMasks();

    /**
     * @name: drawInsRects
     * @msg: bev实例图像上 画实例目标矩形框
     * @return {*}
     */
    void drawInsRects();

public:
    //实例目标
    std::vector<InstanceBevObject> vInsObjs;

    //bev 语义图像图像
    cv::Mat m_imgBEV_static;
    //bev 语义地图类别
    pcl::PointCloud<pcl::PointXYZI> m_pointcloud_static_class;

    // 可视化信息
    //bev 实例 图像
    cv::Mat m_imgBEV_Instance;
    //bev 实例目标 点云
    pcl::PointCloud<pcl::PointXYZRGB> m_cloudBEV_Instance;
    //bev 原始实例目标点云
    // pcl::PointCloud<pcl::PointXYZRGB> m_cloudBEV_ori;
    //bev 静态语义点云
    pcl::PointCloud<pcl::PointXYZRGB> m_cloudBEV_static;
    
    static int m_nCenterX;   //BEV图像中心点坐标X
    static int m_nCenterY;   //BEV图像中心点坐标Y
    
};


class Visione_3D
{
public:
    Visione_3D(const perception::camera::ImageInferNodeParam& param);
    ~Visione_3D();


     /**
     * @name: Process_objects
     * @msg: 处理核心函数 
     * @param {Mat} image  RGB图像
     * @param {Mat} imgdist 图像视差图 或 深度图  由 bdepth 标识
     * @param {vector<object_Seg_info>}  实例 语义目标信息列表
     * @param {BEV_GridMap&} vGrid  gridmap，保存bev结果
     * @return {*}
     */
    int Process_objects(const cv::Mat& image, const cv::Mat& imgdist, std::vector<object_Seg_info>&objs, BEV_GridMap& vGrid);

    
     /**
     * @name: Process_objects
     * @msg: 使用点云投影来获取bev结果 
     * @param {Mat} image  RGB图像
     * @param {Cloud::Ptr} pcl_cloud 点云
     * @param {vector<object_Seg_info>}  实例 语义目标信息列表
     * @param {BEV_GridMap&} vGrid  gridmap，保存bev结果
     * @return {*}
     */
    int Process_objects(const cv::Mat& image, Cloud::Ptr& pcl_cloud, std::vector<object_Seg_info>&objs, BEV_GridMap& vGrid);

    /**
     * @name: Process_objects
     * @msg: 使用点云投影和深度估计来获取bev结果 
     * @param {Mat} image  RGB图像
     * @param {Mat} depth 深度图
     * @param {Cloud::Ptr} pcl_cloud 点云
     * @param {vector<object_Seg_info>}  实例 语义目标信息列表
     * @param {BEV_GridMap&} vGrid  gridmap，保存bev结果
     * @return {*}
     */
    int Process_objects(const cv::Mat& image, const cv::Mat& depth, Cloud::Ptr& pcl_cloud, std::vector<object_Seg_info>&objs, BEV_GridMap& vGrid);


private:

    int init(waytous::deepinfer::ios::CameraParamPtr camera_param_ptr);
    int initConvertMap();

    /**
     * @name: Calc_Depth_Clouds
     * @msg: 计算视差图对应的点云图
     * @param {Mat &} disparty  视差图
     * @param {PointCloud<PointXYZ>} pointCloud  转换后的点云
     * @return {*}
     */
    int Calc_Depth_Clouds(const cv::Mat & disparty, pcl::PointCloud<pcl::PointXYZ>& pointCloud );

    int Process_Segmantic_Objects(object_Seg_info& obj, const cv::Mat& dispart, const unsigned short * pTable, BEV_GridMap& vGrid ) ;
    int Process_Instance_Objects(object_Seg_info& obj, const cv::Mat& dispart, const unsigned short * pTable, BEV_GridMap& vGrid );

    int Process_Segmantic_Objects(object_Seg_info& obj, const cv::Mat& indices, Cloud::Ptr& pcl_cloud, BEV_GridMap& vGrid);
    int Process_Instance_Objects(object_Seg_info& obj, const cv::Mat& indices, Cloud::Ptr& pcl_cloud, BEV_GridMap& vGrid);

    cv::RotatedRect  getObjectAreaRect(const cv::Mat& imgBin, const cv::Mat& imgCount, cv::Rect objRc, 
        std::vector<cv::Point >& vPoints, cv::Vec3b color, const std::string& objClassName);

    int conver_worldPt_pixelPt(const pcl::PointXYZ& ptworld, cv::Point2f& ptImg );

    std::string current_frame_id = "Lidar";
    cv::Mat m_matrixQ;
    Eigen::Matrix4d m_lidar2camera;
	// Eigen::Matrix4d m_lidar2odom;

    float obstacle_height_threshold = 30; // 障碍物高差阈值
    float g_depthScaleFactor =  256.0/65536.0f;  //256/65536.0f; //
    // float g_depthScaleFactor =  100.0/65536.0f; 

    //uvd -> x y 查询表  
    short m_Index2D_to_bev[IMAGE_RESIZE_HEIGHT][IMAGE_RESIZE_WIDTH][DEPTH_TABEL_MAX_INDEX][2];  //最后两维存储x y
    
    //视差对应对应的距离索引
    // unsigned short m_Dist2Index[DISPARTY_MAX*DISPARTY_MAGNIFICATE];

    //深度对应的距离索引
    unsigned short m_Depth2Index[65536];
    
    //BEV 网格距离对应的视差值
    // int m_nZ2dis[DEPTH_TABEL_MAX_INDEX];

    //网格里面 BEV_GRID_RESOLUTION~BEV_GRID_RESOLUTION米大小对应的图像像素点数量
    int m_nGridPixelNum [BEV_IAGE_HEIGHT][BEV_IAGE_WIDTH];

    //bev 图像像素参考数目
    cv::Mat m_imgPixelNum;
    //bev 图像像素参考数目
    //cv::Mat m_imgPixelValid;
    int m_nPixelValidHeight;

    //最大车辆长度
    int m_nMaxBEVVehicleLength;

};

#endif 
