/*
 * @Descripttion: 
 * @version: 
 * @Author: wxin
 * @Date: 2023-09-03 03:13:41
 * @email: xin.wang@waytous.com
 * @LastEditors: wxin
 * @LastEditTime: 2023-11-23 08:56:03
 */


#include "vision_transform/vision_3d.h"
#include "utils.h"


int BEV_GridMap::m_nCenterX = (int) (BEV_SIZE_WIDTH*0.5/BEV_GRID_RESOLUTION);
int BEV_GridMap::m_nCenterY = 0;

BEV_GridMap::BEV_GridMap()
{
    m_imgBEV_static = cv::Mat::zeros(
        cv::Size((int)(BEV_SIZE_WIDTH/BEV_GRID_RESOLUTION), (int)(BEV_SIZE_HEIGHT/BEV_GRID_RESOLUTION)),
        CV_8UC3);
    m_pointcloud_static_class.reserve(200 * 200); // 40000 points at most
}


void  BEV_GridMap::initVisualInfo(){
    m_imgBEV_Instance = cv::Mat::zeros(
            cv::Size((int)(BEV_SIZE_WIDTH/BEV_GRID_RESOLUTION), (int)(BEV_SIZE_HEIGHT/BEV_GRID_RESOLUTION)),
            CV_8UC3);
    m_cloudBEV_Instance.resize(m_imgBEV_Instance.cols * m_imgBEV_Instance.rows);
    int nCount = 0;
    cv::Point2f pt2f;
    for( int n = 0; n < m_imgBEV_Instance.rows; n++)
    {
        for(int m = 0; m < m_imgBEV_Instance.cols; m++)
        {
            pt2f = BEV_GridMap::convertmap_2_3d(m,n);
            m_cloudBEV_Instance.points[nCount].x = pt2f.x;
            m_cloudBEV_Instance.points[nCount].y = pt2f.y;
            m_cloudBEV_Instance.points[nCount].z = 0;
            m_cloudBEV_Instance.points[nCount].r = 0;
            m_cloudBEV_Instance.points[nCount].g = 80;
            m_cloudBEV_Instance.points[nCount].b = 80;
            nCount++;
        }
    }
    m_cloudBEV_static = m_cloudBEV_Instance;
}


cv::Point BEV_GridMap::convert3d_2_map(float fx, float fy){
    int x = int( fy/BEV_GRID_RESOLUTION + m_nCenterX) ;
    int y = int( fx/BEV_GRID_RESOLUTION + m_nCenterY);
    return cv::Point(x,y);
}


cv::Point2f BEV_GridMap::convertmap_2_3d(int x, int y){
    float fx = (y - m_nCenterY)*BEV_GRID_RESOLUTION; 
    float fy = (x - m_nCenterX)*BEV_GRID_RESOLUTION; 
    return cv::Point2f(fx,fy);
}


void BEV_GridMap::drawInsMasks(){
     for(auto & obj: vInsObjs)
        {   
            int sep = obj.fromDepth ? 2 : 1;
            cv::Vec3b color = cv::Vec3b(obj.color.b / sep, obj.color.g / sep, obj.color.r / sep);
            for( auto & pt : obj.vPoints)
            {
                m_imgBEV_Instance.at<cv::Vec3b>(pt.y, pt.x) = color;
            }
        }
};


void BEV_GridMap::drawInsRects(){
    for(auto & obj: vInsObjs)
        {
            int sep = obj.fromDepth ? 2 : 1;
            cv::Vec3b color_ = cv::Vec3b(obj.color.b / sep, obj.color.g / sep, obj.color.r / sep);
            cv::Mat vertices;     
            // 求得旋转矩形的四个顶点坐标，然后在黑色画板上用line函数画出四条边，得到该矩形
            boxPoints(obj.rrc, vertices);       //计算出的4个顶点存在一个4行2列的Mat对象中，每一行代表一个顶点坐标
            for (auto i = 0; i < vertices.rows; ++i)
            {
                cv::Point p1 = cv::Point(vertices.at<float>(i,0), vertices.at<float>(i, 1));
                cv::Point p2 = cv::Point(vertices.at<float>((i+1)%4, 0), vertices.at<float>((i + 1) % 4, 1));
                line(m_imgBEV_Instance, p1, p2, color_, 1);
            }
        }
};



Visione_3D::Visione_3D(const perception::camera::ImageInferNodeParam& param)
{
    m_imgPixelNum = cv::Mat::ones(cv::Size(BEV_IAGE_WIDTH, BEV_IAGE_HEIGHT), CV_8UC1) * 255;
    m_nPixelValidHeight = 0;
    m_nMaxBEVVehicleLength = (int)(10/BEV_GRID_RESOLUTION);
    current_frame_id = param.vis_frame_id;
    obstacle_height_threshold = param.obstacle_height_threshold;

    init(param.cameraParam_);
    initConvertMap();
}

Visione_3D::~Visione_3D()
{
    
}

int Visione_3D::init(waytous::deepinfer::ios::CameraParamPtr camera_param_ptr)
{
    // fs["new_camera_matrix"] >> m_matrixQ;
    cv::eigen2cv(camera_param_ptr->new_camera_intrinsic, m_matrixQ);
    // cv::Mat matTemp;
    // fs["Matrix_lidar01_camera01"] >> matTemp;
    // Eigen::Matrix4d m_lidar2camera_;
    // cv::cv2eigen(matTemp, m_lidar2camera_);
    m_lidar2camera = camera_param_ptr->camera2lidar_extrinsic.inverse();

    // fs["Matrix_lidar01_odom"] >> matTemp;
    // cv::cv2eigen(matTemp, m_lidar2odom);

    std::cout << "camera_matrix: \n" <<  m_matrixQ << std::endl;
    std::cout << "m_lidar2camera: \n" <<  m_lidar2camera << std::endl;
    // cout << "m_lidar2odom: \n" <<  m_lidar2odom << endl;
    return 0;
}

/**
 * @name: Calc_Depth_Clouds
 * @msg: 计算视差图对应的点云图
 * @param {Mat &} disparty  视差图
 * @param {PointCloud<PointXYZ>} pointCloud  转换后的点云
 * @return {*}
 */
int Visione_3D::Calc_Depth_Clouds(const cv::Mat & disparty, pcl::PointCloud<pcl::PointXYZ>& pointCloud )
{
    float tx = m_matrixQ.at<float>(0, 2); 
    float ty = m_matrixQ.at<float>(1, 2); 
    float fx = m_matrixQ.at<float>(0, 0);
    float fy = m_matrixQ.at<float>(1, 1);
    // std::cout<<"caldepth mq:"<<tx<<","<<ty<<","<<fx<<","<<fy<<std::endl;
    // float fbase = -1/-m_matrixQ.at<float>(3,2); 
    // float fb = fx*fbase*0.001;
    pointCloud.resize(disparty.rows * disparty.cols);
    pcl::PointXYZ point;
    int count = 0;
    for(int j = 0; j < disparty.rows; j ++)
    {
        for(int i = 0; i < disparty.cols; i++){
            float dz =   disparty.at<float>(j,i);
            float dx = (i - tx)*dz/fx;  
            float dy = (j - ty)*dz/fy;
            pointCloud.points[count].x = dx;
            pointCloud.points[count].y =dy;
            pointCloud.points[count].z = dz;
            count++;
        }
    }
    return 0;
}




int Visione_3D::conver_worldPt_pixelPt(const pcl::PointXYZ& ptworld, cv::Point2f& ptImg )
{
    float tx = m_matrixQ.at<float>(0, 2); 
    float ty = m_matrixQ.at<float>(1, 2); 
    float fx = m_matrixQ.at<float>(0, 0); 
    float fy = m_matrixQ.at<float>(1, 1);

    ptImg.x = ptworld.x *fx /ptworld.z + tx;
    ptImg.y = ptworld.y *fy /ptworld.z + ty;
    if( ptImg.x > IMAGE_RESIZE_WIDTH ){
        ptImg.x = -1;
    }
    if( ptImg.x < 0 ){
        ptImg.x = -1;
    }
    if( ptImg.y > IMAGE_RESIZE_HEIGHT ){
        ptImg.y = -1;
    }
    if( ptImg.y < 0 ){
        ptImg.y = -1;
    }
    return 0;
}


/**
 * @name: initConvertMap
 * @msg: 初始化变换表
 * @return {*}
 */
int Visione_3D::initConvertMap()
{
    long long nSize;
    // nSize = sizeof(m_nZ2dis);
    // cout<<" dist to index to cloud tabel size:" << nSize << " " << nSize*1.0/1024/1024 << " MB"<< endl;
    // nSize = sizeof(m_Dist2Index);
    // cout<<" dist to index  array size:" << nSize << " " << nSize*1.0/1024/1024 << " MB"<< endl;
    nSize = sizeof(m_Depth2Index);
    std::cout<<" depth to index  array size:" << nSize << " " << nSize*1.0/1024/1024 << " MB"<< std::endl;

    // nSize = sizeof(m_Index2D_to_bev);
    // cout<<" dist to index to bev index size:" << nSize << " " << nSize*1.0/1024/1024 << " MB"<< endl;

    //根据距离 反算视差  形成索引表


    //根据m_nZ2dis 计算索引值
    std::cout << "init image2bev with depth, initalizing ..." << std::endl;
    clock_t start_ = clock(); 
    for(int ii = 0; ii < DEPTH_TABEL_MAX_INDEX; ii++)
    {   
        //无效视差 设置一个大值
        if(ii <= 5 )
        {
            for( int j = 0; j < IMAGE_RESIZE_HEIGHT; j++)
            {
                for( int i = 0; i < IMAGE_RESIZE_WIDTH; i++)
                {
                    m_Index2D_to_bev[j][i][ii][0] = 0; //-1000;
                    m_Index2D_to_bev[j][i][ii][1] = 0; //-1000;
                }
            }
        }
        //正常值 进行计算
        else
        {
            //定义clock_t变量 开始时间
            // clock_t start_2 = clock(); 

            //对应的真实视差
            // float fdist = m_nZ2dis[ii] * 1.0/DISPARTY_MAGNIFICATE; 
            float fdepth = ii * BEV_GRID_RESOLUTION; 
            //创建一张值全为fdepth的图
            cv::Mat floatDepth = cv::Mat::ones(cv::Size(IMAGE_RESIZE_WIDTH, IMAGE_RESIZE_HEIGHT), CV_32FC1) * fdepth;

            pcl::PointCloud<pcl::PointXYZ> cloud_camera;  //相机坐标系点云
            pcl::PointCloud<pcl::PointXYZ> cloud_lidar;   //雷达坐标系点云
            Calc_Depth_Clouds(floatDepth, cloud_camera );  //计算相机点云
            pcl::transformPointCloud(cloud_camera, cloud_lidar, m_lidar2camera);  //点云由相机转雷达坐标系

            //std::cout<<"transform calc total time = "<<double(clock()-start_2)/CLOCKS_PER_SEC<<"s "; //<<endl;  //输出时间（单位：ｓ）

            for(int i = 0; i < cloud_lidar.size(); i++)
            {
                int n = i / IMAGE_RESIZE_WIDTH;
                int m = i % IMAGE_RESIZE_WIDTH;
                cv::Point pt = BEV_GridMap::convert3d_2_map(cloud_lidar.points[i].x, cloud_lidar.points[i].y);
                //越界坐标点修正
                if( pt.x >= (int)(BEV_SIZE_WIDTH/BEV_GRID_RESOLUTION) || pt.x< 0 || pt.y > (int)(BEV_SIZE_HEIGHT/BEV_GRID_RESOLUTION) || pt.y <0 )
                {
                    //cout<<"depth = "<< ii*BEV_GRID_RESOLUTION << " u: "<< n<<" v "<< m << " x: " << pt.x << "  y: "<< pt.y<<endl;
                    pt.x = 0; pt.y = 0;
                }

                m_Index2D_to_bev[n][m][ii][0] = pt.x;
                m_Index2D_to_bev[n][m][ii][1] = pt.y;
                if(pt.x <0 || pt.y <0){
                    std::cout<<"x:"<<pt.x<<","<<pt.y<<std::endl;
                    std::cout<<cloud_lidar.points[i].x<<", "<<cloud_lidar.points[i].y<<std::endl;
                }
            }
            // std::cout<< ii << " m_Index2D_to_3D time = "<<double(clock()-start_2)/CLOCKS_PER_SEC<<"s"<<endl;  //输出时间（单位：ｓ）
            // start_2 = clock();   //开始时间
        }
    }
    std::cout<<" init table done, using time = "<<double(clock()-start_)/CLOCKS_PER_SEC<<"s"<<std::endl;  //输出时间（单位：ｓ）

    //求取视差到索引的查询表  视差和距离反比关系，因此倒着求取
    /*
    int nInvIndex = DEPTH_TABEL_MAX_INDEX;
    for( int i = 0; i < m_nZ2dis[nInvIndex-1]; i++)
    {
        m_Dist2Index[i] = 0;
    }
    for( nInvIndex = DEPTH_TABEL_MAX_INDEX-1; nInvIndex > 0; nInvIndex--)
    {
        int nback  = m_nZ2dis[nInvIndex];
        int nfront = m_nZ2dis[nInvIndex-1];
        if( nfront < nback){
            m_Dist2Index[nfront] = nInvIndex;
            break;
        }
        for( int i =  nback; i < nfront; i++)
        {
            m_Dist2Index[i] = nInvIndex;
        }
    }
    */

    //求取视差到索引的查询表  
    for(int i = 0; i < 65536; i++)
    {
        float fdist = i*g_depthScaleFactor/ BEV_GRID_RESOLUTION ;
        if(fdist < 1.0){
            m_Depth2Index[i] = 0;
        }
        else{
            m_Depth2Index[i] = (unsigned short)(fdist);
        }        
    }
    

    //计算BEV网格点累计点数量阈值
    Eigen::Matrix4d T_cam_bev =  m_lidar2camera.inverse();
    for(int j = 0; j < m_imgPixelNum.rows; j++)
    {
        for(int i = 0; i < m_imgPixelNum.cols; i++)
        {
            //雷达坐标系转换到相机坐标系
            pcl::PointCloud<pcl::PointXYZ> ptGrid;  //相机坐标系点云
            ptGrid.resize(4);
            ptGrid[0].x = ptGrid[1].x = ptGrid[2].x = ptGrid[3].x = (j+1)*BEV_GRID_RESOLUTION;
            ptGrid[0].z = ptGrid[1].z = 0;
            ptGrid[2].z = ptGrid[3].z = BEV_GRID_RESOLUTION*0.7f;
            ptGrid[0].y = ptGrid[2].y  = -(i-BEV_GridMap::m_nCenterX)*BEV_GRID_RESOLUTION;
            ptGrid[1].y = ptGrid[3].y  = -(i+1-BEV_GridMap::m_nCenterX) *BEV_GRID_RESOLUTION;

            pcl::PointCloud<pcl::PointXYZ> ptCam;
            pcl::transformPointCloud(ptGrid, ptCam, T_cam_bev);  //点云由相机转雷达坐标系

            cv::Point2f ptPixel[4];
            int bOk = 1;
            for(int mm = 0; mm < 4; mm++) 
            {
                conver_worldPt_pixelPt(ptCam[mm], ptPixel[mm]);
                if( ptPixel[mm].x < 0 || ptPixel[mm].y < 0){
                    bOk = 0;
                    break;
                }
            } 
            if(bOk){
                int nH = MIN(abs(ptPixel[2].y - ptPixel[0].y), abs(ptPixel[3].y - ptPixel[1].y) );
                int nW = MIN(abs( ptPixel[1].x - ptPixel[0].x), abs(  ptPixel[3].x - ptPixel[2].x) );
                m_imgPixelNum.at<uchar>(j,i) = MIN(250, MAX(nH-1,1) * MAX(nW-1,1)) ;
            }
            //std::cout<< (int) m_imgPixelNum.at<uchar>(j,i) << " ";
        }
        //std::cout<< "j = "<<  j << endl;
    }

    //计算BEV网格累计阈值有效的最大高度    
    cv::Mat imgPixValid = (m_imgPixelNum>=2)*255 ;
    for(int jj = 0;  jj < imgPixValid.rows; jj++)
    {
        int conut = cv::countNonZero( imgPixValid.row(jj) );
        if( conut < imgPixValid.cols ){
            // for( int ii = 0; ii < m_imgPixelNum.cols; ii++){
            //     m_imgPixelNum.at<uchar>(jj,ii) = 250;
            // }
        }
        else{
            m_nPixelValidHeight =jj;
        }
    }
    std::cout<<"m_nPixelValidHeight: "<<m_nPixelValidHeight<<std::endl;

    return 0;
}


/**
 * @name: Process_objects
 * @msg: 处理核心函数 
 * @param {Mat} image  RGB图像
 * @param {Mat} imgdist 图像视差图 或 深度图  由 bdepth 标识
 * @param {vector<object_Seg_info>}  实例 语义目标信息列表
 * @param {BEV_GridMap&} vGrid  gridmap，保存bev结果
 * @return {*}
 */
int Visione_3D::Process_objects(const cv::Mat& image, const cv::Mat& imgdist, std::vector<object_Seg_info>&objs, BEV_GridMap& vGrid)
{
    if( imgdist.empty() || objs.empty()){
        return -1;
    }

    //距离索引
    unsigned short * pTable =  m_Depth2Index;

    //循环每个目标
    clock_t start_ = clock();
    for( int mm = 0; mm < objs.size(); mm++)
    {
        // g_Obj_count = mm+1;
        auto & obj = objs[mm];
        if( 0 == obj.bDetectType ){
            Process_Instance_Objects(obj, imgdist, pTable, vGrid);
        }
        else{
            Process_Segmantic_Objects(obj, imgdist, pTable, vGrid);
        }
    }
    // 将静态目标投影到栅格地图中
    pcl::PointXYZI bev_point;
    cv::Point2f pt2f;
    for(auto& bevObj: vGrid.vInsObjs){
        if(std::find(perception::camera::StaticTypes.begin(), perception::camera::StaticTypes.end(), bevObj.names)
            != perception::camera::StaticTypes.end()
        ){
            uchar objcls = (perception::camera::name2type.find(bevObj.names) == perception::camera::name2type.end() ? 
                perception::camera::Perception_Default_Classification : perception::camera::name2type[bevObj.names]);
            cv::Vec3b color = cv::Vec3b(bevObj.color.b, bevObj.color.g, bevObj.color.r);
            for(auto&p : bevObj.vPoints){
                pt2f = BEV_GridMap::convertmap_2_3d(p.x, p.y);
                bev_point.x = pt2f.x;
                bev_point.y = pt2f.y;
                bev_point.z = 0;
                bev_point.intensity = (float)objcls;
                vGrid.m_imgBEV_static.at<cv::Vec3b>(p.y, p.x) = color;
                vGrid.m_pointcloud_static_class.points.emplace_back(bev_point);
            }
        }
    }
    return 0;
}


int Visione_3D::Process_Segmantic_Objects(object_Seg_info& obj, const cv::Mat& dispart, const unsigned short * pTable, BEV_GridMap& vGrid )
{
    cv::Scalar objColor = obj.color;
    const cv::Rect& rc = obj.rc;
    obj.valid = 2;
    uchar objcls = (perception::camera::name2type.find(obj.name) == perception::camera::name2type.end() ? 
        perception::camera::Perception_Default_Classification : perception::camera::name2type[obj.name]);
    // cv::Mat objBin = cv::Mat::zeros(vGrid.m_imgBEV_static.size(), CV_8UC1);

    int stepY = std::max(1, obj.mask.rows/100);
    int stepX = std::max(1, obj.mask.cols/100);
    int m, n, ix, iy;
    unsigned short index; 
    cv::Vec3b color = cv::Vec3b(objColor[2], objColor[1], objColor[0]);
    // BEV_COLOR uColor; 
    // uColor.r = objColor[0]; uColor.g = objColor[1]; uColor.b = objColor[2];
    
    // int nValidNum = 0;
    // int objY1 = objBin.rows, objY2 = 0;
    // int objX1 = objBin.cols, objX2 = 0;

    //目标 mask
    // clock_t start_ = clock();
    pcl::PointXYZI p;
    cv::Point2f pt2f;
    for( int j = 0; j < obj.mask.rows; j+=stepY)
    {
        for(int i = 0; i < obj.mask.cols; i+=stepX) 
        {
            m = rc.x + i;
            n = rc.y + j;
            if( 0 == obj.mask.at<uchar>(j,i) || 0 == dispart.at<ushort>(n,m) ){
                continue;
            }
            
            index = pTable[dispart.at<ushort>(n,m)];
            if( 0 == index || index >= DEPTH_TABEL_MAX_INDEX){
                continue;
            }
            
            ix = m_Index2D_to_bev[n][m][index][0];
            iy = m_Index2D_to_bev[n][m][index][1];
            if( ix !=0 && iy != 0)
            {
                // objY1 = MIN(iy, objY1);
                // objY2 = MAX(iy, objY2);    
                // objX1 = MIN(ix, objX1);
                // objX2 = MAX(ix, objX2);

                vGrid.m_imgBEV_static.at<cv::Vec3b>(iy, ix) = color;
                // vGrid.m_imgBev_Class.at<uchar>(iy,ix) = objcls;
                pt2f = BEV_GridMap::convertmap_2_3d(ix, iy);
                p.x = pt2f.x;
                p.y = pt2f.y;
                p.z = 0;
                p.intensity = (float)objcls;
                vGrid.m_pointcloud_static_class.points.emplace_back(p);

                // objBin.at<uchar>(iy, ix) = 255;
                // nValidNum++;
            }              
        }
    }

    return 0;
}


int Visione_3D::Process_Instance_Objects(object_Seg_info& obj, const cv::Mat& dispart, const unsigned short * pTable, BEV_GridMap& vGrid )
{
    cv::Scalar objColor = obj.color;
    const cv::Rect& rc = obj.rc;
    cv::Mat objBin = cv::Mat::zeros(vGrid.m_imgBEV_static.size(), CV_8UC1);
    cv::Mat objBinCount = cv::Mat::zeros(vGrid.m_imgBEV_static.size(), CV_8UC1);

    int stepY = 1 ; //max(1, obj.mask.rows/20);
    int stepX = 1 ; //max(1, obj.mask.cols/40);
    int m, n, ix, iy;
    unsigned short index; 
    cv::Vec3b color = cv::Vec3b(objColor[2], objColor[1], objColor[0]);
    BEV_COLOR uColor; 
    uColor.r = objColor[0]; uColor.g = objColor[1]; uColor.b = objColor[2];
    
    int nValidNum = 0;
    int objY1 = objBin.rows, objY2 = 0;
    int objX1 = objBin.cols, objX2 = 0;

    //目标 mask
    // clock_t start_ = clock();
    for( int j = 0; j < obj.mask.rows; j+=stepY)
    {
        for(int i = 0; i < obj.mask.cols; i+=stepX) 
        {
            m = rc.x + i;
            n = rc.y + j;
            if( 0 == obj.mask.at<uchar>(j,i) || 0 == dispart.at<ushort>(n,m) ){
                continue;
            }
            
            index = pTable[dispart.at<ushort>(n,m)];
            if( 0 == index || index >= DEPTH_TABEL_MAX_INDEX){
                continue;
            }
            
            ix = m_Index2D_to_bev[n][m][index][0];
            iy = m_Index2D_to_bev[n][m][index][1];
            
            if( ix !=0 && iy != 0)
            {
                objY1 = MIN(iy, objY1);
                objY2 = MAX(iy, objY2);    
                objX1 = MIN(ix, objX1);
                objX2 = MAX(ix, objX2);

                // vGrid.m_imgBev_ori.at<Vec3b>(iy, ix) = color;

                objBin.at<uchar>(iy, ix) = 255;
                objBinCount.at<uchar>(iy, ix)  = MIN(255, objBinCount.at<uchar>(iy, ix)+1);
                nValidNum++;
            }              
        }
    }
    // std::cout<<" instance find table vision "<<double(clock()-start_)/CLOCKS_PER_SEC<<"s"<<std::endl;  //输出时间（单位：ｓ）

    // start_ = clock();
    //目标bev矩形区域
    cv::Rect objRc = cv::Rect(objX1, objY1, MIN(objBin.cols, objX2 + 1) - objX1,  MIN(objBin.rows, objY2 + 1) - objY1);
    if(nValidNum > 5 && objRc.width > 0 && objRc.height > 0)
    {
        InstanceBevObject insobj;
        // std::cout<<objBinCount.cols<<","<<objBinCount.rows<<":"<<objRc.x<<","<<objRc.y<<","<<objRc.width+objRc.x<<","<<objRc.height+objRc.y<<std::endl;
        insobj.rrc = getObjectAreaRect(objBin, objBinCount, objRc, insobj.vPoints, color, obj.name);
        if( insobj.rrc.size.height > 0 && insobj.rrc.size.width > 0) {
            insobj.rc = obj.rc;
            insobj.color = uColor;
            insobj.names = obj.name;
            insobj.fConfidence  = obj.fConfidence;
            insobj.fromDepth = true;
            vGrid.vInsObjs.push_back(insobj);
            obj.valid = 2;
        }
    }
    // std::cout<<" instance rc vision "<<double(clock()-start_)/CLOCKS_PER_SEC<<"s"<<std::endl;  //输出时间（单位：ｓ）
    return 0;
}


cv::RotatedRect  Visione_3D::getObjectAreaRect(const cv::Mat& imgBin, const cv::Mat& imgCount, cv::Rect objRc, 
    std::vector<cv::Point >& vPoints, cv::Vec3b color, const std::string& objClassName)
{
    cv::RotatedRect rRect;

    int bUp = 0;
    cv::Mat objBin = imgBin.clone();
    //如果目标区域可以用像素数目阈值过滤
    //目标底端高于有效高度  或者 起始位置高于有效高度一个最大车长距离
    bool isVehicle = false;
    if(std::find(perception::camera::VehicleTypes.begin(), perception::camera::VehicleTypes.end(), objClassName)
        != perception::camera::VehicleTypes.end()){
        isVehicle = true;
    }
    
    if( isVehicle && (objRc.y+ objRc.height <= m_nPixelValidHeight  || objRc.y + m_nMaxBEVVehicleLength <= m_nPixelValidHeight))
    {
        cv::Mat countSub = imgCount(objRc).clone();
        objBin = (imgCount(objRc)>= m_imgPixelNum(objRc)) *255;
        // objBin = (imgCount(objRc)>= 1) *255;

        std::vector<std::vector<cv::Point>> vvBinPt;
        cv::Mat labels;
        int n_comps = connectedComponents(objBin, labels, 8, CV_16U);

        Findlabel(labels, n_comps, vvBinPt);

        std::vector<int> histogram_of_labels(n_comps, 0);
        std::vector<int> pixCount_of_labels(n_comps, 0);
        std::vector<float> avr_pix_count(n_comps, 0.0f);
        for (int i = 1; i < n_comps; i++)
        {
            std::vector<cv::Point> &vBinPt = vvBinPt[i];
            for( auto & pt :  vBinPt){
                histogram_of_labels.at(labels.at<unsigned short>(pt.y, pt.x)) += 1;
                pixCount_of_labels.at(labels.at<unsigned short>(pt.y, pt.x)) += countSub.at<uchar>(pt.y,pt.x);
            }
        }
        float fmaxAvr = 0.f;
        for(int i = 1; i < n_comps; i++)
        {
            avr_pix_count[i] = pixCount_of_labels[i] / (histogram_of_labels[i]+0.01f);
            fmaxAvr = MAX( fmaxAvr, avr_pix_count[i] );
            //cout<<" pixCount_of_labels[" << i <<"]: " <<   avr_pix_count[i] <<endl;
        }
        float fthrAvr = fmaxAvr *0.4;

        //均值大于1 才是上方目标
        if( fthrAvr  >1.0)
        {
            for (int i = 1; i < n_comps; i++)
            {
                std::vector<cv::Point> &vBinPt = vvBinPt[i];
                if (vBinPt.size() < 5)
                    continue;
                if( avr_pix_count[i] < fthrAvr)
                    continue;

                cv::Rect rect = GetBundingRect(vBinPt);
                if (rect.width < 3 &&rect.height < 3)
                    continue; // 小目标
                int nStart = vPoints.size();
                vPoints.resize(vPoints.size()+vBinPt.size());
                for(int ss = 0; ss < vBinPt.size(); ss++)
                {
                    vPoints[nStart+ss].x = vBinPt[ss].x + objRc.x;
                    vPoints[nStart+ss].y = vBinPt[ss].y + objRc.y;
                }
                //vPoints.insert( vPoints.end(), vBinPt.begin(), vBinPt.end());
            }
            // 点不够，使用最大连通域
            if(vPoints.size() > 5){
                bUp = 1;
            }
        }
        //cout <<" up  objects" << endl;
    }

    //BEV图像下半部分  网格累计像素数量少无法过滤   通过联通阈分析
    if(0 ==bUp)
    {
        //cout <<" down  objects" << endl;
        cv::Mat imbDilate;
        cv::Mat element1 =  cv::getStructuringElement(cv::MORPH_RECT, cv::Size(3,1));
        cv::Mat element2 =  cv::getStructuringElement(cv::MORPH_RECT, cv::Size(7,7));
      
        cv::dilate(imgBin, imbDilate, element1);
        cv::erode(imbDilate, imbDilate, element1);
        
        // cv::namedWindow("objbin dilate", 0);
        // cv::imshow( "objbin dilate", imbDilate);
        //cv::waitKey(0);

        cv::Mat labels;

        //1. 标记连通域
        int n_comps = connectedComponents(imbDilate, labels, 4, CV_16U);
        std::vector<int> histogram_of_labels(n_comps, 0);
        std::vector<int> pixCount_of_labels(n_comps, 0);

        int rows = labels.rows;
        int cols = labels.cols;
        for (int row = 0; row < rows; row++) //计算每个labels的个数
        {
            for (int col = 0; col < cols; col++)
            {
                if( labels.at<unsigned short>(row, col) )
                {
                    histogram_of_labels.at(labels.at<unsigned short>(row, col)) += 1;
                    pixCount_of_labels.at(labels.at<unsigned short>(row, col)) += imgCount.at<uchar>(row,col);
                }
            }
        }

        //2. 计算最大的连通域labels索引
        int maximum = 0;
        int max_idx = -1;
        for (int i = 0; i < n_comps; i++)
        {
            if (pixCount_of_labels.at(i) > maximum)
            {
                maximum = pixCount_of_labels.at(i);
                max_idx = i;
            }
        }

        //3. 将最大连通域提取二值点
        if( -1 != max_idx)
        {
            for (int row = 0; row < rows; row++) 
            {
                for (int col = 0; col < cols; col++)
                {
                    if (labels.at<unsigned short>(row, col) == max_idx  && imgBin.at<uchar>(row,col) )
                    {
                        vPoints.push_back(cv::Point(col,row));
                    }
                }
            } 
        }
    }

    if( vPoints.size() > 3)
    {
        rRect = minAreaRect(vPoints);
        // 根据每个类别的最大size，修正bev框
        float max_size = (perception::camera::name2max_size.find(objClassName) == perception::camera::name2max_size.end() ? 
            perception::camera::Perception_Default_Maxsize : perception::camera::name2max_size[objClassName]);
        max_size = max_size / BEV_GRID_RESOLUTION ;
        if(rRect.size.width > max_size || rRect.size.height > max_size){
            // std::cout<<"before fix size:"<<objClassName<<", "<<rRect.size<<std::endl;
            cv::Point2f vertices[4];
            rRect.points(vertices);
            cv::Point2f baseBottomPoint = vertices[2];
            rRect.size = cv::Size(std::min(rRect.size.width, max_size), std::min(rRect.size.height, max_size));
            rRect.points(vertices);
            cv::Point2f newBottomPoint = vertices[2];
            auto diff = baseBottomPoint - newBottomPoint;
            rRect.center = cv::Point2f(rRect.center.x + diff.x, rRect.center.y + diff.y);
            // std::cout<<"after fix size:"<<objClassName<<", "<<rRect.size<<std::endl;

            // 过滤多余点
            auto bundingRect = rRect.boundingRect2f();
            for(auto iter = vPoints.begin(); iter != vPoints.end();){
                bool in_rect = ((iter->x <= bundingRect.x+bundingRect.width) && (iter->x >= bundingRect.x) && 
                                (iter->y <= bundingRect.y+bundingRect.height) && (iter->y >= bundingRect.y));
                if(!in_rect){
                    iter = vPoints.erase(iter);
                }else{
                    iter++;
                }
            }
        }
    }
   
    return rRect;
} 


/**
 * @name: Process_objects
 * @msg: 使用点云投影来获取bev结果 
 * @param {Mat} image  RGB图像
 * @param {Cloud::Ptr} pcl_cloud 点云
 * @param {vector<object_Seg_info>}  实例 语义目标信息列表
 * @param {BEV_GridMap&} vGrid  gridmap，保存bev结果
 * @return {*}
 */
int Visione_3D::Process_objects(const cv::Mat& image, Cloud::Ptr& pcl_cloud, std::vector<object_Seg_info>&objs, BEV_GridMap& vGrid){
    if( pcl_cloud == nullptr || objs.empty()){
        return -1;
    }

    clock_t start_ = clock();
    // 点云转换到相机
    Cloud::Ptr camera_cloud(new Cloud);
    Eigen::Matrix4d c2l = m_lidar2camera.inverse();
    pcl::transformPointCloud(*pcl_cloud, *camera_cloud, c2l);
    // 投影到图像中, 保存全部投影index和 高度小于1m的index，用做落石处理
    cv::Mat point_index_in_camera = cv::Mat::zeros(image.size(), CV_16UC2);// cv::Vec2w ushort
    float tx = m_matrixQ.at<float>(0, 2); 
    float ty = m_matrixQ.at<float>(1, 2); 
    float fx = m_matrixQ.at<float>(0, 0);
    float fy = m_matrixQ.at<float>(1, 1);
    // cv::Mat cv_image = image;
    for(int i=1; i<camera_cloud->size() && i < 65536; i++){
        auto& p3d = camera_cloud->points[i];
        if(p3d.z <= 0) continue;
        // if(p3d.intensity <= 20) continue; // filter dust
        int x = (p3d.x * fx) / p3d.z + tx;
        int y = (p3d.y * fy) / p3d.z + ty;
        if(x >= 0 && y >= 0 && x < point_index_in_camera.cols && y < point_index_in_camera.rows){
            // auto index = point_index_in_camera.at<uint16_t>(y, x);
            auto indexs = point_index_in_camera.at<cv::Vec2w>(y, x);
            if(indexs[0] == 0 || camera_cloud->points[indexs[0]].z > p3d.z){ // 保留近处点
                // point_index_in_camera.at<uint16_t>(y, x) = i;
                point_index_in_camera.at<cv::Vec2w>(y, x)[0] = i;
                if(pcl_cloud->points[i].z < 1){ // 第二个index保存小于1m的点云
                    point_index_in_camera.at<cv::Vec2w>(y, x)[1] = i;
                }
                // auto color = index == 0 ? cv::Scalar(0, 0, 255) : cv::Scalar(255, 255, 0);
                // cv::circle(cv_image, cv::Point(x, y), 1, color, -1);
            }
        }
    }
    std::cout<<" pcl2camera with "<<camera_cloud->size()<<" points: "<<double(clock()-start_)/CLOCKS_PER_SEC<<"s"<<std::endl;  //输出时间（单位：ｓ）
    // 使用dust-box去除部分点云index
    // TODO

    //循环每个目标
    // start_ = clock();
    for( int mm = 0; mm < objs.size(); mm++)
    {
        // g_Obj_count = mm+1;
        auto & obj = objs[mm];
        if( 0 == obj.bDetectType ){
            Process_Instance_Objects(obj, point_index_in_camera, pcl_cloud, vGrid);
        }
        else{
            Process_Segmantic_Objects(obj, point_index_in_camera, pcl_cloud, vGrid);
        }
    }
    // 将静态目标投影到栅格地图中
    pcl::PointXYZI bev_point;
    cv::Point2f pt2f;
    for(auto& bevObj: vGrid.vInsObjs){
        if(std::find(perception::camera::StaticTypes.begin(), perception::camera::StaticTypes.end(), bevObj.names)
            != perception::camera::StaticTypes.end()
        ){
            uchar objcls = (perception::camera::name2type.find(bevObj.names) == perception::camera::name2type.end() ? 
                perception::camera::Perception_Default_Classification : perception::camera::name2type[bevObj.names]);
            cv::Vec3b color = cv::Vec3b(bevObj.color.b, bevObj.color.g, bevObj.color.r);
            for(auto&p : bevObj.vPoints){
                pt2f = BEV_GridMap::convertmap_2_3d(p.x, p.y);
                bev_point.x = pt2f.x;
                bev_point.y = pt2f.y;
                bev_point.z = 0;
                bev_point.intensity = (float)objcls;
                vGrid.m_imgBEV_static.at<cv::Vec3b>(p.y, p.x) = color;
                vGrid.m_pointcloud_static_class.points.emplace_back(bev_point);
            }
        }
    }
    return 0;
};


int Visione_3D::Process_Segmantic_Objects(object_Seg_info& obj, const cv::Mat& indices, Cloud::Ptr& pcl_cloud, BEV_GridMap& vGrid){
    cv::Scalar objColor = obj.color;
    const cv::Rect& rc = obj.rc;
    obj.valid = 1;
    uchar objcls = (perception::camera::name2type.find(obj.name) == perception::camera::name2type.end() ? 
        perception::camera::Perception_Default_Classification : perception::camera::name2type[obj.name]);

    int stepY = std::max(1, obj.mask.rows/200);
    int stepX = std::max(1, obj.mask.cols/200);
    // int stepY = 1;
    // int stepX = 1;
    int m, n, ix, iy;
    unsigned short index; 
    cv::Vec3b color = cv::Vec3b(objColor[2], objColor[1], objColor[0]);

    pcl::PointXYZI p;
    cv::Point2f pt2f;
    for( int j = 0; j < obj.mask.rows; j+=stepY)
    {
        for(int i = 0; i < obj.mask.cols; i+=stepX) 
        {
            m = rc.x + i;
            n = rc.y + j;
            // index = indices.at<uint16_t>(n,m);
            index = indices.at<cv::Vec2w>(n,m)[0];
            if(0 == index || 0 == obj.mask.at<uchar>(j,i) ){
                continue;
            }
            auto& p3d = pcl_cloud->points[index];
            ix = int(p3d.y/BEV_GRID_RESOLUTION + BEV_GridMap::m_nCenterX);
            iy = int(p3d.x/BEV_GRID_RESOLUTION + BEV_GridMap::m_nCenterY);
            if( ix >= BEV_IAGE_WIDTH || ix < 0 || 
                iy >= BEV_IAGE_HEIGHT || iy < 0 )
            {
                ix = 0; iy = 0;
            }
            
            if( ix !=0 && iy != 0)
            {

                vGrid.m_imgBEV_static.at<cv::Vec3b>(iy, ix) = color;
                // vGrid.m_imgBev_Class.at<uchar>(iy,ix) = objcls;
                pt2f = BEV_GridMap::convertmap_2_3d(ix, iy);
                p.x = pt2f.x;
                p.y = pt2f.y;
                p.z = 0;
                p.intensity = (float)objcls;
                vGrid.m_pointcloud_static_class.points.emplace_back(p);
            }              
        }
    }
    return 0;
};


int Visione_3D::Process_Instance_Objects(object_Seg_info& obj, const cv::Mat& indices, Cloud::Ptr& pcl_cloud, BEV_GridMap& vGrid){
    cv::Scalar objColor = obj.color;
    const cv::Rect& rc = obj.rc;
    cv::Mat objBin = cv::Mat::zeros(vGrid.m_imgBEV_static.size(), CV_8UC1);
    cv::Mat objBinCount = cv::Mat::zeros(vGrid.m_imgBEV_static.size(), CV_8UC1);
    std::vector<cv::Point3f> points3d;

    int stepY = 1 ; //max(1, obj.mask.rows/20);
    int stepX = 1 ; //max(1, obj.mask.cols/40);
    int m, n, ix, iy;
    uint16_t index; 
    cv::Vec3b color = cv::Vec3b(objColor[2], objColor[1], objColor[0]);
    BEV_COLOR uColor; 
    uColor.r = objColor[0]; uColor.g = objColor[1]; uColor.b = objColor[2];
    
    int nValidNum = 0;
    int objY1 = objBin.rows, objY2 = 0;
    int objX1 = objBin.cols, objX2 = 0;

    //目标 mask
    // clock_t start_ = clock();
    for( int j = 0; j < obj.mask.rows; j+=stepY)
    {
        for(int i = 0; i < obj.mask.cols; i+=stepX) 
        {
            m = rc.x + i;
            n = rc.y + j;
            auto indexs = indices.at<cv::Vec2w>(n,m);
            index = indexs[obj.name == "stone" ? 1 : 0];
            if( 0 == obj.mask.at<uchar>(j,i) || 0 == index ){
                //not in mask or dont have pcl-point
                continue;
            }
            
            auto& p3d = pcl_cloud->points[index];
            ix = int(p3d.y/BEV_GRID_RESOLUTION + BEV_GridMap::m_nCenterX);
            iy = int(p3d.x/BEV_GRID_RESOLUTION + BEV_GridMap::m_nCenterY);
            if( ix >= BEV_IAGE_WIDTH || ix < 0 || 
                iy >= BEV_IAGE_HEIGHT || iy < 0 )
            {
                ix = 0; iy = 0;
            }
            
            if( ix !=0 && iy != 0)
            {
                objY1 = MIN(iy, objY1);
                objY2 = MAX(iy, objY2);    
                objX1 = MIN(ix, objX1);
                objX2 = MAX(ix, objX2);

                objBin.at<uchar>(iy, ix) = 255;
                objBinCount.at<uchar>(iy, ix)  = MIN(255, objBinCount.at<uchar>(iy, ix)+1);
                cv::Point3d p3d_(ix, iy, p3d.z);
                points3d.emplace_back(p3d_);
                nValidNum++;
            }              
        }
    }
    // std::cout<<" instance find table vision "<<double(clock()-start_)/CLOCKS_PER_SEC<<"s"<<std::endl;  //输出时间（单位：ｓ）

    // start_ = clock();
    //目标bev矩形区域
    cv::Rect objRc = cv::Rect(objX1, objY1, MIN(objBin.cols, objX2 + 1) - objX1,  MIN(objBin.rows, objY2 + 1) - objY1);
    // std::cout<<points3d.size()<<","<<nValidNum<<","<<objRc.width<<","<<objRc.height<<std::endl;
    if(nValidNum > 5 && objRc.width > 0 && objRc.height > 0)
    {
        InstanceBevObject insobj;
        insobj.rrc = getObjectAreaRect(objBin, objBinCount, objRc, insobj.vPoints, color, obj.name);
        
        // 静态目标根据高度差过滤误检
        // 过滤多余点
        bool filtered = false;
        // if(std::find(perception::camera::StaticTypes.begin(), perception::camera::StaticTypes.end(), obj.name)
        //     != perception::camera::StaticTypes.end())
        if(obj.name == "stone")
        {
            auto bundingRect = insobj.rrc.boundingRect2f();
            for(auto iter = points3d.begin(); iter != points3d.end();){
                bool in_rect = ((iter->x <= bundingRect.x+bundingRect.width) && (iter->x >= bundingRect.x) && 
                                (iter->y <= bundingRect.y+bundingRect.height) && (iter->y >= bundingRect.y));
                if(!in_rect){
                    iter = points3d.erase(iter);
                }else{
                    iter++;
                }
            }
            // 获得高低差
            float min_z = 1e5, max_z = -1e5;
            for(auto& p3d_: points3d){
                if(p3d_.z > max_z){
                    max_z = p3d_.z;
                }
                if(p3d_.z < min_z){
                    min_z = p3d_.z;
                }
            }
            filtered = (max_z - min_z < obstacle_height_threshold * 0.01);
        }
        // std::cout<<"size:"<<points3d.size()<<std::endl;
        // std::cout<<"x:"<<insobj.rrc.center.x<<",y:"<<insobj.rrc.center.y<<", max_z:"<<max_z<<", min_z:"<<min_z<<std::endl;
        // 高差大于阈值输出
        if(!filtered){
            if( insobj.rrc.size.height > 0 && insobj.rrc.size.width > 0) {
                insobj.rc = obj.rc;
                insobj.color = uColor;
                insobj.names = obj.name;
                insobj.fConfidence  = obj.fConfidence;
                vGrid.vInsObjs.push_back(insobj);
                obj.valid = 1;
            }
        }
    }
    else{ // validnum < 5; or rrc.width/height = 0, using depth
        return -1;
    }
    // std::cout<<" instance rc vision "<<double(clock()-start_)/CLOCKS_PER_SEC<<"s"<<std::endl;  //输出时间（单位：ｓ）
    return 0;
    
};



// 同时使用深度估计和点云投影来获取bev box
int Visione_3D::Process_objects(const cv::Mat& image, const cv::Mat& depth, Cloud::Ptr& pcl_cloud, std::vector<object_Seg_info>&objs, BEV_GridMap& vGrid){
    if(depth.empty()){
        return Process_objects(image, pcl_cloud, objs, vGrid);
    }
    if(pcl_cloud == nullptr){
        return Process_objects(image, depth, objs, vGrid);
    }
    if(objs.empty()){
        return -1;
    }

    clock_t start_ = clock();
    // 点云转换到相机
    Cloud::Ptr camera_cloud(new Cloud);
    Eigen::Matrix4d c2l = m_lidar2camera.inverse();
    pcl::transformPointCloud(*pcl_cloud, *camera_cloud, c2l);
    // 投影到图像中, 保存全部投影index和 高度小于1m的index，用做落石处理
    cv::Mat point_index_in_camera = cv::Mat::zeros(image.size(), CV_16UC2);// cv::Vec2w ushort
    float tx = m_matrixQ.at<float>(0, 2); 
    float ty = m_matrixQ.at<float>(1, 2); 
    float fx = m_matrixQ.at<float>(0, 0);
    float fy = m_matrixQ.at<float>(1, 1);
    // cv::Mat cv_image = image;
    for(int i=1; i<camera_cloud->size() && i < 65536; i++){
        auto& p3d = camera_cloud->points[i];
        if(p3d.z <= 0) continue;
        // if(p3d.intensity <= 20) continue; // filter dust
        int x = (p3d.x * fx) / p3d.z + tx;
        int y = (p3d.y * fy) / p3d.z + ty;
        if(x >= 0 && y >= 0 && x < point_index_in_camera.cols && y < point_index_in_camera.rows){
            // auto index = point_index_in_camera.at<uint16_t>(y, x);
            auto indexs = point_index_in_camera.at<cv::Vec2w>(y, x);
            if(indexs[0] == 0 || camera_cloud->points[indexs[0]].z > p3d.z){ // 保留近处点
                // point_index_in_camera.at<uint16_t>(y, x) = i;
                point_index_in_camera.at<cv::Vec2w>(y, x)[0] = i;
                if(pcl_cloud->points[i].z < 1){ // 第二个index保存小于1m的点云
                    point_index_in_camera.at<cv::Vec2w>(y, x)[1] = i;
                }
                // auto color = indexs[0] == 0 ? cv::Scalar(0, 0, 255) : cv::Scalar(255, 255, 0);
                // cv::circle(cv_image, cv::Point(x, y), 1, color, -1);
            }
        }
    }
    std::cout<<" pcl2camera with "<<camera_cloud->size()<<" points: "<<double(clock()-start_)/CLOCKS_PER_SEC<<"s"<<std::endl;  //输出时间（单位：ｓ）

    //循环每个目标
    // start_ = clock();
    //距离索引
    unsigned short * pTable =  m_Depth2Index;
    for( int mm = 0; mm < objs.size(); mm++)
    {
        // g_Obj_count = mm+1;
        auto & obj = objs[mm];
        if( 0 == obj.bDetectType ){
            int res = Process_Instance_Objects(obj, point_index_in_camera, pcl_cloud, vGrid);
            if(res == -1){ // valid points太少，使用深度估计
                // std::cout<<"using depth " << obj.name << "," <<obj.fConfidence<< std::endl;
                Process_Instance_Objects(obj, depth, pTable, vGrid);
            }
        }
        else{
            Process_Segmantic_Objects(obj, point_index_in_camera, pcl_cloud, vGrid);
        }
    }
    // 将静态目标投影到栅格地图中
    pcl::PointXYZI bev_point;
    cv::Point2f pt2f;
    for(auto& bevObj: vGrid.vInsObjs){
        if(std::find(perception::camera::StaticTypes.begin(), perception::camera::StaticTypes.end(), bevObj.names)
            != perception::camera::StaticTypes.end()
        ){
            uchar objcls = (perception::camera::name2type.find(bevObj.names) == perception::camera::name2type.end() ? 
                perception::camera::Perception_Default_Classification : perception::camera::name2type[bevObj.names]);
            cv::Vec3b color = cv::Vec3b(bevObj.color.b, bevObj.color.g, bevObj.color.r);
            for(auto&p : bevObj.vPoints){
                pt2f = BEV_GridMap::convertmap_2_3d(p.x, p.y);
                bev_point.x = pt2f.x;
                bev_point.y = pt2f.y;
                bev_point.z = 0;
                bev_point.intensity = (float)objcls;
                vGrid.m_imgBEV_static.at<cv::Vec3b>(p.y, p.x) = color;
                vGrid.m_pointcloud_static_class.points.emplace_back(bev_point);
            }
        }
    }
    return 0;


    
};

