/*
 * @Descripttion: 
 * @version: 
 * @Author: wxin
 * @Date: 2023-11-07 01:52:23
 * @email: xin.wang@waytous.com
 * @LastEditors: wxin
 * @LastEditTime: 2023-11-07 08:30:49
 */

#ifndef ROS_VISUAL_H_
#define ROS_VISUAL_H_

#include <vector>
#include <opencv2/opencv.hpp>
#include <pcl/point_cloud.h>
#include <pcl/point_types.h>

#include <cv_bridge/cv_bridge.h>
#include <sensor_msgs/PointCloud2.h>
#include <jsk_recognition_msgs/BoundingBoxArray.h>
#include <tf/transform_broadcaster.h>

// deepinfer
#include <common/common.h>
#include <common/file.h>

// vision3d
#include "vision_transform/vision_3d.h"



class RosVisualization{
public:
    RosVisualization(ros::NodeHandle &nodehandle, std::string frame_id="Lidar");

    
    void Visualization(BEV_GridMap& vGrid, cv::Mat& image, const std::vector<object_Seg_info>& objs);

    /**
     * @name: ShowBoundingBoxArray
     * @msg: 显示目标的BoundingBoxA框
     * @param {const std::vector<InstanceBevObject>&} bevObjs
     * @return {*}
     */
    int ShowBoundingBoxArray(const std::vector<InstanceBevObject>& bevObjs);

     /**
     * @name: ShowImage
     * @msg: 可视化图像
     * @param {cv::Mat&} image
     * @param {const std::vector<object_Seg_info>&} objs
     * @return {*}
     */
    void ShowImage(cv::Mat& image, const std::vector<object_Seg_info>& objs);


    /**
     * @name: ShowCloudPoints
     * @msg: 可视化点云
     * @param {const pcl::PointCloud<PointT> &} pt_cloud
     * @return {*}
     */
    template <typename PointT>
    void ShowCloudPoints(const pcl::PointCloud<PointT> &pt_cloud);


private:
    // ros::Publisher m_pubCloudPoint_3D;
    std::string current_frame_id = "Lidar";
    ros::Publisher m_pubCloudPoint_BEV;
    ros::Publisher m_pub_bounding_boxes;
    ros::NodeHandle m_nodehandle;
    ros::Publisher m_pub_image; 

};







#endif // ROS_VISUAL_H_

