/*
 * @Descripttion: 基础功能函数文件
 * @version: 
 * @Author: chengqingshui
 * @Date: 2023-03-24 17:49:15
 * @emal: qingshui.cheng@waytous.com
 * @LastEditors: wxin
 * @LastEditTime: 2023-11-07 02:34:13
 */
#ifndef COM_FUNCTION_H
#define COM_FUNCTION_H

#include <iostream>
#include <vector>

#include <opencv2/opencv.hpp>
#include <pcl/point_cloud.h>
#include <pcl/point_types.h>



/**
 * 按列连接距离较近的间隙
 * binImage: [in] 二值图像
 * nLength:  [in] 连接长度阈值
 * bConnectEdge: [in] 是否处理边界部分
*/
void ConnectSmallHeightGap(cv::Mat &binImage, int nLength, int bConnectEdge =1);


int Findlabel(const cv::Mat &label, int number, std::vector<std::vector<cv::Point>> &vvPt);


cv::Rect GetBundingRect(std::vector<cv::Point>& vPt);

void removeSmallArea(cv::Mat &imageBin, int nLen);

/**
 * 区域生长法分割图像
 * mat [in] 原始图像
 * seedThr [in] 种子点阈值  将 edgeThr<= 像素值<=nMaxvalue的值当作种子点
 * edgeThr [in] 区域生长边界阈值 分割区域内像素值  >=edgeThr
 * imgBin [out] 分割的二值图像
 * nMaxvalue [in] 分割像素值的最大阈值  超过此阈值的点将不被分割
*/
int AreaGrow_segment(cv::Mat& srcMat, int seedThr, int edgeThr, cv::Mat & imgBin, int nMaxvalue);


/**
 * 填充二值区域中的空洞
 * srcBw： [in]  输入图像
 * dstBw： [in/out] 输出图像
 * sz: [in] 小于sz尺寸的空洞将被填充
*/
void fillHole(const cv::Mat & srcBw, cv::Mat &dstBw, cv::Size sz);


/**
 * @name: changeImageToBev
 * @msg: 转换图像颜色到RGB点云    图像和点云空间需要预先分配好
 * @param {Mat&} imageRgb      输入图像
 * @param {PointCloud<PointXYZRGB>&} pointBEV  输入/输出点云
 * @return {*}
 */
int changeImageToBev(const cv::Mat& imageRgb, pcl::PointCloud<pcl::PointXYZRGB>& pointBEV);


int  KeepThrLargestAreaRect(cv::Mat& imgBin);


#endif 
