/*
 * @Descripttion: 
 * @version: 
 * @Author: wxin
 * @Date: 2023-09-03 03:14:28
 * @email: xin.wang@waytous.com
 * @LastEditors: wxin
 * @LastEditTime: 2023-10-11 02:48:24
 */

#ifndef UTILS_H_
#define UTILS_H_

#include <string>
#include <map>
#include <sys/time.h>
#include <vector>
#include <opencv2/opencv.hpp>
#include <Eigen/Dense>
#include <opencv2/core/eigen.hpp>
#include <yaml-cpp/yaml.h>

#include <common/file.h>
#include "undistort/camera_param.h"

namespace perception::camera{


struct ImageInferNodeParam{
    // Subscriber
    std::string rgb_sub_topic_name;
    std::string pointcloud_sub_topic_name;
    // Publisher
    std::string detection_pub_topic_name;
    // std::string static_gridmap_pub_topic_name;

    // publish-header
    std::string creator_id = "0000";
    std::string creator_name = "camera_bev_node";
    std::string sensor_frame_id = "camera_01";

    // model param
    std::string config_root_path;
    std::string rgb_config_path;
    int device = 0;
    int period_time = 50; // ms

    // visualization 是否可视化结果
    bool vis_res = true;
    std::string vis_frame_id = "Lidar";

    // 相机参数
    waytous::deepinfer::ios::CameraParamPtr cameraParam_ = nullptr;

    // 落石高差阈值 cm
    float obstacle_height_threshold = 30;
};


// bool ImageProto2CV(const eon::proto::sensor::Image& msg, cv::Mat& img);


bool readInferParam(ImageInferNodeParam& param, const std::string& param_path);


uint64_t GetMillSecondTimeStamp();

}



#endif //UTILS_H_



