/*
 * @Descripttion: 
 * @version: 
 * @Author: wxin
 * @Date: 2023-07-25 06:16:52
 * @email: xin.wang@waytous.com
 * @LastEditors: wxin
 * @LastEditTime: 2023-10-11 02:48:38
 */


#include "utils.h"


namespace perception::camera{




bool readInferParam(ImageInferNodeParam& param,  const std::string& param_path){

    auto node = YAML::LoadFile(param_path);

    param.rgb_sub_topic_name = node["rgb_sub_topic_name"].as<std::string>();
    param.pointcloud_sub_topic_name = node["pointcloud_sub_topic_name"].as<std::string>();

    param.detection_pub_topic_name = node["detection_pub_topic_name"].as<std::string>();

    param.creator_id = node["creator_id"].as<std::string>();
    param.creator_name = node["creator_name"].as<std::string>();
    param.sensor_frame_id = node["sensor_frame_id"].as<std::string>();

    param.config_root_path = node["config_root_path"].as<std::string>();
    if(!waytous::deepinfer::common::PathExists(param.config_root_path)){
        // eon::log::info() << "Error: param setting: " << param.config_root_path << " does not exist, node exit.";
        std::cout << "Error: param setting: " << param.config_root_path << " does not exist, node exit." << std::endl;
        return false;
    }
    param.rgb_config_path = node["rgb_config_path"].as<std::string>();
    param.device = node["device"].as<int>();
    param.period_time = node["period_time"].as<int>();

    param.vis_res = node["vis_res"].as<bool>();
    param.vis_frame_id = node["vis_frame_id"].as<std::string>();

    param.obstacle_height_threshold = node["obstacle_height_threshold"].as<float>();

    param.cameraParam_ = std::make_shared<waytous::deepinfer::ios::CameraParam>();
    param.cameraParam_->src_height_ = node["src_img_height"].as<int>();
    param.cameraParam_->src_width_ = node["src_img_width"].as<int>();
    param.cameraParam_->dst_height_ = node["dst_img_height"].as<int>();
    param.cameraParam_->dst_width_ = node["dst_img_width"].as<int>();

    // 内参
    std::vector<float> camera_intrinsic = node["camera_intrinsic"].as<std::vector<float>>();
    if(camera_intrinsic.size() != 9){
        // eon::log::info() << "Error: camera intrinsic number != 9, cannot init node.";
        std::cout << "Error: camera intrinsic number != 9, cannot init node." << std::endl;
        return false;
    }
    float fx =  float(param.cameraParam_->dst_width_) / float(param.cameraParam_->src_width_);
    float fy =  float(param.cameraParam_->dst_height_) / float(param.cameraParam_->src_height_);
    for(int i=0; i<9; i++){
        param.cameraParam_->camera_intrinsic(i) = camera_intrinsic[i];

        // 根据dst大小，生成新的内参矩阵
        if(i == 0 || i == 2){
            param.cameraParam_->new_camera_intrinsic(i) = camera_intrinsic[i] * fx;
        }else if (i == 4 || i == 5){
            param.cameraParam_->new_camera_intrinsic(i) = camera_intrinsic[i] * fy;
        }else{
            param.cameraParam_->new_camera_intrinsic(i) = camera_intrinsic[i];
        }
    }

    // 畸变系数
    auto effs = node["distortion_coefficients"].as<std::vector<float>>();
    int eff_size = effs.size();
    if(eff_size != 4 && eff_size != 5 && eff_size != 8 && eff_size != 12){
        // eon::log::info() << "Error: camera distortion coeff number != 4, 5, 8, 12, cannot init node.";
        std::cout << "Error: camera distortion coeff number != 4, 5, 8, 12, cannot init node." << std::endl;
        return false;
    }
    for(int i=0; i<14; i++){
        if(i < eff_size){
            param.cameraParam_->distortion_coefficients(i) = effs[i];
        }else{
            param.cameraParam_->distortion_coefficients(i) = 0;
        }
    }

    auto ex_param = node["camera2lidar_extrinsic"].as<std::vector<float>>();
    int ex_size = ex_param.size();
    if(ex_size != 16){
        // eon::log::info() << "Error: camera2lidar extrinsic number != 16, cannot init node.";
        std::cout << "Error: camera2lidar extrinsic number != 16, cannot init node." << std::endl;
        return false;
    }
    cv::Mat matTemp = cv::Mat::zeros(cv::Size(4, 4), CV_32FC1);
    for(int i=0; i<16; i++){
        matTemp.at<float>(i) = ex_param[i];
    }
    cv::cv2eigen(matTemp, param.cameraParam_->camera2lidar_extrinsic);
    return true;

};


uint64_t GetMillSecondTimeStamp()
{
    struct timeval curTime;
    gettimeofday(&curTime, NULL);
    uint64_t milli = curTime.tv_sec*1000 + curTime.tv_usec / 1000;
    return milli;
}


}









