/*
 * @Descripttion: 
 * @version: 
 * @Author: wxin
 * @Date: 2023-09-03 07:59:23
 * @email: xin.wang@waytous.com
 * @LastEditors: wxin
 * @LastEditTime: 2023-09-03 12:24:49
 */

#ifndef DEEPINFER_PREPROCESS_UNDISTORT_PARAM_H_
#define DEEPINFER_PREPROCESS_UNDISTORT_PARAM_H_

#include <memory>
#include <string>
#include <algorithm>
#include <Eigen/Dense>
#include <npp.h>

#include <common/file.h>
#include <interfaces/base_unit.h>
#include <base/image.h>
#include <libs/ios/camera_ios.h>

#include "undistort/camera_param.h"

namespace waytous {
namespace deepinfer {
namespace preprocess {


class UndistortV2: public interfaces::BaseUnit{

public:
    /**
     * @name: Init
     * @msg: 初始化畸变矫正节点
     * @param {Node&} node 默认接口是从node传参
     * @param {BaseIOMapPtr} pmap 保存模型pipeline的map
     * @return {bool} 是否初始化成功
     */
    bool Init(YAML::Node& node, interfaces::BaseIOMapPtr pmap) override;

    /**
     * @name: Exec
     * @msg: 推理，执行畸变矫正
     * @return {bool} 是否正常执行
     */    
    bool Exec() override;

    /**
     * @name: Name
     * @msg: 节点名称
     * @return {std::string}
     */    
    std::string Name() override;

    /**
     * @name: InitParam
     * @msg: 从pmap中获取参数用于初始化畸变矫正
     * @return {bool} 是否回去参数成功
     */    
    bool InitParam();

    /**
     * @name: InitUndistortRectifyMap
     * @msg: 初始化畸变矫正映射map
     * @return {*}
     */    
    void InitUndistortRectifyMap();

    UndistortV2(){};
    ~UndistortV2(){};

public:
    // 畸变矫正参数
    ios::CameraParamPtr param_ = nullptr;
    // 畸变矫正xy的映射map
    base::Blob<float> d_mapx_;
    base::Blob<float> d_mapy_;
    // 畸变矫正后图像
    base::Image8UPtr dst_img;
    bool inited_ = 0;

};

DEEPINFER_REGISTER_UNIT(UndistortV2);


}  // namespace preprocess
}  // namespace deepinfer
}  // namespace waytous

#endif //DEEPINFER_PREPROCESS_UNDISTORT_PARAM_H_



