/*
 * @Descripttion: 
 * @version: 
 * @Author: wxin
 * @Date: 2023-09-03 08:10:01
 * @email: xin.wang@waytous.com
 * @LastEditors: wxin
 * @LastEditTime: 2023-09-03 09:36:43
 */

#ifndef DEEPINFER_CAMERA_PARAM_H_
#define DEEPINFER_CAMERA_PARAM_H_

#include <vector>
#include <string>
#include <Eigen/Dense>
#include <common/common.h>
#include <interfaces/base_io.h>


namespace waytous {
namespace deepinfer {
namespace ios {


class CameraParam: public interfaces::BaseIO{

public:
    // 相机内参
    Eigen::Matrix<float, 3, 3, Eigen::RowMajor> camera_intrinsic;
    Eigen::Matrix<float, 3, 3, Eigen::RowMajor> new_camera_intrinsic;
    Eigen::Matrix<float, 1, 14, Eigen::RowMajor> distortion_coefficients;

    // 相机外参
    Eigen::Matrix4d camera2lidar_extrinsic;

    // Camera原始图像尺寸和矫正后尺寸
    int src_width_ = 0;
    int src_height_ = 0;
    int dst_width_ = 0;    
    int dst_height_ = 0; 
};
using CameraParamPtr = std::shared_ptr<CameraParam>;

}  // namespace ios
}  // namespace deepinfer
}  // namespace waytous

#endif
