/*
 * @Descripttion: 
 * @version: 
 * @Author: wxin
 * @Date: 2023-09-03 01:23:43
 * @email: xin.wang@waytous.com
 * @LastEditors: wxin
 * @LastEditTime: 2023-09-27 06:26:04
 */

#include <string>
#include <opencv2/opencv.hpp>

#include <ros/ros.h>
#include <glog/logging.h>

#include <interfaces/base_model.h>
#include "sensor_manager.h"
#include "vision_transform/vision_3d.h"


int main(int argc, char** argv)
{
    google::InitGoogleLogging("WARN");

    ros::init(argc, argv, "vision_bev_node");
	ros::NodeHandle nh;

    // 读取参数
    perception::camera::ImageInferNodeParam param;
    char buffer[1024];
    auto r = getcwd(buffer, 1024);
    std::string root = std::string(buffer) + "/";
    std::string param_path = root + "src/camera_bev_infer/configs/CameraBevParam.yaml";
    if(!waytous::deepinfer::common::PathExists(param_path)){
        std::cout << param_path << " does not exist." << std::endl;
        return 0;
    }
    if(!perception::camera::readInferParam(param, param_path)){
        // eon::log::info() << "Error: node param setting error, node exit.";
        std::cout<< "Error: node param setting error, node exit." << std::endl;
        return 0;
    };

    // int rate = 1000 / param.period_time;
    // ros::Rate loop_rate(rate);
    while(ros::ok()){
        // 初始化sensor manager
        auto manager = std::make_shared<perception::camera::sensorManager>(nh, param);
        ros::spin();
        // ros::spinOnce();
        // loop_rate.sleep();
    };

    return 0;
}