/*
 * @Descripttion: 
 * @version: 
 * @Author: wxin
 * @Date: 2023-09-03 03:14:28
 * @email: xin.wang@waytous.com
 * @LastEditors: wxin
 * @LastEditTime: 2023-09-21 09:11:08
 */

#ifndef COMMON_MAP_H_
#define COMMON_MAP_H_

#include <string>
#include <map>
#include <vector>
#include <opencv2/opencv.hpp>

#include "waytous_perception_msgs/Object.h"


namespace perception::camera{

static const int Perception_Default_Classification = waytous_perception_msgs::Object::TYPE_UNKNOWN;
static const int Perception_Default_SubClassification = waytous_perception_msgs::Object::SUBTYPE_UNKNOWN;
static const cv::Scalar Perception_Default_Color = cv::Scalar(255, 255, 255);
static const int Perception_Default_Maxsize = 100; // m

static std::map<std::string, int> name2type = {
    {"pedestrian", waytous_perception_msgs::Object::TYPE_PEDESTRIAN},
    {"two_wheel", waytous_perception_msgs::Object::TYPE_BICYCLE},
    {"car", waytous_perception_msgs::Object::TYPE_VEHICLE},
    {"truck", waytous_perception_msgs::Object::TYPE_VEHICLE},
    {"construction_machine", waytous_perception_msgs::Object::TYPE_MACHINERY},
    {"vehicle", waytous_perception_msgs::Object::TYPE_VEHICLE},
    {"fence", waytous_perception_msgs::Object::TYPE_UNKNOWN_STATIC},
    {"stone", waytous_perception_msgs::Object::TYPE_UNKNOWN_STATIC},
    {"dust", waytous_perception_msgs::Object::TYPE_UNKNOWN_MOVABLE},
    {"cone", waytous_perception_msgs::Object::TYPE_UNKNOWN_STATIC},
    {"road", waytous_perception_msgs::Object::TYPE_UNKNOWN_STATIC},
    {"sky", waytous_perception_msgs::Object::TYPE_UNKNOWN_STATIC},
    // other maybe used in future
    {"curb", waytous_perception_msgs::Object::TYPE_UNKNOWN_STATIC}, // 路沿
    {"puddle", waytous_perception_msgs::Object::TYPE_UNKNOWN_STATIC}, //水坑
    {"pit", waytous_perception_msgs::Object::TYPE_UNKNOWN_STATIC}, // 坑
    {"rut", waytous_perception_msgs::Object::TYPE_UNKNOWN_STATIC} // 车辙
};


// all subtype may not correct
static std::map<std::string, int> name2subtype = {
    {"pedestrian", waytous_perception_msgs::Object::SUBTYPE_PEDESTRIAN},
    {"two_wheel", waytous_perception_msgs::Object::SUBTYPE_MOTORCYCLIST},
    {"car", waytous_perception_msgs::Object::SUBTYPE_CAR},
    {"truck", waytous_perception_msgs::Object::SUBTYPE_TRUCK},
    {"construction_machine", waytous_perception_msgs::Object::SUBTYPE_DOZER},
    {"vehicle", waytous_perception_msgs::Object::SUBTYPE_TRUCK},
    {"fence", waytous_perception_msgs::Object::SUBTYPE_UNKNOWN_STATIC},
    {"stone", waytous_perception_msgs::Object::SUBTYPE_TRAFFIC_CONE},
    {"dust", waytous_perception_msgs::Object::SUBTYPE_UNKNOWN_MOVABLE},
    {"cone", waytous_perception_msgs::Object::SUBTYPE_TRAFFIC_CONE},
    {"road", waytous_perception_msgs::Object::SUBTYPE_UNKNOWN_STATIC},
    {"sky", waytous_perception_msgs::Object::SUBTYPE_UNKNOWN_STATIC},
    // other maybe used in future
    {"curb", waytous_perception_msgs::Object::SUBTYPE_UNKNOWN_STATIC}, // 路沿
    {"puddle", waytous_perception_msgs::Object::SUBTYPE_UNKNOWN_STATIC}, //水坑
    {"pit", waytous_perception_msgs::Object::SUBTYPE_UNKNOWN_STATIC}, // 坑
    {"rut", waytous_perception_msgs::Object::SUBTYPE_UNKNOWN_STATIC} // 车辙
};

/*
static const eon::proto::perception::Classification_Type Perception_Default_Classification = eon::proto::perception::Classification::OBSTACLE_UNKNOWN;
static const eon::proto::perception::Classification_SubType Perception_Default_SubClassification = eon::proto::perception::Classification::SUB_STATIC_UNKNOWN;
static const cv::Scalar Perception_Default_Color = cv::Scalar(255, 255, 255);
static const int Perception_Default_Maxsize = 100; // m


static std::map<std::string, eon::proto::perception::Classification_Type> name2type = {
    {"pedestrian", eon::proto::perception::Classification::PERSON},
    {"two_wheel", eon::proto::perception::Classification::NON_VEHICLE},
    {"car", eon::proto::perception::Classification::CAR},
    {"truck", eon::proto::perception::Classification::TRUCK},
    {"construction_machine", eon::proto::perception::Classification::CONSTRUCTION_MACHINERY},
    {"fence", eon::proto::perception::Classification::FENCE},
    {"stone", eon::proto::perception::Classification::STONE},
    {"dust", eon::proto::perception::Classification::UNKNOWN},
    {"cone", eon::proto::perception::Classification::CONE},
    {"road", eon::proto::perception::Classification::ROAD},
    {"sky", eon::proto::perception::Classification::UNKNOWN},
    // other maybe used in future
    {"curb", eon::proto::perception::Classification::CURB}, // 路沿
    {"puddle", eon::proto::perception::Classification::PUDDLE}, //水坑
    {"pit", eon::proto::perception::Classification::OBSTACLE_UNKNOWN}, // 坑
    {"rut", eon::proto::perception::Classification::OBSTACLE_UNKNOWN} // 车辙
};


// all subtype may not correct
static std::map<std::string, eon::proto::perception::Classification_SubType> name2subtype = {
    {"pedestrian", eon::proto::perception::Classification::SUB_PEDESTRIAN},
    {"two_wheel", eon::proto::perception::Classification::SUB_MOTORCYCLE},
    {"car", eon::proto::perception::Classification::SUB_CAR},
    {"truck", eon::proto::perception::Classification::SUB_WIDE_BODY_TRUCK},
    {"construction_machine", eon::proto::perception::Classification::SUB_DOZER},
    {"fence", eon::proto::perception::Classification::SUB_FENCE},
    {"stone", eon::proto::perception::Classification::SUB_STONE},
    {"dust", eon::proto::perception::Classification::SUB_MOVABLE_UNKNOWN},
    {"cone", eon::proto::perception::Classification::SUB_TRAFFIC_CONE},
    {"road", eon::proto::perception::Classification::SUB_STATIC_UNKNOWN},
    {"sky", eon::proto::perception::Classification::SUB_STATIC_UNKNOWN},
    // other maybe used in future
    {"curb", eon::proto::perception::Classification::SUB_STATIC_UNKNOWN}, // 路沿
    {"puddle", eon::proto::perception::Classification::SUB_STATIC_UNKNOWN}, //水坑
    {"pit", eon::proto::perception::Classification::SUB_STATIC_UNKNOWN}, // 坑
    {"rut", eon::proto::perception::Classification::SUB_STATIC_UNKNOWN} // 车辙
};
*/

static std::map<std::string, cv::Scalar> name2color = {
    {"pedestrian", cv::Scalar(0, 0, 128)},
    {"two_wheel", cv::Scalar(0, 255, 128)},
    {"car", cv::Scalar(0, 255, 255)},
    {"truck", cv::Scalar(0, 128, 0)},
    {"construction_machine", cv::Scalar(0, 255, 0)},
    {"vehicle", cv::Scalar(0, 255, 0)},
    {"fence", cv::Scalar(128, 255, 0)},
    {"stone", cv::Scalar(255, 0, 255)},
    {"dust", cv::Scalar(255, 0, 0)},
    {"cone", cv::Scalar(0, 0, 255)},
    {"road", cv::Scalar(0, 128, 128)},
    {"sky", cv::Scalar(0, 128, 255)},
    // other maybe used in future
    {"curb", cv::Scalar(255, 255, 255)}, // 路沿
    {"puddle", cv::Scalar(255, 255, 255)}, //水坑
    {"pit", cv::Scalar(255, 255, 255)}, // 坑
    {"rut", cv::Scalar(255, 255, 255)} // 车辙
};


static std::map<std::string, int> name2max_size = {
    {"pedestrian", 1},
    {"two_wheel", 2},
    {"car", 10},
    {"truck", 10},
    {"construction_machine", 15},
    {"vehicle", 10},
    {"fence", 5},
    {"stone", 2},
    {"dust", Perception_Default_Maxsize},
    {"cone", 1},
    {"road", Perception_Default_Maxsize},
    {"sky", Perception_Default_Maxsize},
    // other maybe used in future
    {"curb", Perception_Default_Maxsize}, // 路沿
    {"puddle", 10}, //水坑
    {"pit", 10}, // 坑
    {"rut", 10} // 车辙
};

static std::vector<std::string> VehicleTypes = {"car", "truck", "construction_machine", "vehicle"};
static std::vector<std::string> StaticTypes = {"fence", "stone", "cone", "road", "curb", "puddle", "pit", "rut"};



}



#endif //COMMON_MAP_H_



