/*
 * @Descripttion: 
 * @version: 
 * @Author: wxin
 * @Date: 2023-09-03 02:07:48
 * @email: xin.wang@waytous.com
 * @LastEditors: wxin
 * @LastEditTime: 2023-09-21 09:35:09
 */


#ifndef CAMERAFRAME_H
#define CAMERAFRAME_H

#include <memory>
#include <std_msgs/Header.h>
#include <libs/ios/detection.h>
#include <libs/ios/semantic.h>
#include <libs/ios/depth.h>

#include "vision_transform/vision_3d.h"
#include "utils.h"


namespace perception::camera{
class cameraFrame
{
public:

    /**
     * @name: setImageSrc
     * @msg: 设置图像数据，更新img_width和img_height
     * @param : {cv:Mat&} src 源图像
     * @return {*}
     */
    void setImageSrc(cv::Mat& src){
        img_src_ = src;
        img_width = img_src_.cols;
        img_height = img_src_.rows;
    }
    
    /**
     * @name: setDetections
     * @msg: 获取图像实例分割结果，并进行resize到需要投影的尺寸
     * @param {ios::Detection2DsPtr} dets 模型输出实例分割结果
     * @return {*}
     */
    void setDetections(waytous::deepinfer::ios::Detection2DsPtr dets);

    /**
     * @name: setSemantics
     * @msg: 获取图像语义分割结果，并进行resize到需要投影的尺寸
     * @param {ios::SemanticsPtr} sems 模型输出语义分割结果
     * @return {*}
     */
    void setSemantics(waytous::deepinfer::ios::SemanticsPtr sems);

    /**
     * @name: setDepth
     * @msg: 获取深度估计结果，并进行resize到需要投影的尺寸
     * @param {ios::DepthPtr} depth 模型输出深度估计结果
     * @return {*}
     */
    void setDepth(waytous::deepinfer::ios::DepthPtr depth);

    /**
     * @name: time_valid
     * @msg: 判断当前时间和最新结果的间隔是否大于阈值，大于阈值不会进行输出
     * @param 
     * @return {bool}
     */
    inline bool time_valid()
    {   
        int64_t tm_now= GetMillSecondTimeStamp();
        return  abs(tm_now - timestamp_sys_) < timevalid_interval_ ;
    }
    
public:
    int64_t timestamp_ = 0;
    int64_t timestamp_sys_ = 0;  //接收到消息的系统时间
    int64_t timevalid_interval_ = 200;  //帧有效时间, ms
    std_msgs::Header sensor_header; // 传感器的header
    std::string cameraName; // 相机名称
    std::vector<object_Seg_info> objs_; // 保存当前帧模型输出结果，包含实例分割和语义分割
    cv::Mat depth_; // 当前帧输出深度图
    cv::Mat img_src_; // 当前帧被畸变矫正后的图像，用做可视化
    int img_width, img_height;

    // std::shared_ptr<eon::proto::localization::LocalizationData> self_loc_ = nullptr; // 模型推理前的获取的定位信息
};

typedef std::shared_ptr<cameraFrame> cameraFramePtr;
typedef std::shared_ptr<const cameraFrame> cameraFrameConstPtr;
}




#endif  //CAMERAFRAME_H
