/*
 * @Descripttion: 
 * @version: 
 * @Author: wxin
 * @Date: 2023-09-03 02:02:14
 * @email: xin.wang@waytous.com
 * @LastEditors: wxin
 * @LastEditTime: 2023-09-05 07:20:37
 */

#include "camera_frame.h"

namespace perception::camera{


/**
 * @name: setDetections
 * @msg: 获取图像实例分割结果，并进行resize到需要投影的尺寸
 * @param {ios::Detection2DsPtr} dets 模型输出实例分割结果
 * @return {*}
 */
void cameraFrame::setDetections(waytous::deepinfer::ios::Detection2DsPtr dets){

    for(auto& det: dets->detections){
        object_Seg_info obj;
        obj.labelIdx = det->class_label;
        obj.name = det->class_name;
        obj.fConfidence = det->confidence;
        obj.rc = cv::Rect(det->x1, det->y1, det->x2 - det->x1, det->y2 - det->y1);
        obj.color = name2color.find(det->class_name) == name2color.end() ? Perception_Default_Classification : name2color[det->class_name];
        obj.bDetectType = 0; // 0表示实例分割结果
        // 将mask resize到框大小的尺寸
        cv::resize(det->mask_ptr->decode(), obj.mask, cv::Size(obj.rc.width, obj.rc.height), 0, 0, cv::INTER_NEAREST);
        objs_.push_back(obj);
    }
};


/**
 * @name: setSemantics
 * @msg: 获取图像语义分割结果，并进行resize到需要投影的尺寸
 * @param {ios::SemanticsPtr} sems 模型输出语义分割结果
 * @return {*}
 */
void cameraFrame::setSemantics(waytous::deepinfer::ios::SemanticsPtr sems){
    for(auto& seg: sems->semantic_segs){
        if(seg->class_name == "sky"){ // delete sky
            continue;
        }
        object_Seg_info obj;
        obj.labelIdx = seg->class_label;
        obj.name = seg->class_name;
        // std::cout<<img_width<<","<<img_height<<std::endl;
        obj.rc = cv::Rect(0, 0, img_width, img_height);
        obj.color = name2color.find(seg->class_name) == name2color.end() ? Perception_Default_Classification : name2color[seg->class_name];
        obj.bDetectType = 1;// 1表示语义分割结果
        // 将mask resize到图像大小的尺寸
        cv::resize(seg->mask_ptr->decode(), obj.mask, cv::Size(img_width, img_height), 0, 0, cv::INTER_NEAREST);
        objs_.push_back(obj);
    }

};


/**
 * @name: setDepth
 * @msg: 获取深度估计结果，并进行resize到需要投影的尺寸
 * @param {ios::DepthPtr} depth 模型输出深度估计结果
 * @return {*}
 */
void cameraFrame::setDepth(waytous::deepinfer::ios::DepthPtr depth){
    auto& dmat = depth->depth;
    cv::Mat temp;
    cv::resize(dmat, temp, cv::Size(img_width, img_height), 0, 0, cv::INTER_NEAREST);
    // 模型输出为0-1，需要进行缩放256倍
    temp =  temp * 256; 
    temp.convertTo(depth_, CV_16U);
};


}














