
#include "libs/trackers/track.h"


namespace waytous{
namespace deepinfer{
namespace tracker{

Track::Track(ios::Det2DPtr obj)
{
    obj_ = obj->copy();
	_tlwh.resize(4);
    _tlwh[0] = obj->x1;
    _tlwh[1] = obj->y1;
    _tlwh[2] = obj->x2 - _tlwh[0];
    _tlwh[3] = obj->y2 - _tlwh[1];

	is_activated = false;
	track_id = 0;
	state = TrackState::New;
	
	tlwh.resize(4);
	tlbr.resize(4);

	static_tlwh();
	static_tlbr();
	frame_id = 0;
	tracklet_len = 0;
	start_frame = 0;
}
Track::~Track()
{
}

void Track::activate(KalmanFilter &kalman_filter, int frame_id)
{
	this->kalman_filter = kalman_filter;
	this->track_id = this->next_id();
    this->obj_->track_id = this->track_id;

	std::vector<float> _tlwh_tmp(4);
	_tlwh_tmp[0] = this->_tlwh[0];
	_tlwh_tmp[1] = this->_tlwh[1];
	_tlwh_tmp[2] = this->_tlwh[2];
	_tlwh_tmp[3] = this->_tlwh[3];
	std::vector<float> xyah = tlwh_to_xyah(_tlwh_tmp);
	DETECTBOX xyah_box;
	xyah_box[0] = xyah[0];
	xyah_box[1] = xyah[1];
	xyah_box[2] = xyah[2];
	xyah_box[3] = xyah[3];
	auto mc = this->kalman_filter.initiate(xyah_box);
	this->mean = mc.first;
	this->covariance = mc.second;

	static_tlwh();
	static_tlbr();

	this->tracklet_len = 0;
	this->state = TrackState::Tracked;
	if (frame_id == 1)
	{
		this->is_activated = true;
	}
	//this->is_activated = true;
	this->frame_id = frame_id;
	this->start_frame = frame_id;
}

void Track::re_activate(Track &new_track, int frame_id, bool new_id)
{
	std::vector<float> xyah = tlwh_to_xyah(new_track.tlwh);
	DETECTBOX xyah_box;
	xyah_box[0] = xyah[0];
	xyah_box[1] = xyah[1];
	xyah_box[2] = xyah[2];
	xyah_box[3] = xyah[3];
	auto mc = this->kalman_filter.update(this->mean, this->covariance, xyah_box);
	this->mean = mc.first;
	this->covariance = mc.second;

	static_tlwh();
	static_tlbr();

	// this->tracklet_len = 0;
	this->tracklet_len++;
	this->state = TrackState::Tracked;
	this->is_activated = true;
	this->frame_id = frame_id;
	if (new_id){
		this->track_id = next_id();
        this->obj_->track_id = this->track_id;
    }

    // update obj_
    this->obj_->update(new_track.obj_);
    this->obj_->update(tlbr);
}

void Track::update(Track &new_track, int frame_id)
{
	this->frame_id = frame_id;
	this->tracklet_len++;

	std::vector<float> xyah = tlwh_to_xyah(new_track.tlwh);
	DETECTBOX xyah_box;
	xyah_box[0] = xyah[0];
	xyah_box[1] = xyah[1];
	xyah_box[2] = xyah[2];
	xyah_box[3] = xyah[3];

	auto mc = this->kalman_filter.update(this->mean, this->covariance, xyah_box);
	this->mean = mc.first;
	this->covariance = mc.second;

	static_tlwh();
	static_tlbr();

	this->state = TrackState::Tracked;
	this->is_activated = true;

	this->_tlwh = new_track._tlwh; // save current detection for vis mask

    // update obj_
    this->obj_->update(new_track.obj_);
    this->obj_->update(tlbr);

}

void Track::static_tlwh()
{
	if (this->state == TrackState::New)
	{
		tlwh[0] = _tlwh[0];
		tlwh[1] = _tlwh[1];
		tlwh[2] = _tlwh[2];
		tlwh[3] = _tlwh[3];
		return;
	}

	tlwh[0] = mean[0];
	tlwh[1] = mean[1];
	tlwh[2] = mean[2];
	tlwh[3] = mean[3];

	tlwh[2] *= tlwh[3];
	tlwh[0] -= tlwh[2] / 2;
	tlwh[1] -= tlwh[3] / 2;
}

void Track::static_tlbr()
{
	tlbr.clear();
	tlbr.assign(tlwh.begin(), tlwh.end());
	tlbr[2] += tlbr[0];
	tlbr[3] += tlbr[1];
}

std::vector<float> Track::tlwh_to_xyah(std::vector<float> tlwh_tmp)
{
	std::vector<float> tlwh_output = tlwh_tmp;
	tlwh_output[0] += tlwh_output[2] / 2;
	tlwh_output[1] += tlwh_output[3] / 2;
	tlwh_output[2] /= tlwh_output[3];
	return tlwh_output;
}

std::vector<float> Track::to_xyah()
{
	return tlwh_to_xyah(tlwh);
}

std::vector<float> Track::tlbr_to_tlwh(std::vector<float> &tlbr)
{
	tlbr[2] -= tlbr[0];
	tlbr[3] -= tlbr[1];
	return tlbr;
}

void Track::mark_lost()
{
	state = TrackState::Lost;
}

void Track::mark_removed()
{
	state = TrackState::Removed;
}

int Track::next_id()
{
	static int _count = 0;
	_count++;
	return _count;
}

int Track::end_frame()
{
	return this->frame_id;
}

void Track::multi_predict(std::vector<Track*> &tracks, KalmanFilter &kalman_filter)
{
	for (int i = 0; i < tracks.size(); i++)
	{
		if (tracks[i]->state != TrackState::Tracked)
		{
			tracks[i]->mean[7] = 0;
		}
		kalman_filter.predict(tracks[i]->mean, tracks[i]->covariance);
	}
}

} //namespace camera
} //namspace percpetion
} //namespace waytous

