

#include "libs/sources/camera_src.h"

namespace waytous {
namespace deepinfer {
namespace sources {


bool CameraSrc::Exec(){
    auto src_input = interfaces::GetIOPtr(inputNames[0]);
    auto src = std::dynamic_pointer_cast<ios::CameraSrcIn>(src_input);
    auto img = std::make_shared<base::Image8U>(base::Image8U(src->cv_img_));
    auto dst = std::make_shared<ios::CameraSrcOut>(ios::CameraSrcOut(img));
    interfaces::SetIOPtr(outputNames[0], dst);
    return true;
}


std::string CameraSrc::Name(){
    return "CameraSrc";
}

DEEPINFER_REGISTER_UNIT(CameraSrc);


}  // namespace sources
}  // namespace deepinfer
}  // namespace waytous




