#ifndef DEEPINFER_PREPROCESS_RESIZE_NORM_H_
#define DEEPINFER_PREPROCESS_RESIZE_NORM_H_

#include <cuda_runtime.h>
#include <cstdint>

#include "interfaces/base_unit.h"
#include "base/image.h"

#include "libs/sources/camera_src.h"
#include "libs/ios/normal_ios.h"
#include "libs/ios/camera_ios.h"

namespace waytous {
namespace deepinfer {
namespace preprocess {


struct AffineMatrix{
    float value[6];
};


class ResizeNorm: public interfaces::BaseUnit{

public:
    bool Init(YAML::Node& node, YAML::Node& globalParamNode) override;

    bool Exec() override;

    std::string Name() override;

protected:
    void resizeGPU(uint8_t* src, int src_width, int src_height, int step_width,
            float* dst, int dst_width, int dst_height, float* input_mean, float* input_std, 
            bool bgr, bool resizeFixAspectRatio, cudaStream_t stream);

public:
    cudaStream_t stream_;
    base::BlobPtr<float> dst, mean, std;
    bool useBGR = false;
};


}  // namespace preprocess
}  // namespace deepinfer
}  // namespace waytous

#endif
