#ifndef DEEPINFER_INSTANCE_MASK_H_
#define DEEPINFER_INSTANCE_MASK_H_


#include <string>
#include <memory>
#include <opencv2/opencv.hpp>

namespace waytous{
namespace deepinfer{
namespace ios{

class InstanceMask{
public:
    InstanceMask();

    InstanceMask(const InstanceMask* mask);

    InstanceMask(int width, int height, const std::string &rle_string);

    InstanceMask(const cv::Mat &map);

    InstanceMask(int width, int height, const char* data);

    InstanceMask(int width, int height, const int* cnts, int length);

    void update(const InstanceMask* mask);

    cv::Mat decode();

    void encode(const cv::Mat& map);

    void encode(const char* data);

    void encode(const int* cnts, int length);


public:
    int width;
    int height;
    std::string rle_string; // coco encode mask string
};
using InstanceMaskPtr = std::shared_ptr<InstanceMask>;


} //namespace ios
} //namspace deepinfer
} //namespace waytous

#endif

