#ifndef WAYTOUS_DEEPINFER_TASK_H_
#define WAYTOUS_DEEPINFER_TASK_H_

#include <string>
#include <opencv2/opencv.hpp>
#include <yaml-cpp/yaml.h>


namespace waytous{
namespace deepinfer{
namespace task{


class Task{
public:
    virtual ~Task() = default;

    virtual bool Init(const std::string& taskConfigPath);

    /*
        task input/output
    */
    virtual bool Infer() = 0;

    /*
        draw outputs on image
    */
    virtual void Visualize(cv::Mat& image) = 0;

    virtual cv::Scalar get_color(int idx);

public:
    YAML::Node taskNode;

};

} //namespace task
} //namspace deepinfer
} //namespace waytous


#endif
