#ifndef DEEPINFER_INTERFACES_BASE_MODEL_H_
#define DEEPINFER_INTERFACES_BASE_MODEL_H_

#include <string>
#include <vector>
#include <memory>
#include <yaml-cpp/yaml.h>

#include "common/log.h"
#include "common/register.h"
#include "common/file.h"
#include "base/image.h"

#include "interfaces/base_io.h"
#include "interfaces/base_unit.h"

namespace waytous {
namespace deepinfer {
namespace interfaces {


class BaseModel{

public:
    BaseModel() = default;
    virtual ~BaseModel() = default;
    virtual bool Init(std::string& configPath);

    // for camera image infer
    virtual bool Exec(std::vector<cv::Mat*> inputs, std::vector<BaseIOPtr>& outputs);
    virtual bool Exec(std::vector<base::Image8UPtr> inputs, std::vector<BaseIOPtr>& outputs);

    virtual std::string Name(){
        return "BaseModel";
    }
    
public:
    std::vector<std::string> inputNames;
    std::vector<std::string> outputNames;

};

DEEPINFER_REGISTER_REGISTERER(BaseModel);
#define DEEPINFER_REGISTER_MODELS(name) \
  DEEPINFER_REGISTER_CLASS(BaseModel, name)

}  // namespace interfaces
}  // namespace deepinfer
}  // namespace waytous


#endif


