#ifndef DEEPINFER_INTERFACES_BASE_IO_H_
#define DEEPINFER_INTERFACES_BASE_IO_H_

#include <string>
#include <vector>
#include <map>
#include <memory>

#include "common/log.h"

namespace waytous {
namespace deepinfer {
namespace interfaces {


class BaseIO{

public:
    BaseIO() = default;
    virtual ~BaseIO() = default;
};
using BaseIOPtr = std::shared_ptr<BaseIO>;


typedef std::map<std::string, BaseIOPtr> BaseIOMap;
static BaseIOMap GlobalIOMap;

BaseIOPtr GetIOPtr(std::string& ioName);

void SetIOPtr(std::string& ioName, BaseIOPtr src);


}  // namespace interfaces
}  // namespace deepinfer
}  // namespace waytous


#endif
