#ifndef DEEPINFER_COMMON_H_
#define DEEPINFER_COMMON_H_


#include <cublas_v2.h>
#include <cuda_runtime.h>
#include <iostream>
#include <assert.h>

#define BLOCK 512
#define iMAX(a, b) ((a) > (b) ? (a) : (b))
#define iMIN(a, b) ((a) > (b) ? (b) : (a))

#ifndef CUDA_CHECK
#define CUDA_CHECK(callstr)                                                                    \
    {                                                                                          \
        cudaError_t error_code = callstr;                                                      \
        if (error_code != cudaSuccess) {                                                       \
            std::cerr << "CUDA error " << error_code << " at " << __FILE__ << ":" << __LINE__; \
            assert(0);                                                                         \
        }                                                                                      \
    }
#endif


inline dim3 cudaGridSize(uint n, uint block)
{
    uint k = (n - 1) / block + 1;
    uint x = k ;
    uint y = 1 ;
    if (x > 65535 )
    {
        x = ceil(sqrt(x));
        y = (n - 1 )/(x * block) + 1;
    }
    dim3 d = {x, y, 1} ;
    return d;
}



#endif



