
#ifndef WAYTOUS_DEEPINFER_TASK_FUSION_H_
#define WAYTOUS_DEEPINFER_TASK_FUSION_H_

#include <Eigen/Core>
#include <opencv2/core/eigen.hpp>

#include "interfaces/base_task.h"
#include "models/camera_model.h"
#include "libs/ios/detection.h"

namespace waytous{
namespace deepinfer{
namespace task{


class TaskFusion: public interfaces::BaseTask{
public:

    bool Init(std::string& taskConfigPath) override;

    bool Exec(std::vector<cv::Mat*> inputs, std::vector<interfaces::BaseIOPtr>& outputs) override;
    void Visualize(cv::Mat* image, interfaces::BaseIOPtr outs) override;
    std::string Name() override;

public:
    std::shared_ptr<interfaces::BaseModel> model;
    std::string mainSrcName;

};

DEEPINFER_REGISTER_TASKS(TaskFusion);

} //namespace task
} //namspace deepinfer
} //namespace waytous


#endif








