
#include "tasks/task_fusion.h"

namespace waytous{
namespace deepinfer{
namespace task{


bool TaskFusion::Init(std::string& taskConfigPath){
    if(!interfaces::BaseTask::Init(taskConfigPath)){
        LOG_ERROR << "Init task fusion error";
        return false;
    };
    mainSrcName = taskNode["mainSrcName"].as<std::string>();
    std::string modelName = taskNode["modelName"].as<std::string>();
    std::string modelConfigPath = taskNode["modelConfigPath"].as<std::string>();

    model.reset(interfaces::BaseModelRegisterer::GetInstanceByName(modelName));
    if(!model->Init(modelConfigPath)){
        LOG_ERROR << "Init Fusion "<< modelName << " model init problem";
        return false;
    };
    return true;
}


bool TaskFusion::Exec(std::vector<cv::Mat*> inputs, std::vector<interfaces::BaseIOPtr>& outputs){
    if(!model->Exec(inputs, outputs)){
        LOG_ERROR << "Task fusion Exec error";
        return false;
    };
    return true;
}


void TaskFusion::Visualize(cv::Mat* image, interfaces::BaseIOPtr outs){
    auto mainSrc = std::dynamic_pointer_cast<ios::CameraSrcOut>(interfaces::GetIOPtr(mainSrcName));
    auto mainImage = mainSrc->img_ptr_->toCVMat();
    auto detections =  std::dynamic_pointer_cast<ios::Detection2Ds>(outs)->detections;
    cv::Mat realInstanceMask, colorInstance;
    for(auto& obj: detections){
        cv::Scalar color = get_color(obj->class_label * 100 + obj->track_id);
        cv::putText(mainImage, std::to_string(obj->track_id) + ":" + common::formatValue(obj->confidence, 2), 
                    cv::Point(obj->x1, obj->y1 - 5), 
                    0, 0.6, cv::Scalar(0, 0, 255), 2, cv::LINE_AA);
        
        cv::rectangle(mainImage, cv::Rect(obj->x1, obj->y1, 
                    obj->x2 - obj->x1, obj->y2 - obj->y1), color, 2);

        if(obj->mask_ptr != nullptr){
            cv::Mat instance_mask = obj->mask_ptr->decode();
            instance_mask.convertTo(instance_mask, CV_32FC1);
            cv::resize(instance_mask, realInstanceMask, mainImage.size());
            mainImage.copyTo(colorInstance);
            for(int i=0; i<realInstanceMask.rows; i++){
                for(int j=0; j<realInstanceMask.cols; j++){
                    if(realInstanceMask.at<float>(i, j) >= 0.5){
                        colorInstance.at<cv::Vec3b>(i, j) = cv::Vec3b(color[0], color[1], color[2]);
                    }
                }
            }
            cv::addWeighted(mainImage, 0.5, colorInstance, 0.5, 0, mainImage);
        }
    }

    /*for(int i=0; i<cameraHandlers.size(); i++){
        if(i != mainCameraIndex){
            cv::Mat img = cameraHandlers[i].frame->image_ptr->toCVMat();
            cv::Mat dst;
            if(cameraHandlers[i].frame->camera_info_ptr->sensor_type == base::SensorType::THERMAL_CAMERA){
                cv::applyColorMap(img, img, cv::COLORMAP_JET);
            }
            cv::Mat homoMatrix;
            cv::eigen2cv(cameraHandlers[i].frame->camera_info_ptr->camera_homo_to_main, homoMatrix);
            cv::warpPerspective(img, dst, homoMatrix, mainImage.size());
            mainImage = cv::max(mainImage, dst);
        }
    }*/
    image->data = mainImage.data;
}


std::string TaskFusion::Name(){
    return "TaskFusion";
}


} //namespace task
} //namspace deepinfer
} //namespace waytous









