#ifndef WAYTOUS_DEEPINFER_TRACKER_BYTETRACKER_H_
#define WAYTOUS_DEEPINFER_TRACKER_BYTETRACKER_H_

#include <opencv2/opencv.hpp>

#include "interfaces/base_unit.h"

#include "libs/trackers/tracker_datatype.h"
#include "libs/trackers/track.h"
#include "libs/trackers/lapjv.h"

namespace waytous{
namespace deepinfer{
namespace tracker{


class ByteTracker: public interfaces::BaseUnit
{
public:

	bool Init(YAML::Node& node) override;
	bool Exec() override;
	std::string Name() override;

private:
	std::vector<Track*> joint_tracks(std::vector<Track*> &tlista, std::vector<Track> &tlistb);
	std::vector<Track> joint_tracks(std::vector<Track> &tlista, std::vector<Track> &tlistb);

	std::vector<Track> sub_tracks(std::vector<Track> &tlista, std::vector<Track> &tlistb);
	void remove_duplicate_tracks(std::vector<Track> &resa, std::vector<Track> &resb, std::vector<Track> &tracksa, std::vector<Track> &tracksb);

	void linear_assignment(std::vector<std::vector<float> > &cost_matrix, int cost_matrix_size, int cost_matrix_size_size, float thresh,
		std::vector<std::vector<int> > &matches, std::vector<int> &unmatched_a, std::vector<int> &unmatched_b);
	std::vector<std::vector<float> > iou_distance(std::vector<Track*> &atracks, std::vector<Track> &btracks, int &dist_size, int &dist_size_size);
	std::vector<std::vector<float> > iou_distance(std::vector<Track> &atracks, std::vector<Track> &btracks);
	std::vector<std::vector<float> > ious(std::vector<std::vector<float> > &atlbrs, std::vector<std::vector<float> > &btlbrs);

	double lapjv(const std::vector<std::vector<float> > &cost, std::vector<int> &rowsol, std::vector<int> &colsol, 
		bool extend_cost = false, float cost_limit = LONG_MAX, bool return_cost = true);

private:
	float track_thresh;
	float high_thresh;
	float match_thresh;
	int frame_id;
	int max_time_lost;
	int init_frames = 0;

	std::vector<Track> tracked_tracks;
	std::vector<Track> lost_tracks;
	std::vector<Track> removed_tracks;
	KalmanFilter kalman_filter;
}; 

DEEPINFER_REGISTER_UNIT(ByteTracker);

} //namespace tracker
} //namspace deepinfer
} //namespace waytous

#endif
