#ifndef DEEPINFER_PREPROCESS_RESIZE_NORM_H_
#define DEEPINFER_PREPROCESS_RESIZE_NORM_H_

#include <cuda_runtime.h>
#include <cstdint>

#include "interfaces/base_unit.h"
#include "base/image.h"

#include "libs/sources/camera_src.h"
#include "libs/ios/normal_ios.h"
#include "libs/ios/camera_ios.h"
#include "libs/preprocessors/resize_gpu.h"

namespace waytous {
namespace deepinfer {
namespace preprocess {



class ResizeNorm: public interfaces::BaseUnit{

public:
    bool Init(YAML::Node& node) override;

    bool Exec() override;

    std::string Name() override;

public:
    int inputHeight, inputWidth;
    int inferBatchSize = 1;
    bool fixAspectRatio = true;
    bool useBGR = false;
    base::BlobPtr<float> dst, mean, std;
    cudaStream_t stream_;
};


DEEPINFER_REGISTER_UNIT(ResizeNorm);

}  // namespace preprocess
}  // namespace deepinfer
}  // namespace waytous

#endif
