
#ifndef DEEPINFER_POSTPROCESS_TRDES_H_
#define DEEPINFER_POSTPROCESS_TRDES_H_

#include <cuda_runtime.h>
#include <cstdint>

#include "interfaces/base_unit.h"
#include "base/image.h"

#include "libs/ios/normal_ios.h"
#include "libs/ios/camera_ios.h"
#include "libs/ios/detection.h"
#include "libs/postprocessors/trades_post_gpu.h"

namespace waytous {
namespace deepinfer {
namespace postprocess {


class TraDesPostProcess: public interfaces::BaseUnit{

public:
    bool Init(YAML::Node& node) override;

    bool Exec() override;

    std::string Name() override;


public:
    base::BlobPtr<int> output_length_ptr;
    base::BlobPtr<float> bboxes_ptr;
    base::BlobPtr<int> maskCnts_lengths_ptr;
    base::BlobPtr<int> maskCnts_ptr;

    int inputHeight, inputWidth;
    int inferBatchSize = 1;
    bool fixAspectRatio = true;
    float scoreThreshold, truncatedThreshold;
    int classNumber;
    std::vector<std::string> classNames;
    int topK = 100;
    int downScale = 4;
    int segDims = 64;
    int maxCntsLength = 500;
};

DEEPINFER_REGISTER_UNIT(TraDesPostProcess);


}  // namespace postprocess
}  // namespace deepinfer
}  // namespace waytous

#endif















