
#ifndef DEEPINFER_POSTPROCESS_HOMO_PROJECT_H_
#define DEEPINFER_POSTPROCESS_HOMO_PROJECT_H_
#include <memory>
#include <string>
#include <Eigen/Dense>

#include "common/file.h"
#include "interfaces/base_unit.h"
#include "libs/ios/detection.h"

namespace waytous {
namespace deepinfer {
namespace postprocess {


class HomoProject: public interfaces::BaseUnit{

public:
    bool Init(YAML::Node& node) override;

    bool Exec() override;

    std::string Name() override;

public:
    int dst_height, dst_width;
    Eigen::Matrix<float, 3, 3, Eigen::RowMajor> camera_homo_to_main;
};

DEEPINFER_REGISTER_UNIT(HomoProject);


}  // namespace postprocess
}  // namespace deepinfer
}  // namespace waytous

#endif



