
#include "libs/ios/instance_mask.h"


namespace waytous{
namespace deepinfer{
namespace ios{

InstanceMask::InstanceMask(){
    width = -1;
    height = -1;
    rle_string = "";
};

InstanceMask::InstanceMask(const InstanceMask* mask){
    this->width = mask->width;
    this->height = mask->height;
    this->rle_string = mask->rle_string;
}

void InstanceMask::update(const InstanceMask* mask){
    this->width = mask->width;
    this->height = mask->height;
    this->rle_string = mask->rle_string;
}


InstanceMask::InstanceMask(int width, int height, const std::string &rle_string){
    this->width = width;
    this->height = height;
    this->rle_string = rle_string;
}

InstanceMask::InstanceMask(const cv::Mat &map){
    encode(map);
}

InstanceMask::InstanceMask(int width, int height, const char* data){
    this->width = width;
    this->height = height;
    encode(data);
}

InstanceMask::InstanceMask(int width, int height, const int* cnts, int length){
    this->width = width;
    this->height = height;
    encode(cnts, length);
}

cv::Mat InstanceMask::decode(){
    int m=0, p=0, k; long x; int more;
    std::vector<uint> cnts;
    while(rle_string[p]) {
        x=0; k=0; more=1;
        while(more) {
            char c = rle_string[p] - 48;
            x |= (c & 0x1f) << 5*k;
            more = c & 0x20;
            p++; k++;
            if(!more && (c & 0x10))
                x |= -1 << 5*k;
        }
        if(m>2)
            x += (long) cnts[m-2];
        cnts.push_back((uint)x);
        m++;
    }
    bool v=0;
    cv::Mat M = cv::Mat::zeros(cv::Size(width, height), CV_8UC1);
    int index = 0;
    for( int j=0; j<m; j++ ) {
        for( k=0; k<cnts[j]; k++ ){
            M.at<uchar>(index++) = v;
        }
        v=!v;
    }
    // std::cout<<index<<"--777777777777777777"<<std::endl;
    return M;
}

void InstanceMask::encode(const char* data){
    uint count = 0;
    char p = 0;
    std::vector<uint> cnts; 
    for (int i = 0; i < height * width; i++){
        if(*(data + i) != p){
            cnts.push_back(count);
            count = 0;
            p = *(data + i);
        }
        count++;
    }
    long x; int more;
    int m = cnts.size();
    for(int i=0; i<m; i++ ) {
        x=(long) cnts[i]; 
        if(i>2) 
            x -= (long) cnts[i-2];
        more = 1;
        while( more ) {
            char c=x & 0x1f;
            x >>= 5;
            more = (c & 0x10) ? x!=-1 : x!=0;
            if(more)
                c |= 0x20;
            c += 48;
            rle_string.push_back(c);
        }
    }
}

void InstanceMask::encode(const int* cnts, int length){
    long x; int more;
    for(int i=0; i<length; i++ ) {
        x=(long) cnts[i]; 
        if(i>2) 
            x -= (long) cnts[i-2];
        more = 1;
        while( more ) {
            char c=x & 0x1f;
            x >>= 5;
            more = (c & 0x10) ? x!=-1 : x!=0;
            if(more)
                c |= 0x20;
            c += 48;
            rle_string.push_back(c);
        }
    }
}

void InstanceMask::encode(const cv::Mat& map){
    height = map.rows;
    width = map.cols;
    uint count = 0;
    char p = 0;
    std::vector<uint> cnts; 
    for (int i=0; i<height; i++){
        for(int j=0; j<width; j++){
            if(map.at<char>(i, j) != p){
                cnts.push_back(count);
                count = 0;
                p = map.at<char>(i, j);
            }
            count++;
        }
    }
    long x; int more;
    int m = cnts.size();
    for(int i=0; i<m; i++ ) {
        x=(long) cnts[i]; 
        if(i>2) 
            x -= (long) cnts[i-2];
        more = 1;
        while( more ) {
            char c=x & 0x1f;
            x >>= 5;
            more = (c & 0x10) ? x!=-1 : x!=0;
            if(more)
                c |= 0x20;
            c += 48;
            rle_string.push_back(c);
        }
    }
}


} //namespace ios
} //namspace deepinfer
} //namespace waytous


