
#include "libs/ios/detection.h"

namespace waytous {
namespace deepinfer {
namespace ios {

void Det2D::validCoordinate(){
    if(image_width <= 0 || image_height <= 0){
        LOG_WARN << "Detection should set image_width > 0 and image_height > 0";
        return;
    }
    x1 = iMIN(image_width - 1, iMAX(0, x1));
    x2 = iMIN(image_width - 1, iMAX(0, x2));
    y1 = iMIN(image_height - 1, iMAX(0, y1));
    y2 = iMIN(image_height - 1, iMAX(0, y2));
}


Det2DPtr Det2D::copy(){
    Det2DPtr obj = std::make_shared<Det2D>(Det2D());
    obj->image_height = this->image_height;
    obj->image_width = this->image_width;
    obj->x1 = this->x1;
    obj->x2 = this->x2;
    obj->y1 = this->y1;
    obj->y2 = this->y2;
    obj->confidence = this->confidence;
    obj->class_label = this->class_label;
    obj->class_name = this->class_name;
    obj->truncated = this->truncated;
    obj->track_id = this->track_id;
    obj->camera_id = this->camera_id;
    if (this->mask_ptr != nullptr){
        obj->mask_ptr.reset(new InstanceMask(this->mask_ptr.get()));
    }
    return obj;
}

void Det2D::update(Det2DPtr obj_){
    this->image_height = obj_->image_height;
    this->image_width = obj_->image_width;
    this->x1 = obj_->x1;
    this->x2 = obj_->x2;
    this->y1 = obj_->y1;
    this->y2 = obj_->y2;
    this->confidence = obj_->confidence;
    this->class_label = obj_->class_label;
    this->class_name = obj_->class_name;
    this->truncated = obj_->truncated;
    // this->track_id = obj_->track_id;// don't update track_id, because they matched and get same track_id.
    this->camera_id = obj_->camera_id;
    if (obj_->mask_ptr != nullptr){
        this->mask_ptr->update(obj_->mask_ptr.get());
    }
};


void Det2D::update(std::vector<float>& tlbr){
    this->x1 = tlbr[0];
    this->y1 = tlbr[1];
    this->x2 = tlbr[2];
    this->y2 = tlbr[3];
};


float Det2D::area(){
    return (x2 -  x1) * (y2 - y1);
};

float Det2D::uniArea(Det2DPtr other){
    float out_width = std::max(x2, other->x2) - std::min(x1, other->x1);
    float out_height = std::max(y2, other->y2) - std::min(y1, other->y1);
    return out_width * out_height;
};


float Det2D::insectionArea(Det2DPtr other){
    float in_width = std::min(x2, other->x2) - std::max(x1, other->x1);
    float in_height = std::min(y2, other->y2) - std::max(y1, other->y1);
    if(in_width <= 0 || in_height <= 0){
        return 0;
    }
    return in_width * in_height;

};



}  // namespace ios
}  // namespace deepinfer
}  // namespace waytous







